/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL;
import org.lwjgl.opencl.CL12;
import org.lwjgl.opencl.CLSVMFreeCallbackI;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;

public class CL20
extends CL12 {
    public static final int CL_VERSION_2_0 = 1;
    public static final int CL_INVALID_PIPE_SIZE = -69;
    public static final int CL_INVALID_DEVICE_QUEUE = -70;
    public static final int CL_DEVICE_QUEUE_ON_HOST_PROPERTIES = 4138;
    public static final int CL_DEVICE_IMAGE_PITCH_ALIGNMENT = 4170;
    public static final int CL_DEVICE_IMAGE_BASE_ADDRESS_ALIGNMENT = 4171;
    public static final int CL_DEVICE_MAX_READ_WRITE_IMAGE_ARGS = 4172;
    public static final int CL_DEVICE_MAX_GLOBAL_VARIABLE_SIZE = 4173;
    public static final int CL_DEVICE_QUEUE_ON_DEVICE_PROPERTIES = 4174;
    public static final int CL_DEVICE_QUEUE_ON_DEVICE_PREFERRED_SIZE = 4175;
    public static final int CL_DEVICE_QUEUE_ON_DEVICE_MAX_SIZE = 4176;
    public static final int CL_DEVICE_MAX_ON_DEVICE_QUEUES = 4177;
    public static final int CL_DEVICE_MAX_ON_DEVICE_EVENTS = 4178;
    public static final int CL_DEVICE_SVM_CAPABILITIES = 4179;
    public static final int CL_DEVICE_GLOBAL_VARIABLE_PREFERRED_TOTAL_SIZE = 4180;
    public static final int CL_DEVICE_MAX_PIPE_ARGS = 4181;
    public static final int CL_DEVICE_PIPE_MAX_ACTIVE_RESERVATIONS = 4182;
    public static final int CL_DEVICE_PIPE_MAX_PACKET_SIZE = 4183;
    public static final int CL_DEVICE_PREFERRED_PLATFORM_ATOMIC_ALIGNMENT = 4184;
    public static final int CL_DEVICE_PREFERRED_GLOBAL_ATOMIC_ALIGNMENT = 4185;
    public static final int CL_DEVICE_PREFERRED_LOCAL_ATOMIC_ALIGNMENT = 4186;
    public static final int CL_QUEUE_ON_DEVICE = 4;
    public static final int CL_QUEUE_ON_DEVICE_DEFAULT = 8;
    public static final int CL_DEVICE_SVM_COARSE_GRAIN_BUFFER = 1;
    public static final int CL_DEVICE_SVM_FINE_GRAIN_BUFFER = 2;
    public static final int CL_DEVICE_SVM_FINE_GRAIN_SYSTEM = 4;
    public static final int CL_DEVICE_SVM_ATOMICS = 8;
    public static final int CL_QUEUE_SIZE = 4244;
    public static final int CL_MEM_SVM_FINE_GRAIN_BUFFER = 1024;
    public static final int CL_MEM_SVM_ATOMICS = 2048;
    public static final int CL_MEM_KERNEL_READ_AND_WRITE = 4096;
    public static final int CL_MEM_OBJECT_PIPE = 4343;
    public static final int CL_MEM_USES_SVM_POINTER = 4361;
    public static final int CL_sRGB = 4287;
    public static final int CL_sRGBx = 4288;
    public static final int CL_sRGBA = 4289;
    public static final int CL_sBGRA = 4290;
    public static final int CL_ABGR = 4291;
    public static final int CL_PIPE_PACKET_SIZE = 4384;
    public static final int CL_PIPE_MAX_PACKETS = 4385;
    public static final int CL_SAMPLER_MIP_FILTER_MODE = 4437;
    public static final int CL_SAMPLER_LOD_MIN = 4438;
    public static final int CL_SAMPLER_LOD_MAX = 4439;
    public static final int CL_PROGRAM_BUILD_GLOBAL_VARIABLE_TOTAL_SIZE = 4485;
    public static final int CL_KERNEL_ARG_TYPE_PIPE = 8;
    public static final int CL_KERNEL_EXEC_INFO_SVM_PTRS = 4534;
    public static final int CL_KERNEL_EXEC_INFO_SVM_FINE_GRAIN_SYSTEM = 4535;
    public static final int CL_COMMAND_SVM_FREE = 4617;
    public static final int CL_COMMAND_SVM_MEMCPY = 4618;
    public static final int CL_COMMAND_SVM_MEMFILL = 4619;
    public static final int CL_COMMAND_SVM_MAP = 4620;
    public static final int CL_COMMAND_SVM_UNMAP = 4621;
    public static final int CL_PROFILING_COMMAND_COMPLETE = 4740;

    protected CL20() {
        throw new UnsupportedOperationException();
    }

    public static long nclCreateCommandQueueWithProperties(long context, long device, long properties, long errcode_ret) {
        long __functionAddress = CL.getICD().clCreateCommandQueueWithProperties;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(context);
            Checks.check(device);
        }
        return JNI.callPPPPP(context, device, properties, errcode_ret, __functionAddress);
    }

    @NativeType(value="cl_command_queue")
    public static long clCreateCommandQueueWithProperties(@NativeType(value="cl_context") long context, @NativeType(value="cl_device_id") long device, @NativeType(value="cl_queue_properties const *") @Nullable LongBuffer properties, @NativeType(value="cl_int *") @Nullable IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(properties);
            Checks.checkSafe((Buffer)errcode_ret, 1);
        }
        return CL20.nclCreateCommandQueueWithProperties(context, device, MemoryUtil.memAddressSafe(properties), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long nclCreatePipe(long context, long flags, int pipe_packet_size, int pipe_max_packets, long properties, long errcode_ret) {
        long __functionAddress = CL.getICD().clCreatePipe;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(context);
        }
        return JNI.callPJPPP(context, flags, pipe_packet_size, pipe_max_packets, properties, errcode_ret, __functionAddress);
    }

    @NativeType(value="cl_mem")
    public static long clCreatePipe(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="cl_uint") int pipe_packet_size, @NativeType(value="cl_uint") int pipe_max_packets, @NativeType(value="cl_pipe_properties const *") @Nullable PointerBuffer properties, @NativeType(value="cl_int *") @Nullable IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(properties);
            Checks.checkSafe((Buffer)errcode_ret, 1);
        }
        return CL20.nclCreatePipe(context, flags, pipe_packet_size, pipe_max_packets, MemoryUtil.memAddressSafe(properties), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static int nclGetPipeInfo(long pipe, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetPipeInfo;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pipe);
        }
        return JNI.callPPPPI(pipe, param_name, param_value_size, param_value, param_value_size_ret, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetPipeInfo(@NativeType(value="cl_mem") long pipe, @NativeType(value="cl_pipe_info") int param_name, @NativeType(value="void *") @Nullable ByteBuffer param_value, @NativeType(value="size_t *") @Nullable PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return CL20.nclGetPipeInfo(pipe, param_name, Checks.remainingSafe(param_value), MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetPipeInfo(@NativeType(value="cl_mem") long pipe, @NativeType(value="cl_pipe_info") int param_name, @NativeType(value="void *") @Nullable IntBuffer param_value, @NativeType(value="size_t *") @Nullable PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return CL20.nclGetPipeInfo(pipe, param_name, Integer.toUnsignedLong(Checks.remainingSafe(param_value)) << 2, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static long nclSVMAlloc(long context, long flags, long size, int alignment) {
        long __functionAddress = CL.getICD().clSVMAlloc;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(context);
        }
        return JNI.callPJPP(context, flags, size, alignment, __functionAddress);
    }

    @NativeType(value="void *")
    public static @Nullable ByteBuffer clSVMAlloc(@NativeType(value="cl_context") long context, @NativeType(value="cl_svm_mem_flags") long flags, @NativeType(value="size_t") long size, @NativeType(value="unsigned int") int alignment) {
        long __result = CL20.nclSVMAlloc(context, flags, size, alignment);
        return MemoryUtil.memByteBufferSafe(__result, (int)size);
    }

    public static void nclSVMFree(long context, long svm_pointer) {
        long __functionAddress = CL.getICD().clSVMFree;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(context);
        }
        JNI.callPPV(context, svm_pointer, __functionAddress);
    }

    public static void clSVMFree(@NativeType(value="cl_context") long context, @NativeType(value="void *") ByteBuffer svm_pointer) {
        CL20.nclSVMFree(context, MemoryUtil.memAddress(svm_pointer));
    }

    public static int nclEnqueueSVMFree(long command_queue, int num_svm_pointers, long svm_pointers, long pfn_free_func, long user_data, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueSVMFree;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_queue);
        }
        return JNI.callPPPPPPI(command_queue, num_svm_pointers, svm_pointers, pfn_free_func, user_data, num_events_in_wait_list, event_wait_list, event, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueSVMFree(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="void **") PointerBuffer svm_pointers, @NativeType(value="void (*) (cl_command_queue, cl_uint, void **, void *)") @Nullable CLSVMFreeCallbackI pfn_free_func, @NativeType(value="void *") long user_data, @NativeType(value="cl_event const *") @Nullable PointerBuffer event_wait_list, @NativeType(value="cl_event *") @Nullable PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe(event, 1);
        }
        return CL20.nclEnqueueSVMFree(command_queue, svm_pointers.remaining(), MemoryUtil.memAddress(svm_pointers), MemoryUtil.memAddressSafe(pfn_free_func), user_data, Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int nclEnqueueSVMMemcpy(long command_queue, int blocking_copy, long dst_ptr, long src_ptr, long size, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueSVMMemcpy;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_queue);
        }
        return JNI.callPPPPPPI(command_queue, blocking_copy, dst_ptr, src_ptr, size, num_events_in_wait_list, event_wait_list, event, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueSVMMemcpy(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_bool") boolean blocking_copy, @NativeType(value="void *") ByteBuffer dst_ptr, @NativeType(value="void const *") ByteBuffer src_ptr, @NativeType(value="cl_event const *") @Nullable PointerBuffer event_wait_list, @NativeType(value="cl_event *") @Nullable PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)dst_ptr, src_ptr.remaining());
            Checks.checkSafe(event, 1);
        }
        return CL20.nclEnqueueSVMMemcpy(command_queue, blocking_copy ? 1 : 0, MemoryUtil.memAddress(dst_ptr), MemoryUtil.memAddress(src_ptr), src_ptr.remaining(), Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int nclEnqueueSVMMemFill(long command_queue, long svm_ptr, long pattern, long pattern_size, long size, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueSVMMemFill;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_queue);
        }
        return JNI.callPPPPPPPI(command_queue, svm_ptr, pattern, pattern_size, size, num_events_in_wait_list, event_wait_list, event, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueSVMMemFill(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="void *") ByteBuffer svm_ptr, @NativeType(value="void const *") ByteBuffer pattern, @NativeType(value="cl_event const *") @Nullable PointerBuffer event_wait_list, @NativeType(value="cl_event *") @Nullable PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe(event, 1);
        }
        return CL20.nclEnqueueSVMMemFill(command_queue, MemoryUtil.memAddress(svm_ptr), MemoryUtil.memAddress(pattern), pattern.remaining(), svm_ptr.remaining(), Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int nclEnqueueSVMMap(long command_queue, int blocking_map, long map_flags, long svm_ptr, long size, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueSVMMap;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_queue);
        }
        return JNI.callPJPPPPI(command_queue, blocking_map, map_flags, svm_ptr, size, num_events_in_wait_list, event_wait_list, event, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueSVMMap(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_bool") boolean blocking_map, @NativeType(value="cl_map_flags") long map_flags, @NativeType(value="void *") ByteBuffer svm_ptr, @NativeType(value="cl_event const *") @Nullable PointerBuffer event_wait_list, @NativeType(value="cl_event *") @Nullable PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe(event, 1);
        }
        return CL20.nclEnqueueSVMMap(command_queue, blocking_map ? 1 : 0, map_flags, MemoryUtil.memAddress(svm_ptr), svm_ptr.remaining(), Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int nclEnqueueSVMUnmap(long command_queue, long svm_ptr, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueSVMUnmap;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_queue);
        }
        return JNI.callPPPPI(command_queue, svm_ptr, num_events_in_wait_list, event_wait_list, event, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueSVMUnmap(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="void *") ByteBuffer svm_ptr, @NativeType(value="cl_event const *") @Nullable PointerBuffer event_wait_list, @NativeType(value="cl_event *") @Nullable PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe(event, 1);
        }
        return CL20.nclEnqueueSVMUnmap(command_queue, MemoryUtil.memAddress(svm_ptr), Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int nclSetKernelArgSVMPointer(long kernel, int arg_index, long arg_value) {
        long __functionAddress = CL.getICD().clSetKernelArgSVMPointer;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(kernel);
        }
        return JNI.callPPI(kernel, arg_index, arg_value, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clSetKernelArgSVMPointer(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") ByteBuffer arg_value) {
        return CL20.nclSetKernelArgSVMPointer(kernel, arg_index, MemoryUtil.memAddress(arg_value));
    }

    public static int nclSetKernelExecInfo(long kernel, int param_name, long param_value_size, long param_value) {
        long __functionAddress = CL.getICD().clSetKernelExecInfo;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(kernel);
        }
        return JNI.callPPPI(kernel, param_name, param_value_size, param_value, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clSetKernelExecInfo(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_kernel_exec_info") int param_name, @NativeType(value="void const *") ByteBuffer param_value) {
        return CL20.nclSetKernelExecInfo(kernel, param_name, param_value.remaining(), MemoryUtil.memAddress(param_value));
    }

    @NativeType(value="cl_int")
    public static int clSetKernelExecInfo(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_kernel_exec_info") int param_name, @NativeType(value="void const *") PointerBuffer param_value) {
        return CL20.nclSetKernelExecInfo(kernel, param_name, Integer.toUnsignedLong(param_value.remaining()) << Pointer.POINTER_SHIFT, MemoryUtil.memAddress(param_value));
    }

    @NativeType(value="cl_int")
    public static int clSetKernelExecInfo(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_kernel_exec_info") int param_name, @NativeType(value="void const *") IntBuffer param_value) {
        return CL20.nclSetKernelExecInfo(kernel, param_name, Integer.toUnsignedLong(param_value.remaining()) << 2, MemoryUtil.memAddress(param_value));
    }

    public static long nclCreateSamplerWithProperties(long context, long sampler_properties, long errcode_ret) {
        long __functionAddress = CL.getICD().clCreateSamplerWithProperties;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(context);
        }
        return JNI.callPPPP(context, sampler_properties, errcode_ret, __functionAddress);
    }

    @NativeType(value="cl_sampler")
    public static long clCreateSamplerWithProperties(@NativeType(value="cl_context") long context, @NativeType(value="cl_sampler_properties const *") @Nullable LongBuffer sampler_properties, @NativeType(value="cl_int *") @Nullable IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(sampler_properties);
            Checks.checkSafe((Buffer)errcode_ret, 1);
        }
        return CL20.nclCreateSamplerWithProperties(context, MemoryUtil.memAddressSafe(sampler_properties), MemoryUtil.memAddressSafe(errcode_ret));
    }

    @NativeType(value="cl_command_queue")
    public static long clCreateCommandQueueWithProperties(@NativeType(value="cl_context") long context, @NativeType(value="cl_device_id") long device, @NativeType(value="cl_queue_properties const *") long @Nullable [] properties, @NativeType(value="cl_int *") int @Nullable [] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateCommandQueueWithProperties;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(context);
            Checks.check(device);
            Checks.checkNTSafe(properties);
            Checks.checkSafe(errcode_ret, 1);
        }
        return JNI.callPPPPP(context, device, properties, errcode_ret, __functionAddress);
    }

    @NativeType(value="cl_mem")
    public static long clCreatePipe(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="cl_uint") int pipe_packet_size, @NativeType(value="cl_uint") int pipe_max_packets, @NativeType(value="cl_pipe_properties const *") @Nullable PointerBuffer properties, @NativeType(value="cl_int *") int @Nullable [] errcode_ret) {
        long __functionAddress = CL.getICD().clCreatePipe;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(context);
            Checks.checkNTSafe(properties);
            Checks.checkSafe(errcode_ret, 1);
        }
        return JNI.callPJPPP(context, flags, pipe_packet_size, pipe_max_packets, MemoryUtil.memAddressSafe(properties), errcode_ret, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetPipeInfo(@NativeType(value="cl_mem") long pipe, @NativeType(value="cl_pipe_info") int param_name, @NativeType(value="void *") int @Nullable [] param_value, @NativeType(value="size_t *") @Nullable PointerBuffer param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetPipeInfo;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pipe);
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return JNI.callPPPPI(pipe, param_name, Integer.toUnsignedLong(Checks.lengthSafe(param_value)) << 2, param_value, MemoryUtil.memAddressSafe(param_value_size_ret), __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clSetKernelExecInfo(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_kernel_exec_info") int param_name, @NativeType(value="void const *") int[] param_value) {
        long __functionAddress = CL.getICD().clSetKernelExecInfo;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(kernel);
        }
        return JNI.callPPPI(kernel, param_name, Integer.toUnsignedLong(param_value.length) << 2, param_value, __functionAddress);
    }

    @NativeType(value="cl_sampler")
    public static long clCreateSamplerWithProperties(@NativeType(value="cl_context") long context, @NativeType(value="cl_sampler_properties const *") long @Nullable [] sampler_properties, @NativeType(value="cl_int *") int @Nullable [] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateSamplerWithProperties;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(context);
            Checks.checkNTSafe(sampler_properties);
            Checks.checkSafe(errcode_ret, 1);
        }
        return JNI.callPPPP(context, sampler_properties, errcode_ret, __functionAddress);
    }
}

