/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct HmdMatrix34_t")
public class HmdMatrix34
extends Struct<HmdMatrix34>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int M;

    protected HmdMatrix34(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected HmdMatrix34 create(long address, @Nullable ByteBuffer container) {
        return new HmdMatrix34(address, container);
    }

    public HmdMatrix34(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), HmdMatrix34.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="float[12]")
    public FloatBuffer m() {
        return HmdMatrix34.nm(this.address());
    }

    public float m(int index) {
        return HmdMatrix34.nm(this.address(), index);
    }

    public HmdMatrix34 m(@NativeType(value="float[12]") FloatBuffer value) {
        HmdMatrix34.nm(this.address(), value);
        return this;
    }

    public HmdMatrix34 m(int index, float value) {
        HmdMatrix34.nm(this.address(), index, value);
        return this;
    }

    public HmdMatrix34 set(HmdMatrix34 src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static HmdMatrix34 malloc() {
        return new HmdMatrix34(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static HmdMatrix34 calloc() {
        return new HmdMatrix34(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static HmdMatrix34 create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new HmdMatrix34(MemoryUtil.memAddress(container), container);
    }

    public static HmdMatrix34 create(long address) {
        return new HmdMatrix34(address, null);
    }

    public static @Nullable HmdMatrix34 createSafe(long address) {
        return address == 0L ? null : new HmdMatrix34(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(HmdMatrix34.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = HmdMatrix34.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static HmdMatrix34 mallocStack() {
        return HmdMatrix34.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static HmdMatrix34 callocStack() {
        return HmdMatrix34.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static HmdMatrix34 mallocStack(MemoryStack stack) {
        return HmdMatrix34.malloc(stack);
    }

    @Deprecated
    public static HmdMatrix34 callocStack(MemoryStack stack) {
        return HmdMatrix34.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return HmdMatrix34.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return HmdMatrix34.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return HmdMatrix34.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return HmdMatrix34.calloc(capacity, stack);
    }

    public static HmdMatrix34 malloc(MemoryStack stack) {
        return new HmdMatrix34(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static HmdMatrix34 calloc(MemoryStack stack) {
        return new HmdMatrix34(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static FloatBuffer nm(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)M, 12);
    }

    public static float nm(long struct, int index) {
        return MemoryUtil.memGetFloat(struct + (long)M + Checks.check(index, 12) * 4L);
    }

    public static void nm(long struct, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 12);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)M, value.remaining() * 4);
    }

    public static void nm(long struct, int index, float value) {
        MemoryUtil.memPutFloat(struct + (long)M + Checks.check(index, 12) * 4L, value);
    }

    static {
        Struct.Layout layout = HmdMatrix34.__struct(HmdMatrix34.__array(4, 12));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        M = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<HmdMatrix34, Buffer>
    implements NativeResource {
        private static final HmdMatrix34 ELEMENT_FACTORY = HmdMatrix34.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected HmdMatrix34 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="float[12]")
        public FloatBuffer m() {
            return HmdMatrix34.nm(this.address());
        }

        public float m(int index) {
            return HmdMatrix34.nm(this.address(), index);
        }

        public Buffer m(@NativeType(value="float[12]") FloatBuffer value) {
            HmdMatrix34.nm(this.address(), value);
            return this;
        }

        public Buffer m(int index, float value) {
            HmdMatrix34.nm(this.address(), index, value);
            return this;
        }
    }
}

