/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct HmdQuaternion_t")
public class HmdQuaternion
extends Struct<HmdQuaternion>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int W;
    public static final int X;
    public static final int Y;
    public static final int Z;

    protected HmdQuaternion(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected HmdQuaternion create(long address, @Nullable ByteBuffer container) {
        return new HmdQuaternion(address, container);
    }

    public HmdQuaternion(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), HmdQuaternion.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public double w() {
        return HmdQuaternion.nw(this.address());
    }

    public double x() {
        return HmdQuaternion.nx(this.address());
    }

    public double y() {
        return HmdQuaternion.ny(this.address());
    }

    public double z() {
        return HmdQuaternion.nz(this.address());
    }

    public HmdQuaternion w(double value) {
        HmdQuaternion.nw(this.address(), value);
        return this;
    }

    public HmdQuaternion x(double value) {
        HmdQuaternion.nx(this.address(), value);
        return this;
    }

    public HmdQuaternion y(double value) {
        HmdQuaternion.ny(this.address(), value);
        return this;
    }

    public HmdQuaternion z(double value) {
        HmdQuaternion.nz(this.address(), value);
        return this;
    }

    public HmdQuaternion set(double w, double x, double y, double z) {
        this.w(w);
        this.x(x);
        this.y(y);
        this.z(z);
        return this;
    }

    public HmdQuaternion set(HmdQuaternion src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static HmdQuaternion malloc() {
        return new HmdQuaternion(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static HmdQuaternion calloc() {
        return new HmdQuaternion(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static HmdQuaternion create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new HmdQuaternion(MemoryUtil.memAddress(container), container);
    }

    public static HmdQuaternion create(long address) {
        return new HmdQuaternion(address, null);
    }

    public static @Nullable HmdQuaternion createSafe(long address) {
        return address == 0L ? null : new HmdQuaternion(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(HmdQuaternion.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = HmdQuaternion.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static HmdQuaternion mallocStack() {
        return HmdQuaternion.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static HmdQuaternion callocStack() {
        return HmdQuaternion.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static HmdQuaternion mallocStack(MemoryStack stack) {
        return HmdQuaternion.malloc(stack);
    }

    @Deprecated
    public static HmdQuaternion callocStack(MemoryStack stack) {
        return HmdQuaternion.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return HmdQuaternion.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return HmdQuaternion.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return HmdQuaternion.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return HmdQuaternion.calloc(capacity, stack);
    }

    public static HmdQuaternion malloc(MemoryStack stack) {
        return new HmdQuaternion(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static HmdQuaternion calloc(MemoryStack stack) {
        return new HmdQuaternion(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static double nw(long struct) {
        return MemoryUtil.memGetDouble(struct + (long)W);
    }

    public static double nx(long struct) {
        return MemoryUtil.memGetDouble(struct + (long)X);
    }

    public static double ny(long struct) {
        return MemoryUtil.memGetDouble(struct + (long)Y);
    }

    public static double nz(long struct) {
        return MemoryUtil.memGetDouble(struct + (long)Z);
    }

    public static void nw(long struct, double value) {
        MemoryUtil.memPutDouble(struct + (long)W, value);
    }

    public static void nx(long struct, double value) {
        MemoryUtil.memPutDouble(struct + (long)X, value);
    }

    public static void ny(long struct, double value) {
        MemoryUtil.memPutDouble(struct + (long)Y, value);
    }

    public static void nz(long struct, double value) {
        MemoryUtil.memPutDouble(struct + (long)Z, value);
    }

    static {
        Struct.Layout layout = HmdQuaternion.__struct(HmdQuaternion.__member(8), HmdQuaternion.__member(8), HmdQuaternion.__member(8), HmdQuaternion.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        W = layout.offsetof(0);
        X = layout.offsetof(1);
        Y = layout.offsetof(2);
        Z = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<HmdQuaternion, Buffer>
    implements NativeResource {
        private static final HmdQuaternion ELEMENT_FACTORY = HmdQuaternion.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected HmdQuaternion getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public double w() {
            return HmdQuaternion.nw(this.address());
        }

        public double x() {
            return HmdQuaternion.nx(this.address());
        }

        public double y() {
            return HmdQuaternion.ny(this.address());
        }

        public double z() {
            return HmdQuaternion.nz(this.address());
        }

        public Buffer w(double value) {
            HmdQuaternion.nw(this.address(), value);
            return this;
        }

        public Buffer x(double value) {
            HmdQuaternion.nx(this.address(), value);
            return this;
        }

        public Buffer y(double value) {
            HmdQuaternion.ny(this.address(), value);
            return this;
        }

        public Buffer z(double value) {
            HmdQuaternion.nz(this.address(), value);
            return this;
        }
    }
}

