/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct HmdQuaternionf_t")
public class HmdQuaternionf
extends Struct<HmdQuaternionf>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int W;
    public static final int X;
    public static final int Y;
    public static final int Z;

    protected HmdQuaternionf(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected HmdQuaternionf create(long address, @Nullable ByteBuffer container) {
        return new HmdQuaternionf(address, container);
    }

    public HmdQuaternionf(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), HmdQuaternionf.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float w() {
        return HmdQuaternionf.nw(this.address());
    }

    public float x() {
        return HmdQuaternionf.nx(this.address());
    }

    public float y() {
        return HmdQuaternionf.ny(this.address());
    }

    public float z() {
        return HmdQuaternionf.nz(this.address());
    }

    public HmdQuaternionf w(float value) {
        HmdQuaternionf.nw(this.address(), value);
        return this;
    }

    public HmdQuaternionf x(float value) {
        HmdQuaternionf.nx(this.address(), value);
        return this;
    }

    public HmdQuaternionf y(float value) {
        HmdQuaternionf.ny(this.address(), value);
        return this;
    }

    public HmdQuaternionf z(float value) {
        HmdQuaternionf.nz(this.address(), value);
        return this;
    }

    public HmdQuaternionf set(float w, float x, float y, float z) {
        this.w(w);
        this.x(x);
        this.y(y);
        this.z(z);
        return this;
    }

    public HmdQuaternionf set(HmdQuaternionf src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static HmdQuaternionf malloc() {
        return new HmdQuaternionf(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static HmdQuaternionf calloc() {
        return new HmdQuaternionf(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static HmdQuaternionf create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new HmdQuaternionf(MemoryUtil.memAddress(container), container);
    }

    public static HmdQuaternionf create(long address) {
        return new HmdQuaternionf(address, null);
    }

    public static @Nullable HmdQuaternionf createSafe(long address) {
        return address == 0L ? null : new HmdQuaternionf(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(HmdQuaternionf.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = HmdQuaternionf.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static HmdQuaternionf mallocStack() {
        return HmdQuaternionf.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static HmdQuaternionf callocStack() {
        return HmdQuaternionf.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static HmdQuaternionf mallocStack(MemoryStack stack) {
        return HmdQuaternionf.malloc(stack);
    }

    @Deprecated
    public static HmdQuaternionf callocStack(MemoryStack stack) {
        return HmdQuaternionf.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return HmdQuaternionf.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return HmdQuaternionf.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return HmdQuaternionf.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return HmdQuaternionf.calloc(capacity, stack);
    }

    public static HmdQuaternionf malloc(MemoryStack stack) {
        return new HmdQuaternionf(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static HmdQuaternionf calloc(MemoryStack stack) {
        return new HmdQuaternionf(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nw(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)W);
    }

    public static float nx(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)X);
    }

    public static float ny(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)Y);
    }

    public static float nz(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)Z);
    }

    public static void nw(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)W, value);
    }

    public static void nx(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)X, value);
    }

    public static void ny(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)Y, value);
    }

    public static void nz(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)Z, value);
    }

    static {
        Struct.Layout layout = HmdQuaternionf.__struct(HmdQuaternionf.__member(4), HmdQuaternionf.__member(4), HmdQuaternionf.__member(4), HmdQuaternionf.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        W = layout.offsetof(0);
        X = layout.offsetof(1);
        Y = layout.offsetof(2);
        Z = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<HmdQuaternionf, Buffer>
    implements NativeResource {
        private static final HmdQuaternionf ELEMENT_FACTORY = HmdQuaternionf.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected HmdQuaternionf getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float w() {
            return HmdQuaternionf.nw(this.address());
        }

        public float x() {
            return HmdQuaternionf.nx(this.address());
        }

        public float y() {
            return HmdQuaternionf.ny(this.address());
        }

        public float z() {
            return HmdQuaternionf.nz(this.address());
        }

        public Buffer w(float value) {
            HmdQuaternionf.nw(this.address(), value);
            return this;
        }

        public Buffer x(float value) {
            HmdQuaternionf.nx(this.address(), value);
            return this;
        }

        public Buffer y(float value) {
            HmdQuaternionf.ny(this.address(), value);
            return this;
        }

        public Buffer z(float value) {
            HmdQuaternionf.nz(this.address(), value);
            return this;
        }
    }
}

