/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct InputBindingInfo_t")
public class InputBindingInfo
extends Struct<InputBindingInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int RCHDEVICEPATHNAME;
    public static final int RCHINPUTPATHNAME;
    public static final int RCHMODENAME;
    public static final int RCHSLOTNAME;
    public static final int RCHINPUTSOURCETYPE;

    protected InputBindingInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected InputBindingInfo create(long address, @Nullable ByteBuffer container) {
        return new InputBindingInfo(address, container);
    }

    public InputBindingInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), InputBindingInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char[128]")
    public ByteBuffer rchDevicePathName() {
        return InputBindingInfo.nrchDevicePathName(this.address());
    }

    @NativeType(value="char[128]")
    public String rchDevicePathNameString() {
        return InputBindingInfo.nrchDevicePathNameString(this.address());
    }

    @NativeType(value="char[128]")
    public ByteBuffer rchInputPathName() {
        return InputBindingInfo.nrchInputPathName(this.address());
    }

    @NativeType(value="char[128]")
    public String rchInputPathNameString() {
        return InputBindingInfo.nrchInputPathNameString(this.address());
    }

    @NativeType(value="char[128]")
    public ByteBuffer rchModeName() {
        return InputBindingInfo.nrchModeName(this.address());
    }

    @NativeType(value="char[128]")
    public String rchModeNameString() {
        return InputBindingInfo.nrchModeNameString(this.address());
    }

    @NativeType(value="char[128]")
    public ByteBuffer rchSlotName() {
        return InputBindingInfo.nrchSlotName(this.address());
    }

    @NativeType(value="char[128]")
    public String rchSlotNameString() {
        return InputBindingInfo.nrchSlotNameString(this.address());
    }

    @NativeType(value="char[32]")
    public ByteBuffer rchInputSourceType() {
        return InputBindingInfo.nrchInputSourceType(this.address());
    }

    @NativeType(value="char[32]")
    public String rchInputSourceTypeString() {
        return InputBindingInfo.nrchInputSourceTypeString(this.address());
    }

    public static InputBindingInfo malloc() {
        return new InputBindingInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static InputBindingInfo calloc() {
        return new InputBindingInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static InputBindingInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new InputBindingInfo(MemoryUtil.memAddress(container), container);
    }

    public static InputBindingInfo create(long address) {
        return new InputBindingInfo(address, null);
    }

    public static @Nullable InputBindingInfo createSafe(long address) {
        return address == 0L ? null : new InputBindingInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(InputBindingInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = InputBindingInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static InputBindingInfo mallocStack() {
        return InputBindingInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static InputBindingInfo callocStack() {
        return InputBindingInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static InputBindingInfo mallocStack(MemoryStack stack) {
        return InputBindingInfo.malloc(stack);
    }

    @Deprecated
    public static InputBindingInfo callocStack(MemoryStack stack) {
        return InputBindingInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return InputBindingInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return InputBindingInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return InputBindingInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return InputBindingInfo.calloc(capacity, stack);
    }

    public static InputBindingInfo malloc(MemoryStack stack) {
        return new InputBindingInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static InputBindingInfo calloc(MemoryStack stack) {
        return new InputBindingInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nrchDevicePathName(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)RCHDEVICEPATHNAME, 128);
    }

    public static String nrchDevicePathNameString(long struct) {
        return MemoryUtil.memASCII(struct + (long)RCHDEVICEPATHNAME);
    }

    public static ByteBuffer nrchInputPathName(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)RCHINPUTPATHNAME, 128);
    }

    public static String nrchInputPathNameString(long struct) {
        return MemoryUtil.memASCII(struct + (long)RCHINPUTPATHNAME);
    }

    public static ByteBuffer nrchModeName(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)RCHMODENAME, 128);
    }

    public static String nrchModeNameString(long struct) {
        return MemoryUtil.memASCII(struct + (long)RCHMODENAME);
    }

    public static ByteBuffer nrchSlotName(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)RCHSLOTNAME, 128);
    }

    public static String nrchSlotNameString(long struct) {
        return MemoryUtil.memASCII(struct + (long)RCHSLOTNAME);
    }

    public static ByteBuffer nrchInputSourceType(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)RCHINPUTSOURCETYPE, 32);
    }

    public static String nrchInputSourceTypeString(long struct) {
        return MemoryUtil.memASCII(struct + (long)RCHINPUTSOURCETYPE);
    }

    static {
        Struct.Layout layout = InputBindingInfo.__struct(InputBindingInfo.__array(1, 128), InputBindingInfo.__array(1, 128), InputBindingInfo.__array(1, 128), InputBindingInfo.__array(1, 128), InputBindingInfo.__array(1, 32));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        RCHDEVICEPATHNAME = layout.offsetof(0);
        RCHINPUTPATHNAME = layout.offsetof(1);
        RCHMODENAME = layout.offsetof(2);
        RCHSLOTNAME = layout.offsetof(3);
        RCHINPUTSOURCETYPE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<InputBindingInfo, Buffer>
    implements NativeResource {
        private static final InputBindingInfo ELEMENT_FACTORY = InputBindingInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected InputBindingInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char[128]")
        public ByteBuffer rchDevicePathName() {
            return InputBindingInfo.nrchDevicePathName(this.address());
        }

        @NativeType(value="char[128]")
        public String rchDevicePathNameString() {
            return InputBindingInfo.nrchDevicePathNameString(this.address());
        }

        @NativeType(value="char[128]")
        public ByteBuffer rchInputPathName() {
            return InputBindingInfo.nrchInputPathName(this.address());
        }

        @NativeType(value="char[128]")
        public String rchInputPathNameString() {
            return InputBindingInfo.nrchInputPathNameString(this.address());
        }

        @NativeType(value="char[128]")
        public ByteBuffer rchModeName() {
            return InputBindingInfo.nrchModeName(this.address());
        }

        @NativeType(value="char[128]")
        public String rchModeNameString() {
            return InputBindingInfo.nrchModeNameString(this.address());
        }

        @NativeType(value="char[128]")
        public ByteBuffer rchSlotName() {
            return InputBindingInfo.nrchSlotName(this.address());
        }

        @NativeType(value="char[128]")
        public String rchSlotNameString() {
            return InputBindingInfo.nrchSlotNameString(this.address());
        }

        @NativeType(value="char[32]")
        public ByteBuffer rchInputSourceType() {
            return InputBindingInfo.nrchInputSourceType(this.address());
        }

        @NativeType(value="char[32]")
        public String rchInputSourceTypeString() {
            return InputBindingInfo.nrchInputSourceTypeString(this.address());
        }
    }
}

