/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct PropertyRead_t")
public class PropertyRead
extends Struct<PropertyRead>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PROP;
    public static final int PVBUFFER;
    public static final int UNBUFFERSIZE;
    public static final int UNTAG;
    public static final int UNREQUIREDBUFFERSIZE;
    public static final int EERROR;

    protected PropertyRead(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected PropertyRead create(long address, @Nullable ByteBuffer container) {
        return new PropertyRead(address, container);
    }

    public PropertyRead(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), PropertyRead.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ETrackedDeviceProperty")
    public int prop() {
        return PropertyRead.nprop(this.address());
    }

    @NativeType(value="void *")
    public ByteBuffer pvBuffer() {
        return PropertyRead.npvBuffer(this.address());
    }

    @NativeType(value="uint32_t")
    public int unBufferSize() {
        return PropertyRead.nunBufferSize(this.address());
    }

    @NativeType(value="PropertyTypeTag_t")
    public int unTag() {
        return PropertyRead.nunTag(this.address());
    }

    @NativeType(value="uint32_t")
    public int unRequiredBufferSize() {
        return PropertyRead.nunRequiredBufferSize(this.address());
    }

    @NativeType(value="ETrackedPropertyError")
    public int eError() {
        return PropertyRead.neError(this.address());
    }

    public PropertyRead prop(@NativeType(value="ETrackedDeviceProperty") int value) {
        PropertyRead.nprop(this.address(), value);
        return this;
    }

    public PropertyRead pvBuffer(@NativeType(value="void *") ByteBuffer value) {
        PropertyRead.npvBuffer(this.address(), value);
        return this;
    }

    public PropertyRead unTag(@NativeType(value="PropertyTypeTag_t") int value) {
        PropertyRead.nunTag(this.address(), value);
        return this;
    }

    public PropertyRead unRequiredBufferSize(@NativeType(value="uint32_t") int value) {
        PropertyRead.nunRequiredBufferSize(this.address(), value);
        return this;
    }

    public PropertyRead eError(@NativeType(value="ETrackedPropertyError") int value) {
        PropertyRead.neError(this.address(), value);
        return this;
    }

    public PropertyRead set(int prop, ByteBuffer pvBuffer, int unTag, int unRequiredBufferSize, int eError) {
        this.prop(prop);
        this.pvBuffer(pvBuffer);
        this.unTag(unTag);
        this.unRequiredBufferSize(unRequiredBufferSize);
        this.eError(eError);
        return this;
    }

    public PropertyRead set(PropertyRead src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static PropertyRead malloc() {
        return new PropertyRead(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static PropertyRead calloc() {
        return new PropertyRead(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static PropertyRead create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new PropertyRead(MemoryUtil.memAddress(container), container);
    }

    public static PropertyRead create(long address) {
        return new PropertyRead(address, null);
    }

    public static @Nullable PropertyRead createSafe(long address) {
        return address == 0L ? null : new PropertyRead(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(PropertyRead.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = PropertyRead.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static PropertyRead malloc(MemoryStack stack) {
        return new PropertyRead(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static PropertyRead calloc(MemoryStack stack) {
        return new PropertyRead(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nprop(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PROP);
    }

    public static ByteBuffer npvBuffer(long struct) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)PVBUFFER), PropertyRead.nunBufferSize(struct));
    }

    public static int nunBufferSize(long struct) {
        return MemoryUtil.memGetInt(struct + (long)UNBUFFERSIZE);
    }

    public static int nunTag(long struct) {
        return MemoryUtil.memGetInt(struct + (long)UNTAG);
    }

    public static int nunRequiredBufferSize(long struct) {
        return MemoryUtil.memGetInt(struct + (long)UNREQUIREDBUFFERSIZE);
    }

    public static int neError(long struct) {
        return MemoryUtil.memGetInt(struct + (long)EERROR);
    }

    public static void nprop(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)PROP, value);
    }

    public static void npvBuffer(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PVBUFFER, MemoryUtil.memAddress(value));
        PropertyRead.nunBufferSize(struct, value.remaining());
    }

    public static void nunBufferSize(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)UNBUFFERSIZE, value);
    }

    public static void nunTag(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)UNTAG, value);
    }

    public static void nunRequiredBufferSize(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)UNREQUIREDBUFFERSIZE, value);
    }

    public static void neError(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)EERROR, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PVBUFFER));
    }

    static {
        Struct.Layout layout = PropertyRead.__struct(PropertyRead.__member(4), PropertyRead.__member(POINTER_SIZE), PropertyRead.__member(4), PropertyRead.__member(4), PropertyRead.__member(4), PropertyRead.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PROP = layout.offsetof(0);
        PVBUFFER = layout.offsetof(1);
        UNBUFFERSIZE = layout.offsetof(2);
        UNTAG = layout.offsetof(3);
        UNREQUIREDBUFFERSIZE = layout.offsetof(4);
        EERROR = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<PropertyRead, Buffer>
    implements NativeResource {
        private static final PropertyRead ELEMENT_FACTORY = PropertyRead.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected PropertyRead getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="ETrackedDeviceProperty")
        public int prop() {
            return PropertyRead.nprop(this.address());
        }

        @NativeType(value="void *")
        public ByteBuffer pvBuffer() {
            return PropertyRead.npvBuffer(this.address());
        }

        @NativeType(value="uint32_t")
        public int unBufferSize() {
            return PropertyRead.nunBufferSize(this.address());
        }

        @NativeType(value="PropertyTypeTag_t")
        public int unTag() {
            return PropertyRead.nunTag(this.address());
        }

        @NativeType(value="uint32_t")
        public int unRequiredBufferSize() {
            return PropertyRead.nunRequiredBufferSize(this.address());
        }

        @NativeType(value="ETrackedPropertyError")
        public int eError() {
            return PropertyRead.neError(this.address());
        }

        public Buffer prop(@NativeType(value="ETrackedDeviceProperty") int value) {
            PropertyRead.nprop(this.address(), value);
            return this;
        }

        public Buffer pvBuffer(@NativeType(value="void *") ByteBuffer value) {
            PropertyRead.npvBuffer(this.address(), value);
            return this;
        }

        public Buffer unTag(@NativeType(value="PropertyTypeTag_t") int value) {
            PropertyRead.nunTag(this.address(), value);
            return this;
        }

        public Buffer unRequiredBufferSize(@NativeType(value="uint32_t") int value) {
            PropertyRead.nunRequiredBufferSize(this.address(), value);
            return this;
        }

        public Buffer eError(@NativeType(value="ETrackedPropertyError") int value) {
            PropertyRead.neError(this.address(), value);
            return this;
        }
    }
}

