/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.openvr.AppOverrideKeys;
import org.lwjgl.openvr.OpenVR;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;

public class VRApplications {
    protected VRApplications() {
        throw new UnsupportedOperationException();
    }

    public static int nVRApplications_AddApplicationManifest(long pchApplicationManifestFullPath, boolean bTemporary) {
        long __functionAddress = OpenVR.VRApplications.AddApplicationManifest;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(pchApplicationManifestFullPath, bTemporary, __functionAddress);
    }

    @NativeType(value="EVRApplicationError")
    public static int VRApplications_AddApplicationManifest(@NativeType(value="char const *") ByteBuffer pchApplicationManifestFullPath, @NativeType(value="bool") boolean bTemporary) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchApplicationManifestFullPath);
        }
        return VRApplications.nVRApplications_AddApplicationManifest(MemoryUtil.memAddress(pchApplicationManifestFullPath), bTemporary);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="EVRApplicationError")
    public static int VRApplications_AddApplicationManifest(@NativeType(value="char const *") CharSequence pchApplicationManifestFullPath, @NativeType(value="bool") boolean bTemporary) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchApplicationManifestFullPath, true);
            long pchApplicationManifestFullPathEncoded = stack.getPointerAddress();
            int n = VRApplications.nVRApplications_AddApplicationManifest(pchApplicationManifestFullPathEncoded, bTemporary);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVRApplications_RemoveApplicationManifest(long pchApplicationManifestFullPath) {
        long __functionAddress = OpenVR.VRApplications.RemoveApplicationManifest;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(pchApplicationManifestFullPath, __functionAddress);
    }

    @NativeType(value="EVRApplicationError")
    public static int VRApplications_RemoveApplicationManifest(@NativeType(value="char const *") ByteBuffer pchApplicationManifestFullPath) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchApplicationManifestFullPath);
        }
        return VRApplications.nVRApplications_RemoveApplicationManifest(MemoryUtil.memAddress(pchApplicationManifestFullPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="EVRApplicationError")
    public static int VRApplications_RemoveApplicationManifest(@NativeType(value="char const *") CharSequence pchApplicationManifestFullPath) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchApplicationManifestFullPath, true);
            long pchApplicationManifestFullPathEncoded = stack.getPointerAddress();
            int n = VRApplications.nVRApplications_RemoveApplicationManifest(pchApplicationManifestFullPathEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean nVRApplications_IsApplicationInstalled(long pchAppKey) {
        long __functionAddress = OpenVR.VRApplications.IsApplicationInstalled;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPZ(pchAppKey, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean VRApplications_IsApplicationInstalled(@NativeType(value="char const *") ByteBuffer pchAppKey) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchAppKey);
        }
        return VRApplications.nVRApplications_IsApplicationInstalled(MemoryUtil.memAddress(pchAppKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="bool")
    public static boolean VRApplications_IsApplicationInstalled(@NativeType(value="char const *") CharSequence pchAppKey) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchAppKey, true);
            long pchAppKeyEncoded = stack.getPointerAddress();
            boolean bl = VRApplications.nVRApplications_IsApplicationInstalled(pchAppKeyEncoded);
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="uint32_t")
    public static int VRApplications_GetApplicationCount() {
        long __functionAddress = OpenVR.VRApplications.GetApplicationCount;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callI(__functionAddress);
    }

    public static int nVRApplications_GetApplicationKeyByIndex(int unApplicationIndex, long pchAppKeyBuffer, int unAppKeyBufferLen) {
        long __functionAddress = OpenVR.VRApplications.GetApplicationKeyByIndex;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(unApplicationIndex, pchAppKeyBuffer, unAppKeyBufferLen, __functionAddress);
    }

    @NativeType(value="EVRApplicationError")
    public static int VRApplications_GetApplicationKeyByIndex(@NativeType(value="uint32_t") int unApplicationIndex, @NativeType(value="char *") @Nullable ByteBuffer pchAppKeyBuffer) {
        return VRApplications.nVRApplications_GetApplicationKeyByIndex(unApplicationIndex, MemoryUtil.memAddressSafe(pchAppKeyBuffer), Checks.remainingSafe(pchAppKeyBuffer));
    }

    public static int nVRApplications_GetApplicationKeyByProcessId(int unProcessId, long pchAppKeyBuffer, int unAppKeyBufferLen) {
        long __functionAddress = OpenVR.VRApplications.GetApplicationKeyByProcessId;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(unProcessId, pchAppKeyBuffer, unAppKeyBufferLen, __functionAddress);
    }

    @NativeType(value="EVRApplicationError")
    public static int VRApplications_GetApplicationKeyByProcessId(@NativeType(value="uint32_t") int unProcessId, @NativeType(value="char *") @Nullable ByteBuffer pchAppKeyBuffer) {
        return VRApplications.nVRApplications_GetApplicationKeyByProcessId(unProcessId, MemoryUtil.memAddressSafe(pchAppKeyBuffer), Checks.remainingSafe(pchAppKeyBuffer));
    }

    public static int nVRApplications_LaunchApplication(long pchAppKey) {
        long __functionAddress = OpenVR.VRApplications.LaunchApplication;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(pchAppKey, __functionAddress);
    }

    @NativeType(value="EVRApplicationError")
    public static int VRApplications_LaunchApplication(@NativeType(value="char const *") ByteBuffer pchAppKey) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchAppKey);
        }
        return VRApplications.nVRApplications_LaunchApplication(MemoryUtil.memAddress(pchAppKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="EVRApplicationError")
    public static int VRApplications_LaunchApplication(@NativeType(value="char const *") CharSequence pchAppKey) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchAppKey, true);
            long pchAppKeyEncoded = stack.getPointerAddress();
            int n = VRApplications.nVRApplications_LaunchApplication(pchAppKeyEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVRApplications_LaunchTemplateApplication(long pchTemplateAppKey, long pchNewAppKey, long pKeys, int unKeys) {
        long __functionAddress = OpenVR.VRApplications.LaunchTemplateApplication;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Struct.validate(pKeys, unKeys, AppOverrideKeys.SIZEOF, AppOverrideKeys::validate);
        }
        return JNI.callPPPI(pchTemplateAppKey, pchNewAppKey, pKeys, unKeys, __functionAddress);
    }

    @NativeType(value="EVRApplicationError")
    public static int VRApplications_LaunchTemplateApplication(@NativeType(value="char const *") ByteBuffer pchTemplateAppKey, @NativeType(value="char const *") ByteBuffer pchNewAppKey, @NativeType(value="AppOverrideKeys_t const *") AppOverrideKeys.Buffer pKeys) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchTemplateAppKey);
            Checks.checkNT1(pchNewAppKey);
        }
        return VRApplications.nVRApplications_LaunchTemplateApplication(MemoryUtil.memAddress(pchTemplateAppKey), MemoryUtil.memAddress(pchNewAppKey), pKeys.address(), pKeys.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="EVRApplicationError")
    public static int VRApplications_LaunchTemplateApplication(@NativeType(value="char const *") CharSequence pchTemplateAppKey, @NativeType(value="char const *") CharSequence pchNewAppKey, @NativeType(value="AppOverrideKeys_t const *") AppOverrideKeys.Buffer pKeys) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchTemplateAppKey, true);
            long pchTemplateAppKeyEncoded = stack.getPointerAddress();
            stack.nASCII(pchNewAppKey, true);
            long pchNewAppKeyEncoded = stack.getPointerAddress();
            int n = VRApplications.nVRApplications_LaunchTemplateApplication(pchTemplateAppKeyEncoded, pchNewAppKeyEncoded, pKeys.address(), pKeys.remaining());
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVRApplications_LaunchApplicationFromMimeType(long pchMimeType, long pchArgs) {
        long __functionAddress = OpenVR.VRApplications.LaunchApplicationFromMimeType;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPI(pchMimeType, pchArgs, __functionAddress);
    }

    @NativeType(value="EVRApplicationError")
    public static int VRApplications_LaunchApplicationFromMimeType(@NativeType(value="char const *") ByteBuffer pchMimeType, @NativeType(value="char const *") ByteBuffer pchArgs) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchMimeType);
            Checks.checkNT1(pchArgs);
        }
        return VRApplications.nVRApplications_LaunchApplicationFromMimeType(MemoryUtil.memAddress(pchMimeType), MemoryUtil.memAddress(pchArgs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="EVRApplicationError")
    public static int VRApplications_LaunchApplicationFromMimeType(@NativeType(value="char const *") CharSequence pchMimeType, @NativeType(value="char const *") CharSequence pchArgs) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchMimeType, true);
            long pchMimeTypeEncoded = stack.getPointerAddress();
            stack.nASCII(pchArgs, true);
            long pchArgsEncoded = stack.getPointerAddress();
            int n = VRApplications.nVRApplications_LaunchApplicationFromMimeType(pchMimeTypeEncoded, pchArgsEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVRApplications_LaunchDashboardOverlay(long pchAppKey) {
        long __functionAddress = OpenVR.VRApplications.LaunchDashboardOverlay;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(pchAppKey, __functionAddress);
    }

    @NativeType(value="EVRApplicationError")
    public static int VRApplications_LaunchDashboardOverlay(@NativeType(value="char const *") ByteBuffer pchAppKey) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchAppKey);
        }
        return VRApplications.nVRApplications_LaunchDashboardOverlay(MemoryUtil.memAddress(pchAppKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="EVRApplicationError")
    public static int VRApplications_LaunchDashboardOverlay(@NativeType(value="char const *") CharSequence pchAppKey) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchAppKey, true);
            long pchAppKeyEncoded = stack.getPointerAddress();
            int n = VRApplications.nVRApplications_LaunchDashboardOverlay(pchAppKeyEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean nVRApplications_CancelApplicationLaunch(long pchAppKey) {
        long __functionAddress = OpenVR.VRApplications.CancelApplicationLaunch;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPZ(pchAppKey, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean VRApplications_CancelApplicationLaunch(@NativeType(value="char const *") ByteBuffer pchAppKey) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchAppKey);
        }
        return VRApplications.nVRApplications_CancelApplicationLaunch(MemoryUtil.memAddress(pchAppKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="bool")
    public static boolean VRApplications_CancelApplicationLaunch(@NativeType(value="char const *") CharSequence pchAppKey) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchAppKey, true);
            long pchAppKeyEncoded = stack.getPointerAddress();
            boolean bl = VRApplications.nVRApplications_CancelApplicationLaunch(pchAppKeyEncoded);
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVRApplications_IdentifyApplication(int unProcessId, long pchAppKey) {
        long __functionAddress = OpenVR.VRApplications.IdentifyApplication;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(unProcessId, pchAppKey, __functionAddress);
    }

    @NativeType(value="EVRApplicationError")
    public static int VRApplications_IdentifyApplication(@NativeType(value="uint32_t") int unProcessId, @NativeType(value="char const *") ByteBuffer pchAppKey) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchAppKey);
        }
        return VRApplications.nVRApplications_IdentifyApplication(unProcessId, MemoryUtil.memAddress(pchAppKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="EVRApplicationError")
    public static int VRApplications_IdentifyApplication(@NativeType(value="uint32_t") int unProcessId, @NativeType(value="char const *") CharSequence pchAppKey) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchAppKey, true);
            long pchAppKeyEncoded = stack.getPointerAddress();
            int n = VRApplications.nVRApplications_IdentifyApplication(unProcessId, pchAppKeyEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVRApplications_GetApplicationProcessId(long pchAppKey) {
        long __functionAddress = OpenVR.VRApplications.GetApplicationProcessId;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(pchAppKey, __functionAddress);
    }

    @NativeType(value="uint32_t")
    public static int VRApplications_GetApplicationProcessId(@NativeType(value="char const *") ByteBuffer pchAppKey) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchAppKey);
        }
        return VRApplications.nVRApplications_GetApplicationProcessId(MemoryUtil.memAddress(pchAppKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="uint32_t")
    public static int VRApplications_GetApplicationProcessId(@NativeType(value="char const *") CharSequence pchAppKey) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchAppKey, true);
            long pchAppKeyEncoded = stack.getPointerAddress();
            int n = VRApplications.nVRApplications_GetApplicationProcessId(pchAppKeyEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nVRApplications_GetApplicationsErrorNameFromEnum(int error) {
        long __functionAddress = OpenVR.VRApplications.GetApplicationsErrorNameFromEnum;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callP(error, __functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String VRApplications_GetApplicationsErrorNameFromEnum(@NativeType(value="EVRApplicationError") int error) {
        long __result = VRApplications.nVRApplications_GetApplicationsErrorNameFromEnum(error);
        return MemoryUtil.memASCIISafe(__result);
    }

    public static int nVRApplications_GetApplicationPropertyString(long pchAppKey, int eProperty, long pchPropertyValueBuffer, int unPropertyValueBufferLen, long peError) {
        long __functionAddress = OpenVR.VRApplications.GetApplicationPropertyString;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPI(pchAppKey, eProperty, pchPropertyValueBuffer, unPropertyValueBufferLen, peError, __functionAddress);
    }

    @NativeType(value="uint32_t")
    public static int VRApplications_GetApplicationPropertyString(@NativeType(value="char const *") ByteBuffer pchAppKey, @NativeType(value="EVRApplicationProperty") int eProperty, @NativeType(value="char *") @Nullable ByteBuffer pchPropertyValueBuffer, @NativeType(value="EVRApplicationError *") IntBuffer peError) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchAppKey);
            Checks.check((Buffer)peError, 1);
        }
        return VRApplications.nVRApplications_GetApplicationPropertyString(MemoryUtil.memAddress(pchAppKey), eProperty, MemoryUtil.memAddressSafe(pchPropertyValueBuffer), Checks.remainingSafe(pchPropertyValueBuffer), MemoryUtil.memAddress(peError));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="uint32_t")
    public static int VRApplications_GetApplicationPropertyString(@NativeType(value="char const *") CharSequence pchAppKey, @NativeType(value="EVRApplicationProperty") int eProperty, @NativeType(value="char *") @Nullable ByteBuffer pchPropertyValueBuffer, @NativeType(value="EVRApplicationError *") IntBuffer peError) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)peError, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchAppKey, true);
            long pchAppKeyEncoded = stack.getPointerAddress();
            int n = VRApplications.nVRApplications_GetApplicationPropertyString(pchAppKeyEncoded, eProperty, MemoryUtil.memAddressSafe(pchPropertyValueBuffer), Checks.remainingSafe(pchPropertyValueBuffer), MemoryUtil.memAddress(peError));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="uint32_t")
    public static String VRApplications_GetApplicationPropertyString(@NativeType(value="char const *") CharSequence pchAppKey, @NativeType(value="EVRApplicationProperty") int eProperty, @NativeType(value="uint32_t") int unPropertyValueBufferLen, @NativeType(value="EVRApplicationError *") IntBuffer peError) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)peError, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchAppKey, true);
            long pchAppKeyEncoded = stack.getPointerAddress();
            ByteBuffer pchPropertyValueBuffer = stack.malloc(unPropertyValueBufferLen);
            int __result = VRApplications.nVRApplications_GetApplicationPropertyString(pchAppKeyEncoded, eProperty, MemoryUtil.memAddress(pchPropertyValueBuffer), unPropertyValueBufferLen, MemoryUtil.memAddress(peError));
            String string = MemoryUtil.memASCII(pchPropertyValueBuffer, __result - 1);
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="uint32_t")
    public static String VRApplications_GetApplicationPropertyString(@NativeType(value="char const *") CharSequence pchAppKey, @NativeType(value="EVRApplicationProperty") int eProperty, @NativeType(value="EVRApplicationError *") IntBuffer peError) {
        return VRApplications.VRApplications_GetApplicationPropertyString(pchAppKey, eProperty, 32768, peError);
    }

    public static boolean nVRApplications_GetApplicationPropertyBool(long pchAppKey, int eProperty, long peError) {
        long __functionAddress = OpenVR.VRApplications.GetApplicationPropertyBool;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPZ(pchAppKey, eProperty, peError, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean VRApplications_GetApplicationPropertyBool(@NativeType(value="char const *") ByteBuffer pchAppKey, @NativeType(value="EVRApplicationProperty") int eProperty, @NativeType(value="EVRApplicationError *") IntBuffer peError) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchAppKey);
            Checks.check((Buffer)peError, 1);
        }
        return VRApplications.nVRApplications_GetApplicationPropertyBool(MemoryUtil.memAddress(pchAppKey), eProperty, MemoryUtil.memAddress(peError));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="bool")
    public static boolean VRApplications_GetApplicationPropertyBool(@NativeType(value="char const *") CharSequence pchAppKey, @NativeType(value="EVRApplicationProperty") int eProperty, @NativeType(value="EVRApplicationError *") IntBuffer peError) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)peError, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchAppKey, true);
            long pchAppKeyEncoded = stack.getPointerAddress();
            boolean bl = VRApplications.nVRApplications_GetApplicationPropertyBool(pchAppKeyEncoded, eProperty, MemoryUtil.memAddress(peError));
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nVRApplications_GetApplicationPropertyUint64(long pchAppKey, int eProperty, long peError) {
        long __functionAddress = OpenVR.VRApplications.GetApplicationPropertyUint64;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPJ(pchAppKey, eProperty, peError, __functionAddress);
    }

    @NativeType(value="uint64_t")
    public static long VRApplications_GetApplicationPropertyUint64(@NativeType(value="char const *") ByteBuffer pchAppKey, @NativeType(value="EVRApplicationProperty") int eProperty, @NativeType(value="EVRApplicationError *") IntBuffer peError) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchAppKey);
            Checks.check((Buffer)peError, 1);
        }
        return VRApplications.nVRApplications_GetApplicationPropertyUint64(MemoryUtil.memAddress(pchAppKey), eProperty, MemoryUtil.memAddress(peError));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="uint64_t")
    public static long VRApplications_GetApplicationPropertyUint64(@NativeType(value="char const *") CharSequence pchAppKey, @NativeType(value="EVRApplicationProperty") int eProperty, @NativeType(value="EVRApplicationError *") IntBuffer peError) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)peError, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchAppKey, true);
            long pchAppKeyEncoded = stack.getPointerAddress();
            long l = VRApplications.nVRApplications_GetApplicationPropertyUint64(pchAppKeyEncoded, eProperty, MemoryUtil.memAddress(peError));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVRApplications_SetApplicationAutoLaunch(long pchAppKey, boolean bAutoLaunch) {
        long __functionAddress = OpenVR.VRApplications.SetApplicationAutoLaunch;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(pchAppKey, bAutoLaunch, __functionAddress);
    }

    @NativeType(value="EVRApplicationError")
    public static int VRApplications_SetApplicationAutoLaunch(@NativeType(value="char const *") ByteBuffer pchAppKey, @NativeType(value="bool") boolean bAutoLaunch) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchAppKey);
        }
        return VRApplications.nVRApplications_SetApplicationAutoLaunch(MemoryUtil.memAddress(pchAppKey), bAutoLaunch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="EVRApplicationError")
    public static int VRApplications_SetApplicationAutoLaunch(@NativeType(value="char const *") CharSequence pchAppKey, @NativeType(value="bool") boolean bAutoLaunch) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchAppKey, true);
            long pchAppKeyEncoded = stack.getPointerAddress();
            int n = VRApplications.nVRApplications_SetApplicationAutoLaunch(pchAppKeyEncoded, bAutoLaunch);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean nVRApplications_GetApplicationAutoLaunch(long pchAppKey) {
        long __functionAddress = OpenVR.VRApplications.GetApplicationAutoLaunch;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPZ(pchAppKey, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean VRApplications_GetApplicationAutoLaunch(@NativeType(value="char const *") ByteBuffer pchAppKey) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchAppKey);
        }
        return VRApplications.nVRApplications_GetApplicationAutoLaunch(MemoryUtil.memAddress(pchAppKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="bool")
    public static boolean VRApplications_GetApplicationAutoLaunch(@NativeType(value="char const *") CharSequence pchAppKey) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchAppKey, true);
            long pchAppKeyEncoded = stack.getPointerAddress();
            boolean bl = VRApplications.nVRApplications_GetApplicationAutoLaunch(pchAppKeyEncoded);
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVRApplications_SetDefaultApplicationForMimeType(long pchAppKey, long pchMimeType) {
        long __functionAddress = OpenVR.VRApplications.SetDefaultApplicationForMimeType;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPI(pchAppKey, pchMimeType, __functionAddress);
    }

    @NativeType(value="EVRApplicationError")
    public static int VRApplications_SetDefaultApplicationForMimeType(@NativeType(value="char const *") ByteBuffer pchAppKey, @NativeType(value="char const *") ByteBuffer pchMimeType) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchAppKey);
            Checks.checkNT1(pchMimeType);
        }
        return VRApplications.nVRApplications_SetDefaultApplicationForMimeType(MemoryUtil.memAddress(pchAppKey), MemoryUtil.memAddress(pchMimeType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="EVRApplicationError")
    public static int VRApplications_SetDefaultApplicationForMimeType(@NativeType(value="char const *") CharSequence pchAppKey, @NativeType(value="char const *") CharSequence pchMimeType) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchAppKey, true);
            long pchAppKeyEncoded = stack.getPointerAddress();
            stack.nASCII(pchMimeType, true);
            long pchMimeTypeEncoded = stack.getPointerAddress();
            int n = VRApplications.nVRApplications_SetDefaultApplicationForMimeType(pchAppKeyEncoded, pchMimeTypeEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean nVRApplications_GetDefaultApplicationForMimeType(long pchMimeType, long pchAppKeyBuffer, int unAppKeyBufferLen) {
        long __functionAddress = OpenVR.VRApplications.GetDefaultApplicationForMimeType;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPZ(pchMimeType, pchAppKeyBuffer, unAppKeyBufferLen, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean VRApplications_GetDefaultApplicationForMimeType(@NativeType(value="char const *") ByteBuffer pchMimeType, @NativeType(value="char *") @Nullable ByteBuffer pchAppKeyBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchMimeType);
        }
        return VRApplications.nVRApplications_GetDefaultApplicationForMimeType(MemoryUtil.memAddress(pchMimeType), MemoryUtil.memAddressSafe(pchAppKeyBuffer), Checks.remainingSafe(pchAppKeyBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="bool")
    public static boolean VRApplications_GetDefaultApplicationForMimeType(@NativeType(value="char const *") CharSequence pchMimeType, @NativeType(value="char *") @Nullable ByteBuffer pchAppKeyBuffer) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchMimeType, true);
            long pchMimeTypeEncoded = stack.getPointerAddress();
            boolean bl = VRApplications.nVRApplications_GetDefaultApplicationForMimeType(pchMimeTypeEncoded, MemoryUtil.memAddressSafe(pchAppKeyBuffer), Checks.remainingSafe(pchAppKeyBuffer));
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean nVRApplications_GetApplicationSupportedMimeTypes(long pchAppKey, long pchMimeTypesBuffer, int unMimeTypesBuffer) {
        long __functionAddress = OpenVR.VRApplications.GetApplicationSupportedMimeTypes;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPZ(pchAppKey, pchMimeTypesBuffer, unMimeTypesBuffer, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean VRApplications_GetApplicationSupportedMimeTypes(@NativeType(value="char const *") ByteBuffer pchAppKey, @NativeType(value="char *") @Nullable ByteBuffer pchMimeTypesBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchAppKey);
        }
        return VRApplications.nVRApplications_GetApplicationSupportedMimeTypes(MemoryUtil.memAddress(pchAppKey), MemoryUtil.memAddressSafe(pchMimeTypesBuffer), Checks.remainingSafe(pchMimeTypesBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="bool")
    public static boolean VRApplications_GetApplicationSupportedMimeTypes(@NativeType(value="char const *") CharSequence pchAppKey, @NativeType(value="char *") @Nullable ByteBuffer pchMimeTypesBuffer) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchAppKey, true);
            long pchAppKeyEncoded = stack.getPointerAddress();
            boolean bl = VRApplications.nVRApplications_GetApplicationSupportedMimeTypes(pchAppKeyEncoded, MemoryUtil.memAddressSafe(pchMimeTypesBuffer), Checks.remainingSafe(pchMimeTypesBuffer));
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVRApplications_GetApplicationsThatSupportMimeType(long pchMimeType, long pchAppKeysThatSupportBuffer, int unAppKeysThatSupportBuffer) {
        long __functionAddress = OpenVR.VRApplications.GetApplicationsThatSupportMimeType;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPI(pchMimeType, pchAppKeysThatSupportBuffer, unAppKeysThatSupportBuffer, __functionAddress);
    }

    @NativeType(value="uint32_t")
    public static int VRApplications_GetApplicationsThatSupportMimeType(@NativeType(value="char const *") ByteBuffer pchMimeType, @NativeType(value="char *") @Nullable ByteBuffer pchAppKeysThatSupportBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchMimeType);
        }
        return VRApplications.nVRApplications_GetApplicationsThatSupportMimeType(MemoryUtil.memAddress(pchMimeType), MemoryUtil.memAddressSafe(pchAppKeysThatSupportBuffer), Checks.remainingSafe(pchAppKeysThatSupportBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="uint32_t")
    public static int VRApplications_GetApplicationsThatSupportMimeType(@NativeType(value="char const *") CharSequence pchMimeType, @NativeType(value="char *") @Nullable ByteBuffer pchAppKeysThatSupportBuffer) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchMimeType, true);
            long pchMimeTypeEncoded = stack.getPointerAddress();
            int n = VRApplications.nVRApplications_GetApplicationsThatSupportMimeType(pchMimeTypeEncoded, MemoryUtil.memAddressSafe(pchAppKeysThatSupportBuffer), Checks.remainingSafe(pchAppKeysThatSupportBuffer));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="uint32_t")
    public static String VRApplications_GetApplicationsThatSupportMimeType(@NativeType(value="char const *") CharSequence pchMimeType, @NativeType(value="uint32_t") int unAppKeysThatSupportBuffer) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchMimeType, true);
            long pchMimeTypeEncoded = stack.getPointerAddress();
            ByteBuffer pchAppKeysThatSupportBuffer = stack.malloc(unAppKeysThatSupportBuffer);
            int __result = VRApplications.nVRApplications_GetApplicationsThatSupportMimeType(pchMimeTypeEncoded, MemoryUtil.memAddress(pchAppKeysThatSupportBuffer), unAppKeysThatSupportBuffer);
            String string = MemoryUtil.memASCII(pchAppKeysThatSupportBuffer, __result - 1);
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVRApplications_GetApplicationLaunchArguments(int unHandle, long pchArgs, int unArgs) {
        long __functionAddress = OpenVR.VRApplications.GetApplicationLaunchArguments;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(unHandle, pchArgs, unArgs, __functionAddress);
    }

    @NativeType(value="uint32_t")
    public static int VRApplications_GetApplicationLaunchArguments(@NativeType(value="uint32_t") int unHandle, @NativeType(value="char *") @Nullable ByteBuffer pchArgs) {
        return VRApplications.nVRApplications_GetApplicationLaunchArguments(unHandle, MemoryUtil.memAddressSafe(pchArgs), Checks.remainingSafe(pchArgs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="uint32_t")
    public static String VRApplications_GetApplicationLaunchArguments(@NativeType(value="uint32_t") int unHandle, @NativeType(value="uint32_t") int unArgs) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchArgs = stack.malloc(unArgs);
            int __result = VRApplications.nVRApplications_GetApplicationLaunchArguments(unHandle, MemoryUtil.memAddress(pchArgs), unArgs);
            String string = MemoryUtil.memASCII(pchArgs, __result - 1);
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVRApplications_GetStartingApplication(long pchAppKeyBuffer, int unAppKeyBufferLen) {
        long __functionAddress = OpenVR.VRApplications.GetStartingApplication;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(pchAppKeyBuffer, unAppKeyBufferLen, __functionAddress);
    }

    @NativeType(value="EVRApplicationError")
    public static int VRApplications_GetStartingApplication(@NativeType(value="char *") ByteBuffer pchAppKeyBuffer) {
        return VRApplications.nVRApplications_GetStartingApplication(MemoryUtil.memAddress(pchAppKeyBuffer), pchAppKeyBuffer.remaining());
    }

    @NativeType(value="EVRSceneApplicationState")
    public static int VRApplications_GetSceneApplicationState() {
        long __functionAddress = OpenVR.VRApplications.GetSceneApplicationState;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callI(__functionAddress);
    }

    public static int nVRApplications_PerformApplicationPrelaunchCheck(long pchAppKey) {
        long __functionAddress = OpenVR.VRApplications.PerformApplicationPrelaunchCheck;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(pchAppKey, __functionAddress);
    }

    @NativeType(value="EVRApplicationError")
    public static int VRApplications_PerformApplicationPrelaunchCheck(@NativeType(value="char const *") ByteBuffer pchAppKey) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchAppKey);
        }
        return VRApplications.nVRApplications_PerformApplicationPrelaunchCheck(MemoryUtil.memAddress(pchAppKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="EVRApplicationError")
    public static int VRApplications_PerformApplicationPrelaunchCheck(@NativeType(value="char const *") CharSequence pchAppKey) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchAppKey, true);
            long pchAppKeyEncoded = stack.getPointerAddress();
            int n = VRApplications.nVRApplications_PerformApplicationPrelaunchCheck(pchAppKeyEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nVRApplications_GetSceneApplicationStateNameFromEnum(int state) {
        long __functionAddress = OpenVR.VRApplications.GetSceneApplicationStateNameFromEnum;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callP(state, __functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String VRApplications_GetSceneApplicationStateNameFromEnum(@NativeType(value="EVRSceneApplicationState") int state) {
        long __result = VRApplications.nVRApplications_GetSceneApplicationStateNameFromEnum(state);
        return MemoryUtil.memASCIISafe(__result);
    }

    public static int nVRApplications_LaunchInternalProcess(long pchBinaryPath, long pchArguments, long pchWorkingDirectory) {
        long __functionAddress = OpenVR.VRApplications.LaunchInternalProcess;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPI(pchBinaryPath, pchArguments, pchWorkingDirectory, __functionAddress);
    }

    @NativeType(value="EVRApplicationError")
    public static int VRApplications_LaunchInternalProcess(@NativeType(value="char const *") ByteBuffer pchBinaryPath, @NativeType(value="char const *") ByteBuffer pchArguments, @NativeType(value="char const *") ByteBuffer pchWorkingDirectory) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchBinaryPath);
            Checks.checkNT1(pchArguments);
            Checks.checkNT1(pchWorkingDirectory);
        }
        return VRApplications.nVRApplications_LaunchInternalProcess(MemoryUtil.memAddress(pchBinaryPath), MemoryUtil.memAddress(pchArguments), MemoryUtil.memAddress(pchWorkingDirectory));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="EVRApplicationError")
    public static int VRApplications_LaunchInternalProcess(@NativeType(value="char const *") CharSequence pchBinaryPath, @NativeType(value="char const *") CharSequence pchArguments, @NativeType(value="char const *") CharSequence pchWorkingDirectory) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchBinaryPath, true);
            long pchBinaryPathEncoded = stack.getPointerAddress();
            stack.nASCII(pchArguments, true);
            long pchArgumentsEncoded = stack.getPointerAddress();
            stack.nASCII(pchWorkingDirectory, true);
            long pchWorkingDirectoryEncoded = stack.getPointerAddress();
            int n = VRApplications.nVRApplications_LaunchInternalProcess(pchBinaryPathEncoded, pchArgumentsEncoded, pchWorkingDirectoryEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="uint32_t")
    public static int VRApplications_GetCurrentSceneProcessId() {
        long __functionAddress = OpenVR.VRApplications.GetCurrentSceneProcessId;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callI(__functionAddress);
    }
}

