/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openvr.VREventData;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Platform;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct VREvent_t")
public class VREvent
extends Struct<VREvent>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int EVENTTYPE;
    public static final int TRACKEDDEVICEINDEX;
    public static final int EVENTAGESECONDS;
    public static final int DATA;

    protected VREvent(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VREvent create(long address, @Nullable ByteBuffer container) {
        return new VREvent(address, container);
    }

    public VREvent(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VREvent.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int eventType() {
        return VREvent.neventType(this.address());
    }

    @NativeType(value="TrackedDeviceIndex_t")
    public int trackedDeviceIndex() {
        return VREvent.ntrackedDeviceIndex(this.address());
    }

    public float eventAgeSeconds() {
        return VREvent.neventAgeSeconds(this.address());
    }

    @NativeType(value="VREvent_Data_t")
    public VREventData data() {
        return VREvent.ndata(this.address());
    }

    public static VREvent malloc() {
        return new VREvent(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VREvent calloc() {
        return new VREvent(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VREvent create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VREvent(MemoryUtil.memAddress(container), container);
    }

    public static VREvent create(long address) {
        return new VREvent(address, null);
    }

    public static @Nullable VREvent createSafe(long address) {
        return address == 0L ? null : new VREvent(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VREvent.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VREvent.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VREvent mallocStack() {
        return VREvent.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VREvent callocStack() {
        return VREvent.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VREvent mallocStack(MemoryStack stack) {
        return VREvent.malloc(stack);
    }

    @Deprecated
    public static VREvent callocStack(MemoryStack stack) {
        return VREvent.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VREvent.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VREvent.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VREvent.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VREvent.calloc(capacity, stack);
    }

    public static VREvent malloc(MemoryStack stack) {
        return new VREvent(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VREvent calloc(MemoryStack stack) {
        return new VREvent(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int neventType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)EVENTTYPE);
    }

    public static int ntrackedDeviceIndex(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TRACKEDDEVICEINDEX);
    }

    public static float neventAgeSeconds(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)EVENTAGESECONDS);
    }

    public static VREventData ndata(long struct) {
        return VREventData.create(struct + (long)DATA);
    }

    static {
        Struct.Layout layout = VREvent.__struct(Platform.get() == Platform.LINUX || Platform.get() == Platform.MACOSX ? 4 : DEFAULT_PACK_ALIGNMENT, 0, VREvent.__member(4), VREvent.__member(4), VREvent.__member(4), VREvent.__member(VREventData.SIZEOF, VREventData.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        EVENTTYPE = layout.offsetof(0);
        TRACKEDDEVICEINDEX = layout.offsetof(1);
        EVENTAGESECONDS = layout.offsetof(2);
        DATA = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VREvent, Buffer>
    implements NativeResource {
        private static final VREvent ELEMENT_FACTORY = VREvent.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VREvent getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int eventType() {
            return VREvent.neventType(this.address());
        }

        @NativeType(value="TrackedDeviceIndex_t")
        public int trackedDeviceIndex() {
            return VREvent.ntrackedDeviceIndex(this.address());
        }

        public float eventAgeSeconds() {
            return VREvent.neventAgeSeconds(this.address());
        }

        @NativeType(value="VREvent_Data_t")
        public VREventData data() {
            return VREvent.ndata(this.address());
        }
    }
}

