/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.openvr.VREventApplicationLaunch;
import org.lwjgl.openvr.VREventAudioMuteControl;
import org.lwjgl.openvr.VREventAudioVolumeControl;
import org.lwjgl.openvr.VREventChaperone;
import org.lwjgl.openvr.VREventController;
import org.lwjgl.openvr.VREventEditingCameraSurface;
import org.lwjgl.openvr.VREventHDCPError;
import org.lwjgl.openvr.VREventHapticVibration;
import org.lwjgl.openvr.VREventInputActionManifestLoad;
import org.lwjgl.openvr.VREventInputBindingLoad;
import org.lwjgl.openvr.VREventIpd;
import org.lwjgl.openvr.VREventKeyboard;
import org.lwjgl.openvr.VREventMessageOverlay;
import org.lwjgl.openvr.VREventMouse;
import org.lwjgl.openvr.VREventNotification;
import org.lwjgl.openvr.VREventOverlay;
import org.lwjgl.openvr.VREventPerformanceTest;
import org.lwjgl.openvr.VREventProcess;
import org.lwjgl.openvr.VREventProgressUpdate;
import org.lwjgl.openvr.VREventProperty;
import org.lwjgl.openvr.VREventReserved;
import org.lwjgl.openvr.VREventScreenshot;
import org.lwjgl.openvr.VREventScreenshotProgress;
import org.lwjgl.openvr.VREventScroll;
import org.lwjgl.openvr.VREventSeatedZeroPoseReset;
import org.lwjgl.openvr.VREventShowDevTools;
import org.lwjgl.openvr.VREventShowUI;
import org.lwjgl.openvr.VREventSpatialAnchor;
import org.lwjgl.openvr.VREventStatus;
import org.lwjgl.openvr.VREventTouchPadMove;
import org.lwjgl.openvr.VREventWebConsole;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="union VREvent_Data_t")
public class VREventData
extends Struct<VREventData> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int RESERVED;
    public static final int CONTROLLER;
    public static final int MOUSE;
    public static final int SCROLL;
    public static final int PROCESS;
    public static final int NOTIFICATION;
    public static final int OVERLAY;
    public static final int STATUS;
    public static final int KEYBOARD;
    public static final int IPD;
    public static final int CHAPERONE;
    public static final int PERFORMANCETEST;
    public static final int TOUCHPADMOVE;
    public static final int SEATEDZEROPOSERESET;
    public static final int SCREENSHOT;
    public static final int SCREENSHOTPROGRESS;
    public static final int APPLICATIONLAUNCH;
    public static final int CAMERASURFACE;
    public static final int MESSAGEOVERLAY;
    public static final int PROPERTY;
    public static final int HAPTICVIBRATION;
    public static final int WEBCONSOLE;
    public static final int INPUTBINDING;
    public static final int ACTIONMANIFEST;
    public static final int SPATIALANCHOR;
    public static final int PROGRESSUPDATE;
    public static final int SHOWUI;
    public static final int SHOWDEVTOOLS;
    public static final int HDCPERROR;
    public static final int AUDIOVOLUMECONTROL;
    public static final int AUDIOMUTECONTROL;

    protected VREventData(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VREventData create(long address, @Nullable ByteBuffer container) {
        return new VREventData(address, container);
    }

    public VREventData(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VREventData.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VREvent_Reserved_t")
    public VREventReserved reserved() {
        return VREventData.nreserved(this.address());
    }

    @NativeType(value="VREvent_Controller_t")
    public VREventController controller() {
        return VREventData.ncontroller(this.address());
    }

    @NativeType(value="VREvent_Mouse_t")
    public VREventMouse mouse() {
        return VREventData.nmouse(this.address());
    }

    @NativeType(value="VREvent_Scroll_t")
    public VREventScroll scroll() {
        return VREventData.nscroll(this.address());
    }

    @NativeType(value="VREvent_Process_t")
    public VREventProcess process() {
        return VREventData.nprocess(this.address());
    }

    @NativeType(value="VREvent_Notification_t")
    public VREventNotification notification() {
        return VREventData.nnotification(this.address());
    }

    @NativeType(value="VREvent_Overlay_t")
    public VREventOverlay overlay() {
        return VREventData.noverlay(this.address());
    }

    @NativeType(value="VREvent_Status_t")
    public VREventStatus status() {
        return VREventData.nstatus(this.address());
    }

    @NativeType(value="VREvent_Keyboard_t")
    public VREventKeyboard keyboard() {
        return VREventData.nkeyboard(this.address());
    }

    @NativeType(value="VREvent_Ipd_t")
    public VREventIpd ipd() {
        return VREventData.nipd(this.address());
    }

    @NativeType(value="VREvent_Chaperone_t")
    public VREventChaperone chaperone() {
        return VREventData.nchaperone(this.address());
    }

    @NativeType(value="VREvent_PerformanceTest_t")
    public VREventPerformanceTest performanceTest() {
        return VREventData.nperformanceTest(this.address());
    }

    @NativeType(value="VREvent_TouchPadMove_t")
    public VREventTouchPadMove touchPadMove() {
        return VREventData.ntouchPadMove(this.address());
    }

    @NativeType(value="VREvent_SeatedZeroPoseReset_t")
    public VREventSeatedZeroPoseReset seatedZeroPoseReset() {
        return VREventData.nseatedZeroPoseReset(this.address());
    }

    @NativeType(value="VREvent_Screenshot_t")
    public VREventScreenshot screenshot() {
        return VREventData.nscreenshot(this.address());
    }

    @NativeType(value="VREvent_ScreenshotProgress_t")
    public VREventScreenshotProgress screenshotProgress() {
        return VREventData.nscreenshotProgress(this.address());
    }

    @NativeType(value="VREvent_ApplicationLaunch_t")
    public VREventApplicationLaunch applicationLaunch() {
        return VREventData.napplicationLaunch(this.address());
    }

    @NativeType(value="VREvent_EditingCameraSurface_t")
    public VREventEditingCameraSurface cameraSurface() {
        return VREventData.ncameraSurface(this.address());
    }

    @NativeType(value="VREvent_MessageOverlay_t")
    public VREventMessageOverlay messageOverlay() {
        return VREventData.nmessageOverlay(this.address());
    }

    @NativeType(value="VREvent_Property_t")
    public VREventProperty property() {
        return VREventData.nproperty(this.address());
    }

    @NativeType(value="VREvent_HapticVibration_t")
    public VREventHapticVibration hapticVibration() {
        return VREventData.nhapticVibration(this.address());
    }

    @NativeType(value="VREvent_WebConsole_t")
    public VREventWebConsole webConsole() {
        return VREventData.nwebConsole(this.address());
    }

    @NativeType(value="VREvent_InputBindingLoad_t")
    public VREventInputBindingLoad inputBinding() {
        return VREventData.ninputBinding(this.address());
    }

    @NativeType(value="VREvent_InputActionManifestLoad_t")
    public VREventInputActionManifestLoad actionManifest() {
        return VREventData.nactionManifest(this.address());
    }

    @NativeType(value="VREvent_SpatialAnchor_t")
    public VREventSpatialAnchor spatialAnchor() {
        return VREventData.nspatialAnchor(this.address());
    }

    @NativeType(value="VREvent_ProgressUpdate_t")
    public VREventProgressUpdate progressUpdate() {
        return VREventData.nprogressUpdate(this.address());
    }

    @NativeType(value="VREvent_ShowUI_t")
    public VREventShowUI showUi() {
        return VREventData.nshowUi(this.address());
    }

    @NativeType(value="VREvent_ShowDevTools_t")
    public VREventShowDevTools showDevTools() {
        return VREventData.nshowDevTools(this.address());
    }

    @NativeType(value="VREvent_HDCPError_t")
    public VREventHDCPError hdcpError() {
        return VREventData.nhdcpError(this.address());
    }

    @NativeType(value="VREvent_AudioVolumeControl_t")
    public VREventAudioVolumeControl audioVolumeControl() {
        return VREventData.naudioVolumeControl(this.address());
    }

    @NativeType(value="VREvent_AudioMuteControl_t")
    public VREventAudioMuteControl audioMuteControl() {
        return VREventData.naudioMuteControl(this.address());
    }

    public static VREventData create(long address) {
        return new VREventData(address, null);
    }

    public static @Nullable VREventData createSafe(long address) {
        return address == 0L ? null : new VREventData(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VREventReserved nreserved(long struct) {
        return VREventReserved.create(struct + (long)RESERVED);
    }

    public static VREventController ncontroller(long struct) {
        return VREventController.create(struct + (long)CONTROLLER);
    }

    public static VREventMouse nmouse(long struct) {
        return VREventMouse.create(struct + (long)MOUSE);
    }

    public static VREventScroll nscroll(long struct) {
        return VREventScroll.create(struct + (long)SCROLL);
    }

    public static VREventProcess nprocess(long struct) {
        return VREventProcess.create(struct + (long)PROCESS);
    }

    public static VREventNotification nnotification(long struct) {
        return VREventNotification.create(struct + (long)NOTIFICATION);
    }

    public static VREventOverlay noverlay(long struct) {
        return VREventOverlay.create(struct + (long)OVERLAY);
    }

    public static VREventStatus nstatus(long struct) {
        return VREventStatus.create(struct + (long)STATUS);
    }

    public static VREventKeyboard nkeyboard(long struct) {
        return VREventKeyboard.create(struct + (long)KEYBOARD);
    }

    public static VREventIpd nipd(long struct) {
        return VREventIpd.create(struct + (long)IPD);
    }

    public static VREventChaperone nchaperone(long struct) {
        return VREventChaperone.create(struct + (long)CHAPERONE);
    }

    public static VREventPerformanceTest nperformanceTest(long struct) {
        return VREventPerformanceTest.create(struct + (long)PERFORMANCETEST);
    }

    public static VREventTouchPadMove ntouchPadMove(long struct) {
        return VREventTouchPadMove.create(struct + (long)TOUCHPADMOVE);
    }

    public static VREventSeatedZeroPoseReset nseatedZeroPoseReset(long struct) {
        return VREventSeatedZeroPoseReset.create(struct + (long)SEATEDZEROPOSERESET);
    }

    public static VREventScreenshot nscreenshot(long struct) {
        return VREventScreenshot.create(struct + (long)SCREENSHOT);
    }

    public static VREventScreenshotProgress nscreenshotProgress(long struct) {
        return VREventScreenshotProgress.create(struct + (long)SCREENSHOTPROGRESS);
    }

    public static VREventApplicationLaunch napplicationLaunch(long struct) {
        return VREventApplicationLaunch.create(struct + (long)APPLICATIONLAUNCH);
    }

    public static VREventEditingCameraSurface ncameraSurface(long struct) {
        return VREventEditingCameraSurface.create(struct + (long)CAMERASURFACE);
    }

    public static VREventMessageOverlay nmessageOverlay(long struct) {
        return VREventMessageOverlay.create(struct + (long)MESSAGEOVERLAY);
    }

    public static VREventProperty nproperty(long struct) {
        return VREventProperty.create(struct + (long)PROPERTY);
    }

    public static VREventHapticVibration nhapticVibration(long struct) {
        return VREventHapticVibration.create(struct + (long)HAPTICVIBRATION);
    }

    public static VREventWebConsole nwebConsole(long struct) {
        return VREventWebConsole.create(struct + (long)WEBCONSOLE);
    }

    public static VREventInputBindingLoad ninputBinding(long struct) {
        return VREventInputBindingLoad.create(struct + (long)INPUTBINDING);
    }

    public static VREventInputActionManifestLoad nactionManifest(long struct) {
        return VREventInputActionManifestLoad.create(struct + (long)ACTIONMANIFEST);
    }

    public static VREventSpatialAnchor nspatialAnchor(long struct) {
        return VREventSpatialAnchor.create(struct + (long)SPATIALANCHOR);
    }

    public static VREventProgressUpdate nprogressUpdate(long struct) {
        return VREventProgressUpdate.create(struct + (long)PROGRESSUPDATE);
    }

    public static VREventShowUI nshowUi(long struct) {
        return VREventShowUI.create(struct + (long)SHOWUI);
    }

    public static VREventShowDevTools nshowDevTools(long struct) {
        return VREventShowDevTools.create(struct + (long)SHOWDEVTOOLS);
    }

    public static VREventHDCPError nhdcpError(long struct) {
        return VREventHDCPError.create(struct + (long)HDCPERROR);
    }

    public static VREventAudioVolumeControl naudioVolumeControl(long struct) {
        return VREventAudioVolumeControl.create(struct + (long)AUDIOVOLUMECONTROL);
    }

    public static VREventAudioMuteControl naudioMuteControl(long struct) {
        return VREventAudioMuteControl.create(struct + (long)AUDIOMUTECONTROL);
    }

    static {
        Struct.Layout layout = VREventData.__union(VREventData.__member(VREventReserved.SIZEOF, VREventReserved.ALIGNOF), VREventData.__member(VREventController.SIZEOF, VREventController.ALIGNOF), VREventData.__member(VREventMouse.SIZEOF, VREventMouse.ALIGNOF), VREventData.__member(VREventScroll.SIZEOF, VREventScroll.ALIGNOF), VREventData.__member(VREventProcess.SIZEOF, VREventProcess.ALIGNOF), VREventData.__member(VREventNotification.SIZEOF, VREventNotification.ALIGNOF), VREventData.__member(VREventOverlay.SIZEOF, VREventOverlay.ALIGNOF), VREventData.__member(VREventStatus.SIZEOF, VREventStatus.ALIGNOF), VREventData.__member(VREventKeyboard.SIZEOF, VREventKeyboard.ALIGNOF), VREventData.__member(VREventIpd.SIZEOF, VREventIpd.ALIGNOF), VREventData.__member(VREventChaperone.SIZEOF, VREventChaperone.ALIGNOF), VREventData.__member(VREventPerformanceTest.SIZEOF, VREventPerformanceTest.ALIGNOF), VREventData.__member(VREventTouchPadMove.SIZEOF, VREventTouchPadMove.ALIGNOF), VREventData.__member(VREventSeatedZeroPoseReset.SIZEOF, VREventSeatedZeroPoseReset.ALIGNOF), VREventData.__member(VREventScreenshot.SIZEOF, VREventScreenshot.ALIGNOF), VREventData.__member(VREventScreenshotProgress.SIZEOF, VREventScreenshotProgress.ALIGNOF), VREventData.__member(VREventApplicationLaunch.SIZEOF, VREventApplicationLaunch.ALIGNOF), VREventData.__member(VREventEditingCameraSurface.SIZEOF, VREventEditingCameraSurface.ALIGNOF), VREventData.__member(VREventMessageOverlay.SIZEOF, VREventMessageOverlay.ALIGNOF), VREventData.__member(VREventProperty.SIZEOF, VREventProperty.ALIGNOF), VREventData.__member(VREventHapticVibration.SIZEOF, VREventHapticVibration.ALIGNOF), VREventData.__member(VREventWebConsole.SIZEOF, VREventWebConsole.ALIGNOF), VREventData.__member(VREventInputBindingLoad.SIZEOF, VREventInputBindingLoad.ALIGNOF), VREventData.__member(VREventInputActionManifestLoad.SIZEOF, VREventInputActionManifestLoad.ALIGNOF), VREventData.__member(VREventSpatialAnchor.SIZEOF, VREventSpatialAnchor.ALIGNOF), VREventData.__member(VREventProgressUpdate.SIZEOF, VREventProgressUpdate.ALIGNOF), VREventData.__member(VREventShowUI.SIZEOF, VREventShowUI.ALIGNOF), VREventData.__member(VREventShowDevTools.SIZEOF, VREventShowDevTools.ALIGNOF), VREventData.__member(VREventHDCPError.SIZEOF, VREventHDCPError.ALIGNOF), VREventData.__member(VREventAudioVolumeControl.SIZEOF, VREventAudioVolumeControl.ALIGNOF), VREventData.__member(VREventAudioMuteControl.SIZEOF, VREventAudioMuteControl.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        RESERVED = layout.offsetof(0);
        CONTROLLER = layout.offsetof(1);
        MOUSE = layout.offsetof(2);
        SCROLL = layout.offsetof(3);
        PROCESS = layout.offsetof(4);
        NOTIFICATION = layout.offsetof(5);
        OVERLAY = layout.offsetof(6);
        STATUS = layout.offsetof(7);
        KEYBOARD = layout.offsetof(8);
        IPD = layout.offsetof(9);
        CHAPERONE = layout.offsetof(10);
        PERFORMANCETEST = layout.offsetof(11);
        TOUCHPADMOVE = layout.offsetof(12);
        SEATEDZEROPOSERESET = layout.offsetof(13);
        SCREENSHOT = layout.offsetof(14);
        SCREENSHOTPROGRESS = layout.offsetof(15);
        APPLICATIONLAUNCH = layout.offsetof(16);
        CAMERASURFACE = layout.offsetof(17);
        MESSAGEOVERLAY = layout.offsetof(18);
        PROPERTY = layout.offsetof(19);
        HAPTICVIBRATION = layout.offsetof(20);
        WEBCONSOLE = layout.offsetof(21);
        INPUTBINDING = layout.offsetof(22);
        ACTIONMANIFEST = layout.offsetof(23);
        SPATIALANCHOR = layout.offsetof(24);
        PROGRESSUPDATE = layout.offsetof(25);
        SHOWUI = layout.offsetof(26);
        SHOWDEVTOOLS = layout.offsetof(27);
        HDCPERROR = layout.offsetof(28);
        AUDIOVOLUMECONTROL = layout.offsetof(29);
        AUDIOMUTECONTROL = layout.offsetof(30);
    }

    public static class Buffer
    extends StructBuffer<VREventData, Buffer> {
        private static final VREventData ELEMENT_FACTORY = VREventData.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VREventData getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VREvent_Reserved_t")
        public VREventReserved reserved() {
            return VREventData.nreserved(this.address());
        }

        @NativeType(value="VREvent_Controller_t")
        public VREventController controller() {
            return VREventData.ncontroller(this.address());
        }

        @NativeType(value="VREvent_Mouse_t")
        public VREventMouse mouse() {
            return VREventData.nmouse(this.address());
        }

        @NativeType(value="VREvent_Scroll_t")
        public VREventScroll scroll() {
            return VREventData.nscroll(this.address());
        }

        @NativeType(value="VREvent_Process_t")
        public VREventProcess process() {
            return VREventData.nprocess(this.address());
        }

        @NativeType(value="VREvent_Notification_t")
        public VREventNotification notification() {
            return VREventData.nnotification(this.address());
        }

        @NativeType(value="VREvent_Overlay_t")
        public VREventOverlay overlay() {
            return VREventData.noverlay(this.address());
        }

        @NativeType(value="VREvent_Status_t")
        public VREventStatus status() {
            return VREventData.nstatus(this.address());
        }

        @NativeType(value="VREvent_Keyboard_t")
        public VREventKeyboard keyboard() {
            return VREventData.nkeyboard(this.address());
        }

        @NativeType(value="VREvent_Ipd_t")
        public VREventIpd ipd() {
            return VREventData.nipd(this.address());
        }

        @NativeType(value="VREvent_Chaperone_t")
        public VREventChaperone chaperone() {
            return VREventData.nchaperone(this.address());
        }

        @NativeType(value="VREvent_PerformanceTest_t")
        public VREventPerformanceTest performanceTest() {
            return VREventData.nperformanceTest(this.address());
        }

        @NativeType(value="VREvent_TouchPadMove_t")
        public VREventTouchPadMove touchPadMove() {
            return VREventData.ntouchPadMove(this.address());
        }

        @NativeType(value="VREvent_SeatedZeroPoseReset_t")
        public VREventSeatedZeroPoseReset seatedZeroPoseReset() {
            return VREventData.nseatedZeroPoseReset(this.address());
        }

        @NativeType(value="VREvent_Screenshot_t")
        public VREventScreenshot screenshot() {
            return VREventData.nscreenshot(this.address());
        }

        @NativeType(value="VREvent_ScreenshotProgress_t")
        public VREventScreenshotProgress screenshotProgress() {
            return VREventData.nscreenshotProgress(this.address());
        }

        @NativeType(value="VREvent_ApplicationLaunch_t")
        public VREventApplicationLaunch applicationLaunch() {
            return VREventData.napplicationLaunch(this.address());
        }

        @NativeType(value="VREvent_EditingCameraSurface_t")
        public VREventEditingCameraSurface cameraSurface() {
            return VREventData.ncameraSurface(this.address());
        }

        @NativeType(value="VREvent_MessageOverlay_t")
        public VREventMessageOverlay messageOverlay() {
            return VREventData.nmessageOverlay(this.address());
        }

        @NativeType(value="VREvent_Property_t")
        public VREventProperty property() {
            return VREventData.nproperty(this.address());
        }

        @NativeType(value="VREvent_HapticVibration_t")
        public VREventHapticVibration hapticVibration() {
            return VREventData.nhapticVibration(this.address());
        }

        @NativeType(value="VREvent_WebConsole_t")
        public VREventWebConsole webConsole() {
            return VREventData.nwebConsole(this.address());
        }

        @NativeType(value="VREvent_InputBindingLoad_t")
        public VREventInputBindingLoad inputBinding() {
            return VREventData.ninputBinding(this.address());
        }

        @NativeType(value="VREvent_InputActionManifestLoad_t")
        public VREventInputActionManifestLoad actionManifest() {
            return VREventData.nactionManifest(this.address());
        }

        @NativeType(value="VREvent_SpatialAnchor_t")
        public VREventSpatialAnchor spatialAnchor() {
            return VREventData.nspatialAnchor(this.address());
        }

        @NativeType(value="VREvent_ProgressUpdate_t")
        public VREventProgressUpdate progressUpdate() {
            return VREventData.nprogressUpdate(this.address());
        }

        @NativeType(value="VREvent_ShowUI_t")
        public VREventShowUI showUi() {
            return VREventData.nshowUi(this.address());
        }

        @NativeType(value="VREvent_ShowDevTools_t")
        public VREventShowDevTools showDevTools() {
            return VREventData.nshowDevTools(this.address());
        }

        @NativeType(value="VREvent_HDCPError_t")
        public VREventHDCPError hdcpError() {
            return VREventData.nhdcpError(this.address());
        }

        @NativeType(value="VREvent_AudioVolumeControl_t")
        public VREventAudioVolumeControl audioVolumeControl() {
            return VREventData.naudioVolumeControl(this.address());
        }

        @NativeType(value="VREvent_AudioMuteControl_t")
        public VREventAudioMuteControl audioMuteControl() {
            return VREventData.naudioMuteControl(this.address());
        }
    }
}

