/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openvr.HmdVector2;
import org.lwjgl.openvr.HmdVector3;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct VROverlayIntersectionResults_t")
public class VROverlayIntersectionResults
extends Struct<VROverlayIntersectionResults>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VPOINT;
    public static final int VNORMAL;
    public static final int VUVS;
    public static final int FDISTANCE;

    protected VROverlayIntersectionResults(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VROverlayIntersectionResults create(long address, @Nullable ByteBuffer container) {
        return new VROverlayIntersectionResults(address, container);
    }

    public VROverlayIntersectionResults(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VROverlayIntersectionResults.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="HmdVector3_t")
    public HmdVector3 vPoint() {
        return VROverlayIntersectionResults.nvPoint(this.address());
    }

    @NativeType(value="HmdVector3_t")
    public HmdVector3 vNormal() {
        return VROverlayIntersectionResults.nvNormal(this.address());
    }

    @NativeType(value="HmdVector2_t")
    public HmdVector2 vUVs() {
        return VROverlayIntersectionResults.nvUVs(this.address());
    }

    public float fDistance() {
        return VROverlayIntersectionResults.nfDistance(this.address());
    }

    public static VROverlayIntersectionResults malloc() {
        return new VROverlayIntersectionResults(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VROverlayIntersectionResults calloc() {
        return new VROverlayIntersectionResults(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VROverlayIntersectionResults create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VROverlayIntersectionResults(MemoryUtil.memAddress(container), container);
    }

    public static VROverlayIntersectionResults create(long address) {
        return new VROverlayIntersectionResults(address, null);
    }

    public static @Nullable VROverlayIntersectionResults createSafe(long address) {
        return address == 0L ? null : new VROverlayIntersectionResults(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VROverlayIntersectionResults.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VROverlayIntersectionResults.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VROverlayIntersectionResults mallocStack() {
        return VROverlayIntersectionResults.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VROverlayIntersectionResults callocStack() {
        return VROverlayIntersectionResults.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VROverlayIntersectionResults mallocStack(MemoryStack stack) {
        return VROverlayIntersectionResults.malloc(stack);
    }

    @Deprecated
    public static VROverlayIntersectionResults callocStack(MemoryStack stack) {
        return VROverlayIntersectionResults.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VROverlayIntersectionResults.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VROverlayIntersectionResults.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VROverlayIntersectionResults.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VROverlayIntersectionResults.calloc(capacity, stack);
    }

    public static VROverlayIntersectionResults malloc(MemoryStack stack) {
        return new VROverlayIntersectionResults(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VROverlayIntersectionResults calloc(MemoryStack stack) {
        return new VROverlayIntersectionResults(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static HmdVector3 nvPoint(long struct) {
        return HmdVector3.create(struct + (long)VPOINT);
    }

    public static HmdVector3 nvNormal(long struct) {
        return HmdVector3.create(struct + (long)VNORMAL);
    }

    public static HmdVector2 nvUVs(long struct) {
        return HmdVector2.create(struct + (long)VUVS);
    }

    public static float nfDistance(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)FDISTANCE);
    }

    static {
        Struct.Layout layout = VROverlayIntersectionResults.__struct(VROverlayIntersectionResults.__member(HmdVector3.SIZEOF, HmdVector3.ALIGNOF), VROverlayIntersectionResults.__member(HmdVector3.SIZEOF, HmdVector3.ALIGNOF), VROverlayIntersectionResults.__member(HmdVector2.SIZEOF, HmdVector2.ALIGNOF), VROverlayIntersectionResults.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VPOINT = layout.offsetof(0);
        VNORMAL = layout.offsetof(1);
        VUVS = layout.offsetof(2);
        FDISTANCE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VROverlayIntersectionResults, Buffer>
    implements NativeResource {
        private static final VROverlayIntersectionResults ELEMENT_FACTORY = VROverlayIntersectionResults.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VROverlayIntersectionResults getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="HmdVector3_t")
        public HmdVector3 vPoint() {
            return VROverlayIntersectionResults.nvPoint(this.address());
        }

        @NativeType(value="HmdVector3_t")
        public HmdVector3 vNormal() {
            return VROverlayIntersectionResults.nvNormal(this.address());
        }

        @NativeType(value="HmdVector2_t")
        public HmdVector2 vUVs() {
            return VROverlayIntersectionResults.nvUVs(this.address());
        }

        public float fDistance() {
            return VROverlayIntersectionResults.nfDistance(this.address());
        }
    }
}

