/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openvr.Texture;
import org.lwjgl.openvr.VRTextureBounds;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VROverlayView_t
extends Struct<VROverlayView_t>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int OVERLAYHANDLE;
    public static final int TEXTURE;
    public static final int TEXTUREBOUNDS;

    protected VROverlayView_t(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VROverlayView_t create(long address, @Nullable ByteBuffer container) {
        return new VROverlayView_t(address, container);
    }

    public VROverlayView_t(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VROverlayView_t.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VROverlayHandle_t")
    public long overlayHandle() {
        return VROverlayView_t.noverlayHandle(this.address());
    }

    @NativeType(value="Texture_t")
    public Texture texture() {
        return VROverlayView_t.ntexture(this.address());
    }

    @NativeType(value="VRTextureBounds_t")
    public VRTextureBounds textureBounds() {
        return VROverlayView_t.ntextureBounds(this.address());
    }

    public static VROverlayView_t malloc() {
        return new VROverlayView_t(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VROverlayView_t calloc() {
        return new VROverlayView_t(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VROverlayView_t create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VROverlayView_t(MemoryUtil.memAddress(container), container);
    }

    public static VROverlayView_t create(long address) {
        return new VROverlayView_t(address, null);
    }

    public static @Nullable VROverlayView_t createSafe(long address) {
        return address == 0L ? null : new VROverlayView_t(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VROverlayView_t.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VROverlayView_t.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VROverlayView_t malloc(MemoryStack stack) {
        return new VROverlayView_t(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VROverlayView_t calloc(MemoryStack stack) {
        return new VROverlayView_t(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long noverlayHandle(long struct) {
        return MemoryUtil.memGetLong(struct + (long)OVERLAYHANDLE);
    }

    public static Texture ntexture(long struct) {
        return Texture.create(struct + (long)TEXTURE);
    }

    public static VRTextureBounds ntextureBounds(long struct) {
        return VRTextureBounds.create(struct + (long)TEXTUREBOUNDS);
    }

    static {
        Struct.Layout layout = VROverlayView_t.__struct(VROverlayView_t.__member(8), VROverlayView_t.__member(Texture.SIZEOF, Texture.ALIGNOF), VROverlayView_t.__member(VRTextureBounds.SIZEOF, VRTextureBounds.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        OVERLAYHANDLE = layout.offsetof(0);
        TEXTURE = layout.offsetof(1);
        TEXTUREBOUNDS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VROverlayView_t, Buffer>
    implements NativeResource {
        private static final VROverlayView_t ELEMENT_FACTORY = VROverlayView_t.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VROverlayView_t getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VROverlayHandle_t")
        public long overlayHandle() {
            return VROverlayView_t.noverlayHandle(this.address());
        }

        @NativeType(value="Texture_t")
        public Texture texture() {
            return VROverlayView_t.ntexture(this.address());
        }

        @NativeType(value="VRTextureBounds_t")
        public VRTextureBounds textureBounds() {
            return VROverlayView_t.ntextureBounds(this.address());
        }
    }
}

