/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openvr.HmdMatrix44;
import org.lwjgl.openvr.HmdVector2;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct VRTextureDepthInfo_t")
public class VRTextureDepthInfo
extends Struct<VRTextureDepthInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HANDLE;
    public static final int MPROJECTION;
    public static final int VRANGE;

    protected VRTextureDepthInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VRTextureDepthInfo create(long address, @Nullable ByteBuffer container) {
        return new VRTextureDepthInfo(address, container);
    }

    public VRTextureDepthInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VRTextureDepthInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void *")
    public long handle() {
        return VRTextureDepthInfo.nhandle(this.address());
    }

    @NativeType(value="HmdMatrix44_t")
    public HmdMatrix44 mProjection() {
        return VRTextureDepthInfo.nmProjection(this.address());
    }

    @NativeType(value="HmdVector2_t")
    public HmdVector2 vRange() {
        return VRTextureDepthInfo.nvRange(this.address());
    }

    public VRTextureDepthInfo handle(@NativeType(value="void *") long value) {
        VRTextureDepthInfo.nhandle(this.address(), value);
        return this;
    }

    public VRTextureDepthInfo mProjection(@NativeType(value="HmdMatrix44_t") HmdMatrix44 value) {
        VRTextureDepthInfo.nmProjection(this.address(), value);
        return this;
    }

    public VRTextureDepthInfo mProjection(Consumer<HmdMatrix44> consumer) {
        consumer.accept(this.mProjection());
        return this;
    }

    public VRTextureDepthInfo vRange(@NativeType(value="HmdVector2_t") HmdVector2 value) {
        VRTextureDepthInfo.nvRange(this.address(), value);
        return this;
    }

    public VRTextureDepthInfo vRange(Consumer<HmdVector2> consumer) {
        consumer.accept(this.vRange());
        return this;
    }

    public VRTextureDepthInfo set(long handle, HmdMatrix44 mProjection, HmdVector2 vRange) {
        this.handle(handle);
        this.mProjection(mProjection);
        this.vRange(vRange);
        return this;
    }

    public VRTextureDepthInfo set(VRTextureDepthInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VRTextureDepthInfo malloc() {
        return new VRTextureDepthInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VRTextureDepthInfo calloc() {
        return new VRTextureDepthInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VRTextureDepthInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VRTextureDepthInfo(MemoryUtil.memAddress(container), container);
    }

    public static VRTextureDepthInfo create(long address) {
        return new VRTextureDepthInfo(address, null);
    }

    public static @Nullable VRTextureDepthInfo createSafe(long address) {
        return address == 0L ? null : new VRTextureDepthInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VRTextureDepthInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VRTextureDepthInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VRTextureDepthInfo mallocStack() {
        return VRTextureDepthInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VRTextureDepthInfo callocStack() {
        return VRTextureDepthInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VRTextureDepthInfo mallocStack(MemoryStack stack) {
        return VRTextureDepthInfo.malloc(stack);
    }

    @Deprecated
    public static VRTextureDepthInfo callocStack(MemoryStack stack) {
        return VRTextureDepthInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VRTextureDepthInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VRTextureDepthInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VRTextureDepthInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VRTextureDepthInfo.calloc(capacity, stack);
    }

    public static VRTextureDepthInfo malloc(MemoryStack stack) {
        return new VRTextureDepthInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VRTextureDepthInfo calloc(MemoryStack stack) {
        return new VRTextureDepthInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nhandle(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)HANDLE);
    }

    public static HmdMatrix44 nmProjection(long struct) {
        return HmdMatrix44.create(struct + (long)MPROJECTION);
    }

    public static HmdVector2 nvRange(long struct) {
        return HmdVector2.create(struct + (long)VRANGE);
    }

    public static void nhandle(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)HANDLE, Checks.check(value));
    }

    public static void nmProjection(long struct, HmdMatrix44 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)MPROJECTION, HmdMatrix44.SIZEOF);
    }

    public static void nvRange(long struct, HmdVector2 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)VRANGE, HmdVector2.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)HANDLE));
    }

    static {
        Struct.Layout layout = VRTextureDepthInfo.__struct(VRTextureDepthInfo.__member(POINTER_SIZE), VRTextureDepthInfo.__member(HmdMatrix44.SIZEOF, HmdMatrix44.ALIGNOF), VRTextureDepthInfo.__member(HmdVector2.SIZEOF, HmdVector2.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HANDLE = layout.offsetof(0);
        MPROJECTION = layout.offsetof(1);
        VRANGE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VRTextureDepthInfo, Buffer>
    implements NativeResource {
        private static final VRTextureDepthInfo ELEMENT_FACTORY = VRTextureDepthInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VRTextureDepthInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void *")
        public long handle() {
            return VRTextureDepthInfo.nhandle(this.address());
        }

        @NativeType(value="HmdMatrix44_t")
        public HmdMatrix44 mProjection() {
            return VRTextureDepthInfo.nmProjection(this.address());
        }

        @NativeType(value="HmdVector2_t")
        public HmdVector2 vRange() {
            return VRTextureDepthInfo.nvRange(this.address());
        }

        public Buffer handle(@NativeType(value="void *") long value) {
            VRTextureDepthInfo.nhandle(this.address(), value);
            return this;
        }

        public Buffer mProjection(@NativeType(value="HmdMatrix44_t") HmdMatrix44 value) {
            VRTextureDepthInfo.nmProjection(this.address(), value);
            return this;
        }

        public Buffer mProjection(Consumer<HmdMatrix44> consumer) {
            consumer.accept(this.mProjection());
            return this;
        }

        public Buffer vRange(@NativeType(value="HmdVector2_t") HmdVector2 value) {
            VRTextureDepthInfo.nvRange(this.address(), value);
            return this;
        }

        public Buffer vRange(Consumer<HmdVector2> consumer) {
            consumer.accept(this.vRange());
            return this;
        }
    }
}

