/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct VRVulkanDevice_t")
public class VRVulkanDevice
extends Struct<VRVulkanDevice>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int M_PINSTANCE;
    public static final int M_PDEVICE;
    public static final int M_PPHYSICALDEVICE;
    public static final int M_PQUEUE;
    public static final int M_UQUEUEFAMILYINDEX;

    protected VRVulkanDevice(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VRVulkanDevice create(long address, @Nullable ByteBuffer container) {
        return new VRVulkanDevice(address, container);
    }

    public VRVulkanDevice(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VRVulkanDevice.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkInstance_T *")
    public long m_pInstance() {
        return VRVulkanDevice.nm_pInstance(this.address());
    }

    @NativeType(value="VkDevice_T *")
    public long m_pDevice() {
        return VRVulkanDevice.nm_pDevice(this.address());
    }

    @NativeType(value="VkPhysicalDevice_T *")
    public long m_pPhysicalDevice() {
        return VRVulkanDevice.nm_pPhysicalDevice(this.address());
    }

    @NativeType(value="VkQueue_T *")
    public long m_pQueue() {
        return VRVulkanDevice.nm_pQueue(this.address());
    }

    @NativeType(value="uint32_t")
    public int m_uQueueFamilyIndex() {
        return VRVulkanDevice.nm_uQueueFamilyIndex(this.address());
    }

    public VRVulkanDevice m_pInstance(@NativeType(value="VkInstance_T *") long value) {
        VRVulkanDevice.nm_pInstance(this.address(), value);
        return this;
    }

    public VRVulkanDevice m_pDevice(@NativeType(value="VkDevice_T *") long value) {
        VRVulkanDevice.nm_pDevice(this.address(), value);
        return this;
    }

    public VRVulkanDevice m_pPhysicalDevice(@NativeType(value="VkPhysicalDevice_T *") long value) {
        VRVulkanDevice.nm_pPhysicalDevice(this.address(), value);
        return this;
    }

    public VRVulkanDevice m_pQueue(@NativeType(value="VkQueue_T *") long value) {
        VRVulkanDevice.nm_pQueue(this.address(), value);
        return this;
    }

    public VRVulkanDevice m_uQueueFamilyIndex(@NativeType(value="uint32_t") int value) {
        VRVulkanDevice.nm_uQueueFamilyIndex(this.address(), value);
        return this;
    }

    public VRVulkanDevice set(long m_pInstance, long m_pDevice, long m_pPhysicalDevice, long m_pQueue, int m_uQueueFamilyIndex) {
        this.m_pInstance(m_pInstance);
        this.m_pDevice(m_pDevice);
        this.m_pPhysicalDevice(m_pPhysicalDevice);
        this.m_pQueue(m_pQueue);
        this.m_uQueueFamilyIndex(m_uQueueFamilyIndex);
        return this;
    }

    public VRVulkanDevice set(VRVulkanDevice src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VRVulkanDevice malloc() {
        return new VRVulkanDevice(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VRVulkanDevice calloc() {
        return new VRVulkanDevice(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VRVulkanDevice create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VRVulkanDevice(MemoryUtil.memAddress(container), container);
    }

    public static VRVulkanDevice create(long address) {
        return new VRVulkanDevice(address, null);
    }

    public static @Nullable VRVulkanDevice createSafe(long address) {
        return address == 0L ? null : new VRVulkanDevice(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VRVulkanDevice.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VRVulkanDevice.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VRVulkanDevice malloc(MemoryStack stack) {
        return new VRVulkanDevice(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VRVulkanDevice calloc(MemoryStack stack) {
        return new VRVulkanDevice(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nm_pInstance(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)M_PINSTANCE);
    }

    public static long nm_pDevice(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)M_PDEVICE);
    }

    public static long nm_pPhysicalDevice(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)M_PPHYSICALDEVICE);
    }

    public static long nm_pQueue(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)M_PQUEUE);
    }

    public static int nm_uQueueFamilyIndex(long struct) {
        return MemoryUtil.memGetInt(struct + (long)M_UQUEUEFAMILYINDEX);
    }

    public static void nm_pInstance(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)M_PINSTANCE, Checks.check(value));
    }

    public static void nm_pDevice(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)M_PDEVICE, Checks.check(value));
    }

    public static void nm_pPhysicalDevice(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)M_PPHYSICALDEVICE, Checks.check(value));
    }

    public static void nm_pQueue(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)M_PQUEUE, Checks.check(value));
    }

    public static void nm_uQueueFamilyIndex(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)M_UQUEUEFAMILYINDEX, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)M_PINSTANCE));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)M_PDEVICE));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)M_PPHYSICALDEVICE));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)M_PQUEUE));
    }

    static {
        Struct.Layout layout = VRVulkanDevice.__struct(VRVulkanDevice.__member(POINTER_SIZE), VRVulkanDevice.__member(POINTER_SIZE), VRVulkanDevice.__member(POINTER_SIZE), VRVulkanDevice.__member(POINTER_SIZE), VRVulkanDevice.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        M_PINSTANCE = layout.offsetof(0);
        M_PDEVICE = layout.offsetof(1);
        M_PPHYSICALDEVICE = layout.offsetof(2);
        M_PQUEUE = layout.offsetof(3);
        M_UQUEUEFAMILYINDEX = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VRVulkanDevice, Buffer>
    implements NativeResource {
        private static final VRVulkanDevice ELEMENT_FACTORY = VRVulkanDevice.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VRVulkanDevice getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkInstance_T *")
        public long m_pInstance() {
            return VRVulkanDevice.nm_pInstance(this.address());
        }

        @NativeType(value="VkDevice_T *")
        public long m_pDevice() {
            return VRVulkanDevice.nm_pDevice(this.address());
        }

        @NativeType(value="VkPhysicalDevice_T *")
        public long m_pPhysicalDevice() {
            return VRVulkanDevice.nm_pPhysicalDevice(this.address());
        }

        @NativeType(value="VkQueue_T *")
        public long m_pQueue() {
            return VRVulkanDevice.nm_pQueue(this.address());
        }

        @NativeType(value="uint32_t")
        public int m_uQueueFamilyIndex() {
            return VRVulkanDevice.nm_uQueueFamilyIndex(this.address());
        }

        public Buffer m_pInstance(@NativeType(value="VkInstance_T *") long value) {
            VRVulkanDevice.nm_pInstance(this.address(), value);
            return this;
        }

        public Buffer m_pDevice(@NativeType(value="VkDevice_T *") long value) {
            VRVulkanDevice.nm_pDevice(this.address(), value);
            return this;
        }

        public Buffer m_pPhysicalDevice(@NativeType(value="VkPhysicalDevice_T *") long value) {
            VRVulkanDevice.nm_pPhysicalDevice(this.address(), value);
            return this;
        }

        public Buffer m_pQueue(@NativeType(value="VkQueue_T *") long value) {
            VRVulkanDevice.nm_pQueue(this.address(), value);
            return this;
        }

        public Buffer m_uQueueFamilyIndex(@NativeType(value="uint32_t") int value) {
            VRVulkanDevice.nm_uQueueFamilyIndex(this.address(), value);
            return this;
        }
    }
}

