/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.Buffer;
import java.nio.LongBuffer;
import org.lwjgl.openxr.XrSession;
import org.lwjgl.openxr.XrSpaceEraseInfoFB;
import org.lwjgl.openxr.XrSpaceSaveInfoFB;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class FBSpatialEntityStorage {
    public static final int XR_FB_spatial_entity_storage_SPEC_VERSION = 1;
    public static final String XR_FB_SPATIAL_ENTITY_STORAGE_EXTENSION_NAME = "XR_FB_spatial_entity_storage";
    public static final int XR_TYPE_SPACE_SAVE_INFO_FB = 1000158000;
    public static final int XR_TYPE_SPACE_ERASE_INFO_FB = 1000158001;
    public static final int XR_TYPE_EVENT_DATA_SPACE_SAVE_COMPLETE_FB = 1000158106;
    public static final int XR_TYPE_EVENT_DATA_SPACE_ERASE_COMPLETE_FB = 1000158107;
    public static final int XR_SPACE_PERSISTENCE_MODE_INVALID_FB = 0;
    public static final int XR_SPACE_PERSISTENCE_MODE_INDEFINITE_FB = 1;

    protected FBSpatialEntityStorage() {
        throw new UnsupportedOperationException();
    }

    public static int nxrSaveSpaceFB(XrSession session, long info, long requestId) {
        long __functionAddress = session.getCapabilities().xrSaveSpaceFB;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            XrSpaceSaveInfoFB.validate(info);
        }
        return JNI.callPPPI(session.address(), info, requestId, __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrSaveSpaceFB(XrSession session, @NativeType(value="XrSpaceSaveInfoFB const *") XrSpaceSaveInfoFB info, @NativeType(value="XrAsyncRequestIdFB *") LongBuffer requestId) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)requestId, 1);
        }
        return FBSpatialEntityStorage.nxrSaveSpaceFB(session, info.address(), MemoryUtil.memAddress(requestId));
    }

    public static int nxrEraseSpaceFB(XrSession session, long info, long requestId) {
        long __functionAddress = session.getCapabilities().xrEraseSpaceFB;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            XrSpaceEraseInfoFB.validate(info);
        }
        return JNI.callPPPI(session.address(), info, requestId, __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrEraseSpaceFB(XrSession session, @NativeType(value="XrSpaceEraseInfoFB const *") XrSpaceEraseInfoFB info, @NativeType(value="XrAsyncRequestIdFB *") LongBuffer requestId) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)requestId, 1);
        }
        return FBSpatialEntityStorage.nxrEraseSpaceFB(session, info.address(), MemoryUtil.memAddress(requestId));
    }
}

