/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import org.lwjgl.PointerBuffer;
import org.lwjgl.openxr.XrPassthroughCreateInfoHTC;
import org.lwjgl.openxr.XrPassthroughHTC;
import org.lwjgl.openxr.XrSession;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class HTCPassthrough {
    public static final int XR_HTC_passthrough_SPEC_VERSION = 1;
    public static final String XR_HTC_PASSTHROUGH_EXTENSION_NAME = "XR_HTC_passthrough";
    public static final int XR_OBJECT_TYPE_PASSTHROUGH_HTC = 1000317000;
    public static final int XR_TYPE_PASSTHROUGH_CREATE_INFO_HTC = 1000317001;
    public static final int XR_TYPE_PASSTHROUGH_COLOR_HTC = 1000317002;
    public static final int XR_TYPE_PASSTHROUGH_MESH_TRANSFORM_INFO_HTC = 1000317003;
    public static final int XR_TYPE_COMPOSITION_LAYER_PASSTHROUGH_HTC = 1000317004;
    public static final int XR_PASSTHROUGH_FORM_PLANAR_HTC = 0;
    public static final int XR_PASSTHROUGH_FORM_PROJECTED_HTC = 1;

    protected HTCPassthrough() {
        throw new UnsupportedOperationException();
    }

    public static int nxrCreatePassthroughHTC(XrSession session, long createInfo, long passthrough) {
        long __functionAddress = session.getCapabilities().xrCreatePassthroughHTC;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPI(session.address(), createInfo, passthrough, __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrCreatePassthroughHTC(XrSession session, @NativeType(value="XrPassthroughCreateInfoHTC const *") XrPassthroughCreateInfoHTC createInfo, @NativeType(value="XrPassthroughHTC *") PointerBuffer passthrough) {
        if (Checks.CHECKS) {
            Checks.check(passthrough, 1);
        }
        return HTCPassthrough.nxrCreatePassthroughHTC(session, createInfo.address(), MemoryUtil.memAddress(passthrough));
    }

    @NativeType(value="XrResult")
    public static int xrDestroyPassthroughHTC(XrPassthroughHTC passthrough) {
        long __functionAddress = passthrough.getCapabilities().xrDestroyPassthroughHTC;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(passthrough.address(), __functionAddress);
    }
}

