/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.Buffer;
import java.nio.LongBuffer;
import org.lwjgl.openxr.XrInstance;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.windows.LARGE_INTEGER;

public class KHRWin32ConvertPerformanceCounterTime {
    public static final int XR_KHR_win32_convert_performance_counter_time_SPEC_VERSION = 1;
    public static final String XR_KHR_WIN32_CONVERT_PERFORMANCE_COUNTER_TIME_EXTENSION_NAME = "XR_KHR_win32_convert_performance_counter_time";

    protected KHRWin32ConvertPerformanceCounterTime() {
        throw new UnsupportedOperationException();
    }

    public static int nxrConvertWin32PerformanceCounterToTimeKHR(XrInstance instance, long performanceCounter, long time) {
        long __functionAddress = instance.getCapabilities().xrConvertWin32PerformanceCounterToTimeKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPI(instance.address(), performanceCounter, time, __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrConvertWin32PerformanceCounterToTimeKHR(XrInstance instance, @NativeType(value="LARGE_INTEGER const *") LARGE_INTEGER performanceCounter, @NativeType(value="XrTime *") LongBuffer time) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)time, 1);
        }
        return KHRWin32ConvertPerformanceCounterTime.nxrConvertWin32PerformanceCounterToTimeKHR(instance, performanceCounter.address(), MemoryUtil.memAddress(time));
    }

    public static int nxrConvertTimeToWin32PerformanceCounterKHR(XrInstance instance, long time, long performanceCounter) {
        long __functionAddress = instance.getCapabilities().xrConvertTimeToWin32PerformanceCounterKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPJPI(instance.address(), time, performanceCounter, __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrConvertTimeToWin32PerformanceCounterKHR(XrInstance instance, @NativeType(value="XrTime") long time, @NativeType(value="LARGE_INTEGER *") LARGE_INTEGER performanceCounter) {
        return KHRWin32ConvertPerformanceCounterTime.nxrConvertTimeToWin32PerformanceCounterKHR(instance, time, performanceCounter.address());
    }
}

