/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.Buffer;
import java.nio.LongBuffer;
import org.lwjgl.openxr.XrColocationAdvertisementStartInfoMETA;
import org.lwjgl.openxr.XrColocationAdvertisementStopInfoMETA;
import org.lwjgl.openxr.XrColocationDiscoveryStartInfoMETA;
import org.lwjgl.openxr.XrColocationDiscoveryStopInfoMETA;
import org.lwjgl.openxr.XrSession;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class METAColocationDiscovery {
    public static final int XR_META_colocation_discovery_SPEC_VERSION = 1;
    public static final String XR_META_COLOCATION_DISCOVERY_EXTENSION_NAME = "XR_META_colocation_discovery";
    public static final int XR_MAX_COLOCATION_DISCOVERY_BUFFER_SIZE_META = 1024;
    public static final int XR_ERROR_COLOCATION_DISCOVERY_NETWORK_FAILED_META = -1000571001;
    public static final int XR_ERROR_COLOCATION_DISCOVERY_NO_DISCOVERY_METHOD_META = -1000571002;
    public static final int XR_COLOCATION_DISCOVERY_ALREADY_ADVERTISING_META = 1000571003;
    public static final int XR_COLOCATION_DISCOVERY_ALREADY_DISCOVERING_META = 1000571004;
    public static final int XR_TYPE_COLOCATION_DISCOVERY_START_INFO_META = 1000571010;
    public static final int XR_TYPE_COLOCATION_DISCOVERY_STOP_INFO_META = 1000571011;
    public static final int XR_TYPE_COLOCATION_ADVERTISEMENT_START_INFO_META = 1000571012;
    public static final int XR_TYPE_COLOCATION_ADVERTISEMENT_STOP_INFO_META = 1000571013;
    public static final int XR_TYPE_EVENT_DATA_START_COLOCATION_ADVERTISEMENT_COMPLETE_META = 1000571020;
    public static final int XR_TYPE_EVENT_DATA_STOP_COLOCATION_ADVERTISEMENT_COMPLETE_META = 1000571021;
    public static final int XR_TYPE_EVENT_DATA_COLOCATION_ADVERTISEMENT_COMPLETE_META = 1000571022;
    public static final int XR_TYPE_EVENT_DATA_START_COLOCATION_DISCOVERY_COMPLETE_META = 1000571023;
    public static final int XR_TYPE_EVENT_DATA_COLOCATION_DISCOVERY_RESULT_META = 1000571024;
    public static final int XR_TYPE_EVENT_DATA_COLOCATION_DISCOVERY_COMPLETE_META = 1000571025;
    public static final int XR_TYPE_EVENT_DATA_STOP_COLOCATION_DISCOVERY_COMPLETE_META = 1000571026;
    public static final int XR_TYPE_SYSTEM_COLOCATION_DISCOVERY_PROPERTIES_META = 1000571030;

    protected METAColocationDiscovery() {
        throw new UnsupportedOperationException();
    }

    public static int nxrStartColocationDiscoveryMETA(XrSession session, long info, long discoveryRequestId) {
        long __functionAddress = session.getCapabilities().xrStartColocationDiscoveryMETA;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPI(session.address(), info, discoveryRequestId, __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrStartColocationDiscoveryMETA(XrSession session, @NativeType(value="XrColocationDiscoveryStartInfoMETA const *") XrColocationDiscoveryStartInfoMETA info, @NativeType(value="XrAsyncRequestIdFB *") LongBuffer discoveryRequestId) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)discoveryRequestId, 1);
        }
        return METAColocationDiscovery.nxrStartColocationDiscoveryMETA(session, info.address(), MemoryUtil.memAddress(discoveryRequestId));
    }

    public static int nxrStopColocationDiscoveryMETA(XrSession session, long info, long requestId) {
        long __functionAddress = session.getCapabilities().xrStopColocationDiscoveryMETA;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPI(session.address(), info, requestId, __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrStopColocationDiscoveryMETA(XrSession session, @NativeType(value="XrColocationDiscoveryStopInfoMETA const *") XrColocationDiscoveryStopInfoMETA info, @NativeType(value="XrAsyncRequestIdFB *") LongBuffer requestId) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)requestId, 1);
        }
        return METAColocationDiscovery.nxrStopColocationDiscoveryMETA(session, info.address(), MemoryUtil.memAddress(requestId));
    }

    public static int nxrStartColocationAdvertisementMETA(XrSession session, long info, long advertisementRequestId) {
        long __functionAddress = session.getCapabilities().xrStartColocationAdvertisementMETA;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            XrColocationAdvertisementStartInfoMETA.validate(info);
        }
        return JNI.callPPPI(session.address(), info, advertisementRequestId, __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrStartColocationAdvertisementMETA(XrSession session, @NativeType(value="XrColocationAdvertisementStartInfoMETA const *") XrColocationAdvertisementStartInfoMETA info, @NativeType(value="XrAsyncRequestIdFB *") LongBuffer advertisementRequestId) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)advertisementRequestId, 1);
        }
        return METAColocationDiscovery.nxrStartColocationAdvertisementMETA(session, info.address(), MemoryUtil.memAddress(advertisementRequestId));
    }

    public static int nxrStopColocationAdvertisementMETA(XrSession session, long info, long requestId) {
        long __functionAddress = session.getCapabilities().xrStopColocationAdvertisementMETA;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPI(session.address(), info, requestId, __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrStopColocationAdvertisementMETA(XrSession session, @NativeType(value="XrColocationAdvertisementStopInfoMETA const *") XrColocationAdvertisementStopInfoMETA info, @NativeType(value="XrAsyncRequestIdFB *") LongBuffer requestId) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)requestId, 1);
        }
        return METAColocationDiscovery.nxrStopColocationAdvertisementMETA(session, info.address(), MemoryUtil.memAddress(requestId));
    }
}

