/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import org.lwjgl.PointerBuffer;
import org.lwjgl.openxr.XrSession;
import org.lwjgl.openxr.XrSpatialAnchorMSFT;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class MSFTPerceptionAnchorInterop {
    public static final int XR_MSFT_perception_anchor_interop_SPEC_VERSION = 1;
    public static final String XR_MSFT_PERCEPTION_ANCHOR_INTEROP_EXTENSION_NAME = "XR_MSFT_perception_anchor_interop";

    protected MSFTPerceptionAnchorInterop() {
        throw new UnsupportedOperationException();
    }

    public static int nxrCreateSpatialAnchorFromPerceptionAnchorMSFT(XrSession session, long perceptionAnchor, long anchor) {
        long __functionAddress = session.getCapabilities().xrCreateSpatialAnchorFromPerceptionAnchorMSFT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(perceptionAnchor);
        }
        return JNI.callPPPI(session.address(), perceptionAnchor, anchor, __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrCreateSpatialAnchorFromPerceptionAnchorMSFT(XrSession session, @NativeType(value="IUnknown *") long perceptionAnchor, @NativeType(value="XrSpatialAnchorMSFT *") PointerBuffer anchor) {
        if (Checks.CHECKS) {
            Checks.check(anchor, 1);
        }
        return MSFTPerceptionAnchorInterop.nxrCreateSpatialAnchorFromPerceptionAnchorMSFT(session, perceptionAnchor, MemoryUtil.memAddress(anchor));
    }

    public static int nxrTryGetPerceptionAnchorFromSpatialAnchorMSFT(XrSession session, XrSpatialAnchorMSFT anchor, long perceptionAnchor) {
        long __functionAddress = session.getCapabilities().xrTryGetPerceptionAnchorFromSpatialAnchorMSFT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPI(session.address(), anchor.address(), perceptionAnchor, __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrTryGetPerceptionAnchorFromSpatialAnchorMSFT(XrSession session, XrSpatialAnchorMSFT anchor, @NativeType(value="IUnknown **") PointerBuffer perceptionAnchor) {
        if (Checks.CHECKS) {
            Checks.check(perceptionAnchor, 1);
        }
        return MSFTPerceptionAnchorInterop.nxrTryGetPerceptionAnchorFromSpatialAnchorMSFT(session, anchor, MemoryUtil.memAddress(perceptionAnchor));
    }
}

