/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.openxr.XrSceneMSFT;
import org.lwjgl.openxr.XrUuidMSFT;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class MSFTSceneMarker {
    public static final int XR_MSFT_scene_marker_SPEC_VERSION = 1;
    public static final String XR_MSFT_SCENE_MARKER_EXTENSION_NAME = "XR_MSFT_scene_marker";
    public static final int XR_SCENE_COMPUTE_FEATURE_MARKER_MSFT = 1000147000;
    public static final int XR_SCENE_COMPONENT_TYPE_MARKER_MSFT = 1000147000;
    public static final int XR_TYPE_SCENE_MARKERS_MSFT = 1000147000;
    public static final int XR_TYPE_SCENE_MARKER_TYPE_FILTER_MSFT = 1000147001;
    public static final int XR_TYPE_SCENE_MARKER_QR_CODES_MSFT = 1000147002;
    public static final int XR_SCENE_MARKER_DATA_NOT_STRING_MSFT = 1000147000;
    public static final int XR_SCENE_MARKER_TYPE_QR_CODE_MSFT = 1;
    public static final int XR_SCENE_MARKER_QR_CODE_SYMBOL_TYPE_QR_CODE_MSFT = 1;
    public static final int XR_SCENE_MARKER_QR_CODE_SYMBOL_TYPE_MICRO_QR_CODE_MSFT = 2;

    protected MSFTSceneMarker() {
        throw new UnsupportedOperationException();
    }

    public static int nxrGetSceneMarkerRawDataMSFT(XrSceneMSFT scene, long markerId, int bufferCapacityInput, long bufferCountOutput, long buffer) {
        long __functionAddress = scene.getCapabilities().xrGetSceneMarkerRawDataMSFT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPPI(scene.address(), markerId, bufferCapacityInput, bufferCountOutput, buffer, __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrGetSceneMarkerRawDataMSFT(XrSceneMSFT scene, @NativeType(value="XrUuidMSFT const *") XrUuidMSFT markerId, @NativeType(value="uint32_t *") IntBuffer bufferCountOutput, @NativeType(value="uint8_t *") @Nullable ByteBuffer buffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)bufferCountOutput, 1);
        }
        return MSFTSceneMarker.nxrGetSceneMarkerRawDataMSFT(scene, markerId.address(), Checks.remainingSafe(buffer), MemoryUtil.memAddress(bufferCountOutput), MemoryUtil.memAddressSafe(buffer));
    }

    public static int nxrGetSceneMarkerDecodedStringMSFT(XrSceneMSFT scene, long markerId, int bufferCapacityInput, long bufferCountOutput, long buffer) {
        long __functionAddress = scene.getCapabilities().xrGetSceneMarkerDecodedStringMSFT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPPI(scene.address(), markerId, bufferCapacityInput, bufferCountOutput, buffer, __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrGetSceneMarkerDecodedStringMSFT(XrSceneMSFT scene, @NativeType(value="XrUuidMSFT const *") XrUuidMSFT markerId, @NativeType(value="uint32_t *") IntBuffer bufferCountOutput, @NativeType(value="char *") @Nullable ByteBuffer buffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)bufferCountOutput, 1);
        }
        return MSFTSceneMarker.nxrGetSceneMarkerDecodedStringMSFT(scene, markerId.address(), Checks.remainingSafe(buffer), MemoryUtil.memAddress(bufferCountOutput), MemoryUtil.memAddressSafe(buffer));
    }
}

