/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.openxr.XrSceneDeserializeInfoMSFT;
import org.lwjgl.openxr.XrSceneMSFT;
import org.lwjgl.openxr.XrSceneObserverMSFT;
import org.lwjgl.openxr.XrSerializedSceneFragmentDataGetInfoMSFT;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class MSFTSceneUnderstandingSerialization {
    public static final int XR_MSFT_scene_understanding_serialization_SPEC_VERSION = 2;
    public static final String XR_MSFT_SCENE_UNDERSTANDING_SERIALIZATION_EXTENSION_NAME = "XR_MSFT_scene_understanding_serialization";
    public static final int XR_TYPE_SERIALIZED_SCENE_FRAGMENT_DATA_GET_INFO_MSFT = 1000098000;
    public static final int XR_TYPE_SCENE_DESERIALIZE_INFO_MSFT = 1000098001;
    public static final int XR_SCENE_COMPUTE_FEATURE_SERIALIZE_SCENE_MSFT = 1000098000;
    public static final int XR_SCENE_COMPONENT_TYPE_SERIALIZED_SCENE_FRAGMENT_MSFT = 1000098000;

    protected MSFTSceneUnderstandingSerialization() {
        throw new UnsupportedOperationException();
    }

    public static int nxrDeserializeSceneMSFT(XrSceneObserverMSFT sceneObserver, long deserializeInfo) {
        long __functionAddress = sceneObserver.getCapabilities().xrDeserializeSceneMSFT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPI(sceneObserver.address(), deserializeInfo, __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrDeserializeSceneMSFT(XrSceneObserverMSFT sceneObserver, @NativeType(value="XrSceneDeserializeInfoMSFT const *") XrSceneDeserializeInfoMSFT deserializeInfo) {
        return MSFTSceneUnderstandingSerialization.nxrDeserializeSceneMSFT(sceneObserver, deserializeInfo.address());
    }

    public static int nxrGetSerializedSceneFragmentDataMSFT(XrSceneMSFT scene, long getInfo, int countInput, long readOutput, long buffer) {
        long __functionAddress = scene.getCapabilities().xrGetSerializedSceneFragmentDataMSFT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPPI(scene.address(), getInfo, countInput, readOutput, buffer, __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrGetSerializedSceneFragmentDataMSFT(XrSceneMSFT scene, @NativeType(value="XrSerializedSceneFragmentDataGetInfoMSFT const *") XrSerializedSceneFragmentDataGetInfoMSFT getInfo, @NativeType(value="uint32_t *") IntBuffer readOutput, @NativeType(value="uint8_t *") @Nullable ByteBuffer buffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)readOutput, 1);
        }
        return MSFTSceneUnderstandingSerialization.nxrGetSerializedSceneFragmentDataMSFT(scene, getInfo.address(), Checks.remainingSafe(buffer), MemoryUtil.memAddress(readOutput), MemoryUtil.memAddressSafe(buffer));
    }
}

