/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.openxr.XrSession;
import org.lwjgl.openxr.XrSpatialAnchorFromPersistedAnchorCreateInfoMSFT;
import org.lwjgl.openxr.XrSpatialAnchorPersistenceInfoMSFT;
import org.lwjgl.openxr.XrSpatialAnchorPersistenceNameMSFT;
import org.lwjgl.openxr.XrSpatialAnchorStoreConnectionMSFT;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class MSFTSpatialAnchorPersistence {
    public static final int XR_MSFT_spatial_anchor_persistence_SPEC_VERSION = 2;
    public static final String XR_MSFT_SPATIAL_ANCHOR_PERSISTENCE_EXTENSION_NAME = "XR_MSFT_spatial_anchor_persistence";
    public static final int XR_OBJECT_TYPE_SPATIAL_ANCHOR_STORE_CONNECTION_MSFT = 1000142000;
    public static final int XR_TYPE_SPATIAL_ANCHOR_PERSISTENCE_INFO_MSFT = 1000142000;
    public static final int XR_TYPE_SPATIAL_ANCHOR_FROM_PERSISTED_ANCHOR_CREATE_INFO_MSFT = 1000142001;
    public static final int XR_ERROR_SPATIAL_ANCHOR_NAME_NOT_FOUND_MSFT = -1000142001;
    public static final int XR_ERROR_SPATIAL_ANCHOR_NAME_INVALID_MSFT = -1000142002;
    public static final int XR_MAX_SPATIAL_ANCHOR_NAME_SIZE_MSFT = 256;

    protected MSFTSpatialAnchorPersistence() {
        throw new UnsupportedOperationException();
    }

    public static int nxrCreateSpatialAnchorStoreConnectionMSFT(XrSession session, long spatialAnchorStore) {
        long __functionAddress = session.getCapabilities().xrCreateSpatialAnchorStoreConnectionMSFT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPI(session.address(), spatialAnchorStore, __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrCreateSpatialAnchorStoreConnectionMSFT(XrSession session, @NativeType(value="XrSpatialAnchorStoreConnectionMSFT *") PointerBuffer spatialAnchorStore) {
        if (Checks.CHECKS) {
            Checks.check(spatialAnchorStore, 1);
        }
        return MSFTSpatialAnchorPersistence.nxrCreateSpatialAnchorStoreConnectionMSFT(session, MemoryUtil.memAddress(spatialAnchorStore));
    }

    @NativeType(value="XrResult")
    public static int xrDestroySpatialAnchorStoreConnectionMSFT(XrSpatialAnchorStoreConnectionMSFT spatialAnchorStore) {
        long __functionAddress = spatialAnchorStore.getCapabilities().xrDestroySpatialAnchorStoreConnectionMSFT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(spatialAnchorStore.address(), __functionAddress);
    }

    public static int nxrPersistSpatialAnchorMSFT(XrSpatialAnchorStoreConnectionMSFT spatialAnchorStore, long spatialAnchorPersistenceInfo) {
        long __functionAddress = spatialAnchorStore.getCapabilities().xrPersistSpatialAnchorMSFT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            XrSpatialAnchorPersistenceInfoMSFT.validate(spatialAnchorPersistenceInfo);
        }
        return JNI.callPPI(spatialAnchorStore.address(), spatialAnchorPersistenceInfo, __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrPersistSpatialAnchorMSFT(XrSpatialAnchorStoreConnectionMSFT spatialAnchorStore, @NativeType(value="XrSpatialAnchorPersistenceInfoMSFT const *") XrSpatialAnchorPersistenceInfoMSFT spatialAnchorPersistenceInfo) {
        return MSFTSpatialAnchorPersistence.nxrPersistSpatialAnchorMSFT(spatialAnchorStore, spatialAnchorPersistenceInfo.address());
    }

    public static int nxrEnumeratePersistedSpatialAnchorNamesMSFT(XrSpatialAnchorStoreConnectionMSFT spatialAnchorStore, int spatialAnchorNameCapacityInput, long spatialAnchorNameCountOutput, long spatialAnchorNames) {
        long __functionAddress = spatialAnchorStore.getCapabilities().xrEnumeratePersistedSpatialAnchorNamesMSFT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPI(spatialAnchorStore.address(), spatialAnchorNameCapacityInput, spatialAnchorNameCountOutput, spatialAnchorNames, __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrEnumeratePersistedSpatialAnchorNamesMSFT(XrSpatialAnchorStoreConnectionMSFT spatialAnchorStore, @NativeType(value="uint32_t *") IntBuffer spatialAnchorNameCountOutput, @NativeType(value="XrSpatialAnchorPersistenceNameMSFT *") @Nullable XrSpatialAnchorPersistenceNameMSFT.Buffer spatialAnchorNames) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)spatialAnchorNameCountOutput, 1);
        }
        return MSFTSpatialAnchorPersistence.nxrEnumeratePersistedSpatialAnchorNamesMSFT(spatialAnchorStore, Checks.remainingSafe(spatialAnchorNames), MemoryUtil.memAddress(spatialAnchorNameCountOutput), MemoryUtil.memAddressSafe(spatialAnchorNames));
    }

    public static int nxrCreateSpatialAnchorFromPersistedNameMSFT(XrSession session, long spatialAnchorCreateInfo, long spatialAnchor) {
        long __functionAddress = session.getCapabilities().xrCreateSpatialAnchorFromPersistedNameMSFT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            XrSpatialAnchorFromPersistedAnchorCreateInfoMSFT.validate(spatialAnchorCreateInfo);
        }
        return JNI.callPPPI(session.address(), spatialAnchorCreateInfo, spatialAnchor, __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrCreateSpatialAnchorFromPersistedNameMSFT(XrSession session, @NativeType(value="XrSpatialAnchorFromPersistedAnchorCreateInfoMSFT const *") XrSpatialAnchorFromPersistedAnchorCreateInfoMSFT spatialAnchorCreateInfo, @NativeType(value="XrSpatialAnchorMSFT *") PointerBuffer spatialAnchor) {
        if (Checks.CHECKS) {
            Checks.check(spatialAnchor, 1);
        }
        return MSFTSpatialAnchorPersistence.nxrCreateSpatialAnchorFromPersistedNameMSFT(session, spatialAnchorCreateInfo.address(), MemoryUtil.memAddress(spatialAnchor));
    }

    public static int nxrUnpersistSpatialAnchorMSFT(XrSpatialAnchorStoreConnectionMSFT spatialAnchorStore, long spatialAnchorPersistenceName) {
        long __functionAddress = spatialAnchorStore.getCapabilities().xrUnpersistSpatialAnchorMSFT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPI(spatialAnchorStore.address(), spatialAnchorPersistenceName, __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrUnpersistSpatialAnchorMSFT(XrSpatialAnchorStoreConnectionMSFT spatialAnchorStore, @NativeType(value="XrSpatialAnchorPersistenceNameMSFT const *") XrSpatialAnchorPersistenceNameMSFT spatialAnchorPersistenceName) {
        return MSFTSpatialAnchorPersistence.nxrUnpersistSpatialAnchorMSFT(spatialAnchorStore, spatialAnchorPersistenceName.address());
    }

    @NativeType(value="XrResult")
    public static int xrClearSpatialAnchorStoreMSFT(XrSpatialAnchorStoreConnectionMSFT spatialAnchorStore) {
        long __functionAddress = spatialAnchorStore.getCapabilities().xrClearSpatialAnchorStoreMSFT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(spatialAnchorStore.address(), __functionAddress);
    }
}

