/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import org.lwjgl.PointerBuffer;
import org.lwjgl.openxr.XrExtent2Df;
import org.lwjgl.openxr.XrMarkerSpaceCreateInfoVARJO;
import org.lwjgl.openxr.XrSession;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class VARJOMarkerTracking {
    public static final int XR_VARJO_marker_tracking_SPEC_VERSION = 1;
    public static final String XR_VARJO_MARKER_TRACKING_EXTENSION_NAME = "XR_VARJO_marker_tracking";
    public static final int XR_TYPE_SYSTEM_MARKER_TRACKING_PROPERTIES_VARJO = 1000124000;
    public static final int XR_TYPE_EVENT_DATA_MARKER_TRACKING_UPDATE_VARJO = 1000124001;
    public static final int XR_TYPE_MARKER_SPACE_CREATE_INFO_VARJO = 1000124002;
    public static final int XR_ERROR_MARKER_NOT_TRACKED_VARJO = -1000124000;
    public static final int XR_ERROR_MARKER_ID_INVALID_VARJO = -1000124001;

    protected VARJOMarkerTracking() {
        throw new UnsupportedOperationException();
    }

    @NativeType(value="XrResult")
    public static int xrSetMarkerTrackingVARJO(XrSession session, @NativeType(value="XrBool32") boolean enabled) {
        long __functionAddress = session.getCapabilities().xrSetMarkerTrackingVARJO;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(session.address(), enabled ? 1 : 0, __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrSetMarkerTrackingTimeoutVARJO(XrSession session, @NativeType(value="uint64_t") long markerId, @NativeType(value="XrDuration") long timeout) {
        long __functionAddress = session.getCapabilities().xrSetMarkerTrackingTimeoutVARJO;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPJJI(session.address(), markerId, timeout, __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrSetMarkerTrackingPredictionVARJO(XrSession session, @NativeType(value="uint64_t") long markerId, @NativeType(value="XrBool32") boolean enable) {
        long __functionAddress = session.getCapabilities().xrSetMarkerTrackingPredictionVARJO;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPJI(session.address(), markerId, enable ? 1 : 0, __functionAddress);
    }

    public static int nxrGetMarkerSizeVARJO(XrSession session, long markerId, long size) {
        long __functionAddress = session.getCapabilities().xrGetMarkerSizeVARJO;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPJPI(session.address(), markerId, size, __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrGetMarkerSizeVARJO(XrSession session, @NativeType(value="uint64_t") long markerId, @NativeType(value="XrExtent2Df *") XrExtent2Df size) {
        return VARJOMarkerTracking.nxrGetMarkerSizeVARJO(session, markerId, size.address());
    }

    public static int nxrCreateMarkerSpaceVARJO(XrSession session, long createInfo, long space) {
        long __functionAddress = session.getCapabilities().xrCreateMarkerSpaceVARJO;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPI(session.address(), createInfo, space, __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrCreateMarkerSpaceVARJO(XrSession session, @NativeType(value="XrMarkerSpaceCreateInfoVARJO const *") XrMarkerSpaceCreateInfoVARJO createInfo, @NativeType(value="XrSpace *") PointerBuffer space) {
        if (Checks.CHECKS) {
            Checks.check(space, 1);
        }
        return VARJOMarkerTracking.nxrCreateMarkerSpaceVARJO(session, createInfo.address(), MemoryUtil.memAddress(space));
    }
}

