/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrActionCreateInfo
extends Struct<XrActionCreateInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int ACTIONNAME;
    public static final int ACTIONTYPE;
    public static final int COUNTSUBACTIONPATHS;
    public static final int SUBACTIONPATHS;
    public static final int LOCALIZEDACTIONNAME;

    protected XrActionCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrActionCreateInfo create(long address, @Nullable ByteBuffer container) {
        return new XrActionCreateInfo(address, container);
    }

    public XrActionCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrActionCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrActionCreateInfo.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrActionCreateInfo.nnext(this.address());
    }

    @NativeType(value="char[XR_MAX_ACTION_NAME_SIZE]")
    public ByteBuffer actionName() {
        return XrActionCreateInfo.nactionName(this.address());
    }

    @NativeType(value="char[XR_MAX_ACTION_NAME_SIZE]")
    public String actionNameString() {
        return XrActionCreateInfo.nactionNameString(this.address());
    }

    @NativeType(value="XrActionType")
    public int actionType() {
        return XrActionCreateInfo.nactionType(this.address());
    }

    @NativeType(value="uint32_t")
    public int countSubactionPaths() {
        return XrActionCreateInfo.ncountSubactionPaths(this.address());
    }

    @NativeType(value="XrPath const *")
    public @Nullable LongBuffer subactionPaths() {
        return XrActionCreateInfo.nsubactionPaths(this.address());
    }

    @NativeType(value="char[XR_MAX_LOCALIZED_ACTION_NAME_SIZE]")
    public ByteBuffer localizedActionName() {
        return XrActionCreateInfo.nlocalizedActionName(this.address());
    }

    @NativeType(value="char[XR_MAX_LOCALIZED_ACTION_NAME_SIZE]")
    public String localizedActionNameString() {
        return XrActionCreateInfo.nlocalizedActionNameString(this.address());
    }

    public XrActionCreateInfo type(@NativeType(value="XrStructureType") int value) {
        XrActionCreateInfo.ntype(this.address(), value);
        return this;
    }

    public XrActionCreateInfo type$Default() {
        return this.type(29);
    }

    public XrActionCreateInfo next(@NativeType(value="void const *") long value) {
        XrActionCreateInfo.nnext(this.address(), value);
        return this;
    }

    public XrActionCreateInfo actionName(@NativeType(value="char[XR_MAX_ACTION_NAME_SIZE]") ByteBuffer value) {
        XrActionCreateInfo.nactionName(this.address(), value);
        return this;
    }

    public XrActionCreateInfo actionType(@NativeType(value="XrActionType") int value) {
        XrActionCreateInfo.nactionType(this.address(), value);
        return this;
    }

    public XrActionCreateInfo countSubactionPaths(@NativeType(value="uint32_t") int value) {
        XrActionCreateInfo.ncountSubactionPaths(this.address(), value);
        return this;
    }

    public XrActionCreateInfo subactionPaths(@NativeType(value="XrPath const *") @Nullable LongBuffer value) {
        XrActionCreateInfo.nsubactionPaths(this.address(), value);
        return this;
    }

    public XrActionCreateInfo localizedActionName(@NativeType(value="char[XR_MAX_LOCALIZED_ACTION_NAME_SIZE]") ByteBuffer value) {
        XrActionCreateInfo.nlocalizedActionName(this.address(), value);
        return this;
    }

    public XrActionCreateInfo set(int type, long next, ByteBuffer actionName, int actionType, int countSubactionPaths, @Nullable LongBuffer subactionPaths, ByteBuffer localizedActionName) {
        this.type(type);
        this.next(next);
        this.actionName(actionName);
        this.actionType(actionType);
        this.countSubactionPaths(countSubactionPaths);
        this.subactionPaths(subactionPaths);
        this.localizedActionName(localizedActionName);
        return this;
    }

    public XrActionCreateInfo set(XrActionCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrActionCreateInfo malloc() {
        return new XrActionCreateInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrActionCreateInfo calloc() {
        return new XrActionCreateInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrActionCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrActionCreateInfo(MemoryUtil.memAddress(container), container);
    }

    public static XrActionCreateInfo create(long address) {
        return new XrActionCreateInfo(address, null);
    }

    public static @Nullable XrActionCreateInfo createSafe(long address) {
        return address == 0L ? null : new XrActionCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrActionCreateInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrActionCreateInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrActionCreateInfo malloc(MemoryStack stack) {
        return new XrActionCreateInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrActionCreateInfo calloc(MemoryStack stack) {
        return new XrActionCreateInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static ByteBuffer nactionName(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)ACTIONNAME, 64);
    }

    public static String nactionNameString(long struct) {
        return MemoryUtil.memUTF8(struct + (long)ACTIONNAME);
    }

    public static int nactionType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ACTIONTYPE);
    }

    public static int ncountSubactionPaths(long struct) {
        return MemoryUtil.memGetInt(struct + (long)COUNTSUBACTIONPATHS);
    }

    public static @Nullable LongBuffer nsubactionPaths(long struct) {
        return MemoryUtil.memLongBufferSafe(MemoryUtil.memGetAddress(struct + (long)SUBACTIONPATHS), XrActionCreateInfo.ncountSubactionPaths(struct));
    }

    public static ByteBuffer nlocalizedActionName(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)LOCALIZEDACTIONNAME, 128);
    }

    public static String nlocalizedActionNameString(long struct) {
        return MemoryUtil.memUTF8(struct + (long)LOCALIZEDACTIONNAME);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nactionName(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value);
            Checks.checkGT(value, 64);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)ACTIONNAME, value.remaining());
    }

    public static void nactionType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ACTIONTYPE, value);
    }

    public static void ncountSubactionPaths(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)COUNTSUBACTIONPATHS, value);
    }

    public static void nsubactionPaths(long struct, @Nullable LongBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)SUBACTIONPATHS, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            XrActionCreateInfo.ncountSubactionPaths(struct, value.remaining());
        }
    }

    public static void nlocalizedActionName(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value);
            Checks.checkGT(value, 128);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)LOCALIZEDACTIONNAME, value.remaining());
    }

    static {
        Struct.Layout layout = XrActionCreateInfo.__struct(XrActionCreateInfo.__member(4), XrActionCreateInfo.__member(POINTER_SIZE), XrActionCreateInfo.__array(1, 64), XrActionCreateInfo.__member(4), XrActionCreateInfo.__member(4), XrActionCreateInfo.__member(POINTER_SIZE), XrActionCreateInfo.__array(1, 128));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        ACTIONNAME = layout.offsetof(2);
        ACTIONTYPE = layout.offsetof(3);
        COUNTSUBACTIONPATHS = layout.offsetof(4);
        SUBACTIONPATHS = layout.offsetof(5);
        LOCALIZEDACTIONNAME = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<XrActionCreateInfo, Buffer>
    implements NativeResource {
        private static final XrActionCreateInfo ELEMENT_FACTORY = XrActionCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrActionCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrActionCreateInfo.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrActionCreateInfo.nnext(this.address());
        }

        @NativeType(value="char[XR_MAX_ACTION_NAME_SIZE]")
        public ByteBuffer actionName() {
            return XrActionCreateInfo.nactionName(this.address());
        }

        @NativeType(value="char[XR_MAX_ACTION_NAME_SIZE]")
        public String actionNameString() {
            return XrActionCreateInfo.nactionNameString(this.address());
        }

        @NativeType(value="XrActionType")
        public int actionType() {
            return XrActionCreateInfo.nactionType(this.address());
        }

        @NativeType(value="uint32_t")
        public int countSubactionPaths() {
            return XrActionCreateInfo.ncountSubactionPaths(this.address());
        }

        @NativeType(value="XrPath const *")
        public @Nullable LongBuffer subactionPaths() {
            return XrActionCreateInfo.nsubactionPaths(this.address());
        }

        @NativeType(value="char[XR_MAX_LOCALIZED_ACTION_NAME_SIZE]")
        public ByteBuffer localizedActionName() {
            return XrActionCreateInfo.nlocalizedActionName(this.address());
        }

        @NativeType(value="char[XR_MAX_LOCALIZED_ACTION_NAME_SIZE]")
        public String localizedActionNameString() {
            return XrActionCreateInfo.nlocalizedActionNameString(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrActionCreateInfo.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(29);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrActionCreateInfo.nnext(this.address(), value);
            return this;
        }

        public Buffer actionName(@NativeType(value="char[XR_MAX_ACTION_NAME_SIZE]") ByteBuffer value) {
            XrActionCreateInfo.nactionName(this.address(), value);
            return this;
        }

        public Buffer actionType(@NativeType(value="XrActionType") int value) {
            XrActionCreateInfo.nactionType(this.address(), value);
            return this;
        }

        public Buffer countSubactionPaths(@NativeType(value="uint32_t") int value) {
            XrActionCreateInfo.ncountSubactionPaths(this.address(), value);
            return this;
        }

        public Buffer subactionPaths(@NativeType(value="XrPath const *") @Nullable LongBuffer value) {
            XrActionCreateInfo.nsubactionPaths(this.address(), value);
            return this;
        }

        public Buffer localizedActionName(@NativeType(value="char[XR_MAX_LOCALIZED_ACTION_NAME_SIZE]") ByteBuffer value) {
            XrActionCreateInfo.nlocalizedActionName(this.address(), value);
            return this;
        }
    }
}

