/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrActionStateBoolean
extends Struct<XrActionStateBoolean>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int CURRENTSTATE;
    public static final int CHANGEDSINCELASTSYNC;
    public static final int LASTCHANGETIME;
    public static final int ISACTIVE;

    protected XrActionStateBoolean(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrActionStateBoolean create(long address, @Nullable ByteBuffer container) {
        return new XrActionStateBoolean(address, container);
    }

    public XrActionStateBoolean(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrActionStateBoolean.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrActionStateBoolean.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrActionStateBoolean.nnext(this.address());
    }

    @NativeType(value="XrBool32")
    public boolean currentState() {
        return XrActionStateBoolean.ncurrentState(this.address()) != 0;
    }

    @NativeType(value="XrBool32")
    public boolean changedSinceLastSync() {
        return XrActionStateBoolean.nchangedSinceLastSync(this.address()) != 0;
    }

    @NativeType(value="XrTime")
    public long lastChangeTime() {
        return XrActionStateBoolean.nlastChangeTime(this.address());
    }

    @NativeType(value="XrBool32")
    public boolean isActive() {
        return XrActionStateBoolean.nisActive(this.address()) != 0;
    }

    public XrActionStateBoolean type(@NativeType(value="XrStructureType") int value) {
        XrActionStateBoolean.ntype(this.address(), value);
        return this;
    }

    public XrActionStateBoolean type$Default() {
        return this.type(23);
    }

    public XrActionStateBoolean next(@NativeType(value="void *") long value) {
        XrActionStateBoolean.nnext(this.address(), value);
        return this;
    }

    public XrActionStateBoolean currentState(@NativeType(value="XrBool32") boolean value) {
        XrActionStateBoolean.ncurrentState(this.address(), value ? 1 : 0);
        return this;
    }

    public XrActionStateBoolean changedSinceLastSync(@NativeType(value="XrBool32") boolean value) {
        XrActionStateBoolean.nchangedSinceLastSync(this.address(), value ? 1 : 0);
        return this;
    }

    public XrActionStateBoolean lastChangeTime(@NativeType(value="XrTime") long value) {
        XrActionStateBoolean.nlastChangeTime(this.address(), value);
        return this;
    }

    public XrActionStateBoolean isActive(@NativeType(value="XrBool32") boolean value) {
        XrActionStateBoolean.nisActive(this.address(), value ? 1 : 0);
        return this;
    }

    public XrActionStateBoolean set(int type, long next, boolean currentState, boolean changedSinceLastSync, long lastChangeTime, boolean isActive) {
        this.type(type);
        this.next(next);
        this.currentState(currentState);
        this.changedSinceLastSync(changedSinceLastSync);
        this.lastChangeTime(lastChangeTime);
        this.isActive(isActive);
        return this;
    }

    public XrActionStateBoolean set(XrActionStateBoolean src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrActionStateBoolean malloc() {
        return new XrActionStateBoolean(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrActionStateBoolean calloc() {
        return new XrActionStateBoolean(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrActionStateBoolean create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrActionStateBoolean(MemoryUtil.memAddress(container), container);
    }

    public static XrActionStateBoolean create(long address) {
        return new XrActionStateBoolean(address, null);
    }

    public static @Nullable XrActionStateBoolean createSafe(long address) {
        return address == 0L ? null : new XrActionStateBoolean(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrActionStateBoolean.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrActionStateBoolean.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrActionStateBoolean malloc(MemoryStack stack) {
        return new XrActionStateBoolean(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrActionStateBoolean calloc(MemoryStack stack) {
        return new XrActionStateBoolean(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int ncurrentState(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CURRENTSTATE);
    }

    public static int nchangedSinceLastSync(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CHANGEDSINCELASTSYNC);
    }

    public static long nlastChangeTime(long struct) {
        return MemoryUtil.memGetLong(struct + (long)LASTCHANGETIME);
    }

    public static int nisActive(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ISACTIVE);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void ncurrentState(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)CURRENTSTATE, value);
    }

    public static void nchangedSinceLastSync(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)CHANGEDSINCELASTSYNC, value);
    }

    public static void nlastChangeTime(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)LASTCHANGETIME, value);
    }

    public static void nisActive(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ISACTIVE, value);
    }

    static {
        Struct.Layout layout = XrActionStateBoolean.__struct(XrActionStateBoolean.__member(4), XrActionStateBoolean.__member(POINTER_SIZE), XrActionStateBoolean.__member(4), XrActionStateBoolean.__member(4), XrActionStateBoolean.__member(8), XrActionStateBoolean.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        CURRENTSTATE = layout.offsetof(2);
        CHANGEDSINCELASTSYNC = layout.offsetof(3);
        LASTCHANGETIME = layout.offsetof(4);
        ISACTIVE = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<XrActionStateBoolean, Buffer>
    implements NativeResource {
        private static final XrActionStateBoolean ELEMENT_FACTORY = XrActionStateBoolean.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrActionStateBoolean getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrActionStateBoolean.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrActionStateBoolean.nnext(this.address());
        }

        @NativeType(value="XrBool32")
        public boolean currentState() {
            return XrActionStateBoolean.ncurrentState(this.address()) != 0;
        }

        @NativeType(value="XrBool32")
        public boolean changedSinceLastSync() {
            return XrActionStateBoolean.nchangedSinceLastSync(this.address()) != 0;
        }

        @NativeType(value="XrTime")
        public long lastChangeTime() {
            return XrActionStateBoolean.nlastChangeTime(this.address());
        }

        @NativeType(value="XrBool32")
        public boolean isActive() {
            return XrActionStateBoolean.nisActive(this.address()) != 0;
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrActionStateBoolean.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(23);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrActionStateBoolean.nnext(this.address(), value);
            return this;
        }

        public Buffer currentState(@NativeType(value="XrBool32") boolean value) {
            XrActionStateBoolean.ncurrentState(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer changedSinceLastSync(@NativeType(value="XrBool32") boolean value) {
            XrActionStateBoolean.nchangedSinceLastSync(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer lastChangeTime(@NativeType(value="XrTime") long value) {
            XrActionStateBoolean.nlastChangeTime(this.address(), value);
            return this;
        }

        public Buffer isActive(@NativeType(value="XrBool32") boolean value) {
            XrActionStateBoolean.nisActive(this.address(), value ? 1 : 0);
            return this;
        }
    }
}

