/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrAction;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrActionSuggestedBinding
extends Struct<XrActionSuggestedBinding>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ACTION;
    public static final int BINDING;

    protected XrActionSuggestedBinding(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrActionSuggestedBinding create(long address, @Nullable ByteBuffer container) {
        return new XrActionSuggestedBinding(address, container);
    }

    public XrActionSuggestedBinding(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrActionSuggestedBinding.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrAction")
    public long action() {
        return XrActionSuggestedBinding.naction(this.address());
    }

    @NativeType(value="XrPath")
    public long binding() {
        return XrActionSuggestedBinding.nbinding(this.address());
    }

    public XrActionSuggestedBinding action(XrAction value) {
        XrActionSuggestedBinding.naction(this.address(), value);
        return this;
    }

    public XrActionSuggestedBinding binding(@NativeType(value="XrPath") long value) {
        XrActionSuggestedBinding.nbinding(this.address(), value);
        return this;
    }

    public XrActionSuggestedBinding set(XrAction action, long binding) {
        this.action(action);
        this.binding(binding);
        return this;
    }

    public XrActionSuggestedBinding set(XrActionSuggestedBinding src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrActionSuggestedBinding malloc() {
        return new XrActionSuggestedBinding(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrActionSuggestedBinding calloc() {
        return new XrActionSuggestedBinding(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrActionSuggestedBinding create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrActionSuggestedBinding(MemoryUtil.memAddress(container), container);
    }

    public static XrActionSuggestedBinding create(long address) {
        return new XrActionSuggestedBinding(address, null);
    }

    public static @Nullable XrActionSuggestedBinding createSafe(long address) {
        return address == 0L ? null : new XrActionSuggestedBinding(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrActionSuggestedBinding.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrActionSuggestedBinding.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrActionSuggestedBinding malloc(MemoryStack stack) {
        return new XrActionSuggestedBinding(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrActionSuggestedBinding calloc(MemoryStack stack) {
        return new XrActionSuggestedBinding(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long naction(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)ACTION);
    }

    public static long nbinding(long struct) {
        return MemoryUtil.memGetLong(struct + (long)BINDING);
    }

    public static void naction(long struct, XrAction value) {
        MemoryUtil.memPutAddress(struct + (long)ACTION, value.address());
    }

    public static void nbinding(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)BINDING, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)ACTION));
    }

    static {
        Struct.Layout layout = XrActionSuggestedBinding.__struct(XrActionSuggestedBinding.__member(POINTER_SIZE), XrActionSuggestedBinding.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ACTION = layout.offsetof(0);
        BINDING = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrActionSuggestedBinding, Buffer>
    implements NativeResource {
        private static final XrActionSuggestedBinding ELEMENT_FACTORY = XrActionSuggestedBinding.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrActionSuggestedBinding getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrAction")
        public long action() {
            return XrActionSuggestedBinding.naction(this.address());
        }

        @NativeType(value="XrPath")
        public long binding() {
            return XrActionSuggestedBinding.nbinding(this.address());
        }

        public Buffer action(XrAction value) {
            XrActionSuggestedBinding.naction(this.address(), value);
            return this;
        }

        public Buffer binding(@NativeType(value="XrPath") long value) {
            XrActionSuggestedBinding.nbinding(this.address(), value);
            return this;
        }
    }
}

