/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrApiLayerProperties
extends Struct<XrApiLayerProperties>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int LAYERNAME;
    public static final int SPECVERSION;
    public static final int LAYERVERSION;
    public static final int DESCRIPTION;

    protected XrApiLayerProperties(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrApiLayerProperties create(long address, @Nullable ByteBuffer container) {
        return new XrApiLayerProperties(address, container);
    }

    public XrApiLayerProperties(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrApiLayerProperties.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrApiLayerProperties.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrApiLayerProperties.nnext(this.address());
    }

    @NativeType(value="char[XR_MAX_API_LAYER_NAME_SIZE]")
    public ByteBuffer layerName() {
        return XrApiLayerProperties.nlayerName(this.address());
    }

    @NativeType(value="char[XR_MAX_API_LAYER_NAME_SIZE]")
    public String layerNameString() {
        return XrApiLayerProperties.nlayerNameString(this.address());
    }

    @NativeType(value="XrVersion")
    public long specVersion() {
        return XrApiLayerProperties.nspecVersion(this.address());
    }

    @NativeType(value="uint32_t")
    public int layerVersion() {
        return XrApiLayerProperties.nlayerVersion(this.address());
    }

    @NativeType(value="char[XR_MAX_API_LAYER_DESCRIPTION_SIZE]")
    public ByteBuffer description() {
        return XrApiLayerProperties.ndescription(this.address());
    }

    @NativeType(value="char[XR_MAX_API_LAYER_DESCRIPTION_SIZE]")
    public String descriptionString() {
        return XrApiLayerProperties.ndescriptionString(this.address());
    }

    public XrApiLayerProperties type(@NativeType(value="XrStructureType") int value) {
        XrApiLayerProperties.ntype(this.address(), value);
        return this;
    }

    public XrApiLayerProperties type$Default() {
        return this.type(1);
    }

    public XrApiLayerProperties next(@NativeType(value="void *") long value) {
        XrApiLayerProperties.nnext(this.address(), value);
        return this;
    }

    public XrApiLayerProperties set(int type, long next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrApiLayerProperties set(XrApiLayerProperties src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrApiLayerProperties malloc() {
        return new XrApiLayerProperties(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrApiLayerProperties calloc() {
        return new XrApiLayerProperties(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrApiLayerProperties create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrApiLayerProperties(MemoryUtil.memAddress(container), container);
    }

    public static XrApiLayerProperties create(long address) {
        return new XrApiLayerProperties(address, null);
    }

    public static @Nullable XrApiLayerProperties createSafe(long address) {
        return address == 0L ? null : new XrApiLayerProperties(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrApiLayerProperties.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrApiLayerProperties.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrApiLayerProperties malloc(MemoryStack stack) {
        return new XrApiLayerProperties(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrApiLayerProperties calloc(MemoryStack stack) {
        return new XrApiLayerProperties(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static ByteBuffer nlayerName(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)LAYERNAME, 256);
    }

    public static String nlayerNameString(long struct) {
        return MemoryUtil.memUTF8(struct + (long)LAYERNAME);
    }

    public static long nspecVersion(long struct) {
        return MemoryUtil.memGetLong(struct + (long)SPECVERSION);
    }

    public static int nlayerVersion(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LAYERVERSION);
    }

    public static ByteBuffer ndescription(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)DESCRIPTION, 256);
    }

    public static String ndescriptionString(long struct) {
        return MemoryUtil.memUTF8(struct + (long)DESCRIPTION);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    static {
        Struct.Layout layout = XrApiLayerProperties.__struct(XrApiLayerProperties.__member(4), XrApiLayerProperties.__member(POINTER_SIZE), XrApiLayerProperties.__array(1, 256), XrApiLayerProperties.__member(8), XrApiLayerProperties.__member(4), XrApiLayerProperties.__array(1, 256));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        LAYERNAME = layout.offsetof(2);
        SPECVERSION = layout.offsetof(3);
        LAYERVERSION = layout.offsetof(4);
        DESCRIPTION = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<XrApiLayerProperties, Buffer>
    implements NativeResource {
        private static final XrApiLayerProperties ELEMENT_FACTORY = XrApiLayerProperties.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrApiLayerProperties getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrApiLayerProperties.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrApiLayerProperties.nnext(this.address());
        }

        @NativeType(value="char[XR_MAX_API_LAYER_NAME_SIZE]")
        public ByteBuffer layerName() {
            return XrApiLayerProperties.nlayerName(this.address());
        }

        @NativeType(value="char[XR_MAX_API_LAYER_NAME_SIZE]")
        public String layerNameString() {
            return XrApiLayerProperties.nlayerNameString(this.address());
        }

        @NativeType(value="XrVersion")
        public long specVersion() {
            return XrApiLayerProperties.nspecVersion(this.address());
        }

        @NativeType(value="uint32_t")
        public int layerVersion() {
            return XrApiLayerProperties.nlayerVersion(this.address());
        }

        @NativeType(value="char[XR_MAX_API_LAYER_DESCRIPTION_SIZE]")
        public ByteBuffer description() {
            return XrApiLayerProperties.ndescription(this.address());
        }

        @NativeType(value="char[XR_MAX_API_LAYER_DESCRIPTION_SIZE]")
        public String descriptionString() {
            return XrApiLayerProperties.ndescriptionString(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrApiLayerProperties.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrApiLayerProperties.nnext(this.address(), value);
            return this;
        }
    }
}

