/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrInteractionProfileAnalogThresholdVALVE;
import org.lwjgl.openxr.XrInteractionProfileDpadBindingEXT;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrBindingModificationBaseHeaderKHR
extends Struct<XrBindingModificationBaseHeaderKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;

    protected XrBindingModificationBaseHeaderKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrBindingModificationBaseHeaderKHR create(long address, @Nullable ByteBuffer container) {
        return new XrBindingModificationBaseHeaderKHR(address, container);
    }

    public XrBindingModificationBaseHeaderKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrBindingModificationBaseHeaderKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrBindingModificationBaseHeaderKHR.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrBindingModificationBaseHeaderKHR.nnext(this.address());
    }

    public XrBindingModificationBaseHeaderKHR type(@NativeType(value="XrStructureType") int value) {
        XrBindingModificationBaseHeaderKHR.ntype(this.address(), value);
        return this;
    }

    public XrBindingModificationBaseHeaderKHR next(@NativeType(value="void const *") long value) {
        XrBindingModificationBaseHeaderKHR.nnext(this.address(), value);
        return this;
    }

    public XrBindingModificationBaseHeaderKHR set(int type, long next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrBindingModificationBaseHeaderKHR set(XrBindingModificationBaseHeaderKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrBindingModificationBaseHeaderKHR malloc() {
        return new XrBindingModificationBaseHeaderKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrBindingModificationBaseHeaderKHR calloc() {
        return new XrBindingModificationBaseHeaderKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrBindingModificationBaseHeaderKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrBindingModificationBaseHeaderKHR(MemoryUtil.memAddress(container), container);
    }

    public static XrBindingModificationBaseHeaderKHR create(long address) {
        return new XrBindingModificationBaseHeaderKHR(address, null);
    }

    public static @Nullable XrBindingModificationBaseHeaderKHR createSafe(long address) {
        return address == 0L ? null : new XrBindingModificationBaseHeaderKHR(address, null);
    }

    public static XrBindingModificationBaseHeaderKHR create(XrInteractionProfileDpadBindingEXT value) {
        return new XrBindingModificationBaseHeaderKHR(value.address(), XrBindingModificationBaseHeaderKHR.__getContainer(value));
    }

    public static XrBindingModificationBaseHeaderKHR create(XrInteractionProfileAnalogThresholdVALVE value) {
        return new XrBindingModificationBaseHeaderKHR(value.address(), XrBindingModificationBaseHeaderKHR.__getContainer(value));
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrBindingModificationBaseHeaderKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrBindingModificationBaseHeaderKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static Buffer create(XrInteractionProfileDpadBindingEXT.Buffer value) {
        return new Buffer(value.address(), XrBindingModificationBaseHeaderKHR.__getContainer(value), -1, 0, value.remaining(), value.remaining());
    }

    public static Buffer create(XrInteractionProfileAnalogThresholdVALVE.Buffer value) {
        return new Buffer(value.address(), XrBindingModificationBaseHeaderKHR.__getContainer(value), -1, 0, value.remaining(), value.remaining());
    }

    public static XrBindingModificationBaseHeaderKHR malloc(MemoryStack stack) {
        return new XrBindingModificationBaseHeaderKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrBindingModificationBaseHeaderKHR calloc(MemoryStack stack) {
        return new XrBindingModificationBaseHeaderKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    static {
        Struct.Layout layout = XrBindingModificationBaseHeaderKHR.__struct(XrBindingModificationBaseHeaderKHR.__member(4), XrBindingModificationBaseHeaderKHR.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrBindingModificationBaseHeaderKHR, Buffer>
    implements NativeResource {
        private static final XrBindingModificationBaseHeaderKHR ELEMENT_FACTORY = XrBindingModificationBaseHeaderKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrBindingModificationBaseHeaderKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrBindingModificationBaseHeaderKHR.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrBindingModificationBaseHeaderKHR.nnext(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrBindingModificationBaseHeaderKHR.ntype(this.address(), value);
            return this;
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrBindingModificationBaseHeaderKHR.nnext(this.address(), value);
            return this;
        }
    }
}

