/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrBindingModificationsKHR
extends Struct<XrBindingModificationsKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int BINDINGMODIFICATIONCOUNT;
    public static final int BINDINGMODIFICATIONS;

    protected XrBindingModificationsKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrBindingModificationsKHR create(long address, @Nullable ByteBuffer container) {
        return new XrBindingModificationsKHR(address, container);
    }

    public XrBindingModificationsKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrBindingModificationsKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrBindingModificationsKHR.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrBindingModificationsKHR.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int bindingModificationCount() {
        return XrBindingModificationsKHR.nbindingModificationCount(this.address());
    }

    @NativeType(value="XrBindingModificationBaseHeaderKHR const * const *")
    public @Nullable PointerBuffer bindingModifications() {
        return XrBindingModificationsKHR.nbindingModifications(this.address());
    }

    public XrBindingModificationsKHR type(@NativeType(value="XrStructureType") int value) {
        XrBindingModificationsKHR.ntype(this.address(), value);
        return this;
    }

    public XrBindingModificationsKHR type$Default() {
        return this.type(1000120000);
    }

    public XrBindingModificationsKHR next(@NativeType(value="void const *") long value) {
        XrBindingModificationsKHR.nnext(this.address(), value);
        return this;
    }

    public XrBindingModificationsKHR bindingModificationCount(@NativeType(value="uint32_t") int value) {
        XrBindingModificationsKHR.nbindingModificationCount(this.address(), value);
        return this;
    }

    public XrBindingModificationsKHR bindingModifications(@NativeType(value="XrBindingModificationBaseHeaderKHR const * const *") @Nullable PointerBuffer value) {
        XrBindingModificationsKHR.nbindingModifications(this.address(), value);
        return this;
    }

    public XrBindingModificationsKHR set(int type, long next, int bindingModificationCount, @Nullable PointerBuffer bindingModifications) {
        this.type(type);
        this.next(next);
        this.bindingModificationCount(bindingModificationCount);
        this.bindingModifications(bindingModifications);
        return this;
    }

    public XrBindingModificationsKHR set(XrBindingModificationsKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrBindingModificationsKHR malloc() {
        return new XrBindingModificationsKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrBindingModificationsKHR calloc() {
        return new XrBindingModificationsKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrBindingModificationsKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrBindingModificationsKHR(MemoryUtil.memAddress(container), container);
    }

    public static XrBindingModificationsKHR create(long address) {
        return new XrBindingModificationsKHR(address, null);
    }

    public static @Nullable XrBindingModificationsKHR createSafe(long address) {
        return address == 0L ? null : new XrBindingModificationsKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrBindingModificationsKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrBindingModificationsKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrBindingModificationsKHR malloc(MemoryStack stack) {
        return new XrBindingModificationsKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrBindingModificationsKHR calloc(MemoryStack stack) {
        return new XrBindingModificationsKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nbindingModificationCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BINDINGMODIFICATIONCOUNT);
    }

    public static @Nullable PointerBuffer nbindingModifications(long struct) {
        return MemoryUtil.memPointerBufferSafe(MemoryUtil.memGetAddress(struct + (long)BINDINGMODIFICATIONS), XrBindingModificationsKHR.nbindingModificationCount(struct));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nbindingModificationCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BINDINGMODIFICATIONCOUNT, value);
    }

    public static void nbindingModifications(long struct, @Nullable PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)BINDINGMODIFICATIONS, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            XrBindingModificationsKHR.nbindingModificationCount(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = XrBindingModificationsKHR.__struct(XrBindingModificationsKHR.__member(4), XrBindingModificationsKHR.__member(POINTER_SIZE), XrBindingModificationsKHR.__member(4), XrBindingModificationsKHR.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        BINDINGMODIFICATIONCOUNT = layout.offsetof(2);
        BINDINGMODIFICATIONS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrBindingModificationsKHR, Buffer>
    implements NativeResource {
        private static final XrBindingModificationsKHR ELEMENT_FACTORY = XrBindingModificationsKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrBindingModificationsKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrBindingModificationsKHR.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrBindingModificationsKHR.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int bindingModificationCount() {
            return XrBindingModificationsKHR.nbindingModificationCount(this.address());
        }

        @NativeType(value="XrBindingModificationBaseHeaderKHR const * const *")
        public @Nullable PointerBuffer bindingModifications() {
            return XrBindingModificationsKHR.nbindingModifications(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrBindingModificationsKHR.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000120000);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrBindingModificationsKHR.nnext(this.address(), value);
            return this;
        }

        public Buffer bindingModificationCount(@NativeType(value="uint32_t") int value) {
            XrBindingModificationsKHR.nbindingModificationCount(this.address(), value);
            return this;
        }

        public Buffer bindingModifications(@NativeType(value="XrBindingModificationBaseHeaderKHR const * const *") @Nullable PointerBuffer value) {
            XrBindingModificationsKHR.nbindingModifications(this.address(), value);
            return this;
        }
    }
}

