/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrSpace;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrBodyJointsLocateInfoFB
extends Struct<XrBodyJointsLocateInfoFB>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int BASESPACE;
    public static final int TIME;

    protected XrBodyJointsLocateInfoFB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrBodyJointsLocateInfoFB create(long address, @Nullable ByteBuffer container) {
        return new XrBodyJointsLocateInfoFB(address, container);
    }

    public XrBodyJointsLocateInfoFB(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrBodyJointsLocateInfoFB.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrBodyJointsLocateInfoFB.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrBodyJointsLocateInfoFB.nnext(this.address());
    }

    @NativeType(value="XrSpace")
    public long baseSpace() {
        return XrBodyJointsLocateInfoFB.nbaseSpace(this.address());
    }

    @NativeType(value="XrTime")
    public long time() {
        return XrBodyJointsLocateInfoFB.ntime(this.address());
    }

    public XrBodyJointsLocateInfoFB type(@NativeType(value="XrStructureType") int value) {
        XrBodyJointsLocateInfoFB.ntype(this.address(), value);
        return this;
    }

    public XrBodyJointsLocateInfoFB type$Default() {
        return this.type(1000076002);
    }

    public XrBodyJointsLocateInfoFB next(@NativeType(value="void const *") long value) {
        XrBodyJointsLocateInfoFB.nnext(this.address(), value);
        return this;
    }

    public XrBodyJointsLocateInfoFB baseSpace(XrSpace value) {
        XrBodyJointsLocateInfoFB.nbaseSpace(this.address(), value);
        return this;
    }

    public XrBodyJointsLocateInfoFB time(@NativeType(value="XrTime") long value) {
        XrBodyJointsLocateInfoFB.ntime(this.address(), value);
        return this;
    }

    public XrBodyJointsLocateInfoFB set(int type, long next, XrSpace baseSpace, long time) {
        this.type(type);
        this.next(next);
        this.baseSpace(baseSpace);
        this.time(time);
        return this;
    }

    public XrBodyJointsLocateInfoFB set(XrBodyJointsLocateInfoFB src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrBodyJointsLocateInfoFB malloc() {
        return new XrBodyJointsLocateInfoFB(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrBodyJointsLocateInfoFB calloc() {
        return new XrBodyJointsLocateInfoFB(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrBodyJointsLocateInfoFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrBodyJointsLocateInfoFB(MemoryUtil.memAddress(container), container);
    }

    public static XrBodyJointsLocateInfoFB create(long address) {
        return new XrBodyJointsLocateInfoFB(address, null);
    }

    public static @Nullable XrBodyJointsLocateInfoFB createSafe(long address) {
        return address == 0L ? null : new XrBodyJointsLocateInfoFB(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrBodyJointsLocateInfoFB.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrBodyJointsLocateInfoFB.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrBodyJointsLocateInfoFB malloc(MemoryStack stack) {
        return new XrBodyJointsLocateInfoFB(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrBodyJointsLocateInfoFB calloc(MemoryStack stack) {
        return new XrBodyJointsLocateInfoFB(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long nbaseSpace(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)BASESPACE);
    }

    public static long ntime(long struct) {
        return MemoryUtil.memGetLong(struct + (long)TIME);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nbaseSpace(long struct, XrSpace value) {
        MemoryUtil.memPutAddress(struct + (long)BASESPACE, value.address());
    }

    public static void ntime(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)TIME, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)BASESPACE));
    }

    static {
        Struct.Layout layout = XrBodyJointsLocateInfoFB.__struct(XrBodyJointsLocateInfoFB.__member(4), XrBodyJointsLocateInfoFB.__member(POINTER_SIZE), XrBodyJointsLocateInfoFB.__member(POINTER_SIZE), XrBodyJointsLocateInfoFB.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        BASESPACE = layout.offsetof(2);
        TIME = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrBodyJointsLocateInfoFB, Buffer>
    implements NativeResource {
        private static final XrBodyJointsLocateInfoFB ELEMENT_FACTORY = XrBodyJointsLocateInfoFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrBodyJointsLocateInfoFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrBodyJointsLocateInfoFB.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrBodyJointsLocateInfoFB.nnext(this.address());
        }

        @NativeType(value="XrSpace")
        public long baseSpace() {
            return XrBodyJointsLocateInfoFB.nbaseSpace(this.address());
        }

        @NativeType(value="XrTime")
        public long time() {
            return XrBodyJointsLocateInfoFB.ntime(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrBodyJointsLocateInfoFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000076002);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrBodyJointsLocateInfoFB.nnext(this.address(), value);
            return this;
        }

        public Buffer baseSpace(XrSpace value) {
            XrBodyJointsLocateInfoFB.nbaseSpace(this.address(), value);
            return this;
        }

        public Buffer time(@NativeType(value="XrTime") long value) {
            XrBodyJointsLocateInfoFB.ntime(this.address(), value);
            return this;
        }
    }
}

