/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrColor3f;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class XrColor3fKHR
extends XrColor3f {
    protected XrColor3fKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrColor3fKHR create(long address, @Nullable ByteBuffer container) {
        return new XrColor3fKHR(address, container);
    }

    public XrColor3fKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public XrColor3fKHR r(float value) {
        XrColor3fKHR.nr(this.address(), value);
        return this;
    }

    @Override
    public XrColor3fKHR g(float value) {
        XrColor3fKHR.ng(this.address(), value);
        return this;
    }

    @Override
    public XrColor3fKHR b(float value) {
        XrColor3fKHR.nb(this.address(), value);
        return this;
    }

    @Override
    public XrColor3fKHR set(float r, float g, float b) {
        this.r(r);
        this.g(g);
        this.b(b);
        return this;
    }

    public XrColor3fKHR set(XrColor3fKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrColor3fKHR malloc() {
        return new XrColor3fKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrColor3fKHR calloc() {
        return new XrColor3fKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrColor3fKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrColor3fKHR(MemoryUtil.memAddress(container), container);
    }

    public static XrColor3fKHR create(long address) {
        return new XrColor3fKHR(address, null);
    }

    public static @Nullable XrColor3fKHR createSafe(long address) {
        return address == 0L ? null : new XrColor3fKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrColor3fKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrColor3fKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrColor3fKHR malloc(MemoryStack stack) {
        return new XrColor3fKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrColor3fKHR calloc(MemoryStack stack) {
        return new XrColor3fKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends XrColor3f.Buffer {
        private static final XrColor3fKHR ELEMENT_FACTORY = XrColor3fKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrColor3fKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer r(float value) {
            XrColor3fKHR.nr(this.address(), value);
            return this;
        }

        @Override
        public Buffer g(float value) {
            XrColor3fKHR.ng(this.address(), value);
            return this;
        }

        @Override
        public Buffer b(float value) {
            XrColor3fKHR.nb(this.address(), value);
            return this;
        }
    }
}

