/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrCompositionLayerBaseHeader;
import org.lwjgl.openxr.XrPassthroughLayerFB;
import org.lwjgl.openxr.XrSpace;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrCompositionLayerPassthroughFB
extends Struct<XrCompositionLayerPassthroughFB>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int FLAGS;
    public static final int SPACE;
    public static final int LAYERHANDLE;

    protected XrCompositionLayerPassthroughFB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrCompositionLayerPassthroughFB create(long address, @Nullable ByteBuffer container) {
        return new XrCompositionLayerPassthroughFB(address, container);
    }

    public XrCompositionLayerPassthroughFB(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrCompositionLayerPassthroughFB.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrCompositionLayerPassthroughFB.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrCompositionLayerPassthroughFB.nnext(this.address());
    }

    @NativeType(value="XrCompositionLayerFlags")
    public long flags() {
        return XrCompositionLayerPassthroughFB.nflags(this.address());
    }

    @NativeType(value="XrSpace")
    public long space() {
        return XrCompositionLayerPassthroughFB.nspace(this.address());
    }

    @NativeType(value="XrPassthroughLayerFB")
    public long layerHandle() {
        return XrCompositionLayerPassthroughFB.nlayerHandle(this.address());
    }

    public XrCompositionLayerPassthroughFB type(@NativeType(value="XrStructureType") int value) {
        XrCompositionLayerPassthroughFB.ntype(this.address(), value);
        return this;
    }

    public XrCompositionLayerPassthroughFB type$Default() {
        return this.type(1000118003);
    }

    public XrCompositionLayerPassthroughFB next(@NativeType(value="void const *") long value) {
        XrCompositionLayerPassthroughFB.nnext(this.address(), value);
        return this;
    }

    public XrCompositionLayerPassthroughFB flags(@NativeType(value="XrCompositionLayerFlags") long value) {
        XrCompositionLayerPassthroughFB.nflags(this.address(), value);
        return this;
    }

    public XrCompositionLayerPassthroughFB space(XrSpace value) {
        XrCompositionLayerPassthroughFB.nspace(this.address(), value);
        return this;
    }

    public XrCompositionLayerPassthroughFB layerHandle(XrPassthroughLayerFB value) {
        XrCompositionLayerPassthroughFB.nlayerHandle(this.address(), value);
        return this;
    }

    public XrCompositionLayerPassthroughFB set(int type, long next, long flags, XrSpace space, XrPassthroughLayerFB layerHandle) {
        this.type(type);
        this.next(next);
        this.flags(flags);
        this.space(space);
        this.layerHandle(layerHandle);
        return this;
    }

    public XrCompositionLayerPassthroughFB set(XrCompositionLayerPassthroughFB src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrCompositionLayerPassthroughFB malloc() {
        return new XrCompositionLayerPassthroughFB(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrCompositionLayerPassthroughFB calloc() {
        return new XrCompositionLayerPassthroughFB(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrCompositionLayerPassthroughFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrCompositionLayerPassthroughFB(MemoryUtil.memAddress(container), container);
    }

    public static XrCompositionLayerPassthroughFB create(long address) {
        return new XrCompositionLayerPassthroughFB(address, null);
    }

    public static @Nullable XrCompositionLayerPassthroughFB createSafe(long address) {
        return address == 0L ? null : new XrCompositionLayerPassthroughFB(address, null);
    }

    public static XrCompositionLayerPassthroughFB create(XrCompositionLayerBaseHeader value) {
        return new XrCompositionLayerPassthroughFB(value.address(), XrCompositionLayerPassthroughFB.__getContainer(value));
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrCompositionLayerPassthroughFB.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrCompositionLayerPassthroughFB.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static Buffer create(XrCompositionLayerBaseHeader.Buffer value) {
        return new Buffer(value.address(), XrCompositionLayerPassthroughFB.__getContainer(value), -1, 0, value.remaining(), value.remaining());
    }

    public static XrCompositionLayerPassthroughFB malloc(MemoryStack stack) {
        return new XrCompositionLayerPassthroughFB(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrCompositionLayerPassthroughFB calloc(MemoryStack stack) {
        return new XrCompositionLayerPassthroughFB(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long nflags(long struct) {
        return MemoryUtil.memGetLong(struct + (long)FLAGS);
    }

    public static long nspace(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SPACE);
    }

    public static long nlayerHandle(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)LAYERHANDLE);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nflags(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)FLAGS, value);
    }

    public static void nspace(long struct, XrSpace value) {
        MemoryUtil.memPutAddress(struct + (long)SPACE, value.address());
    }

    public static void nlayerHandle(long struct, XrPassthroughLayerFB value) {
        MemoryUtil.memPutAddress(struct + (long)LAYERHANDLE, value.address());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)SPACE));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)LAYERHANDLE));
    }

    static {
        Struct.Layout layout = XrCompositionLayerPassthroughFB.__struct(XrCompositionLayerPassthroughFB.__member(4), XrCompositionLayerPassthroughFB.__member(POINTER_SIZE), XrCompositionLayerPassthroughFB.__member(8), XrCompositionLayerPassthroughFB.__member(POINTER_SIZE), XrCompositionLayerPassthroughFB.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        SPACE = layout.offsetof(3);
        LAYERHANDLE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrCompositionLayerPassthroughFB, Buffer>
    implements NativeResource {
        private static final XrCompositionLayerPassthroughFB ELEMENT_FACTORY = XrCompositionLayerPassthroughFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrCompositionLayerPassthroughFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrCompositionLayerPassthroughFB.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrCompositionLayerPassthroughFB.nnext(this.address());
        }

        @NativeType(value="XrCompositionLayerFlags")
        public long flags() {
            return XrCompositionLayerPassthroughFB.nflags(this.address());
        }

        @NativeType(value="XrSpace")
        public long space() {
            return XrCompositionLayerPassthroughFB.nspace(this.address());
        }

        @NativeType(value="XrPassthroughLayerFB")
        public long layerHandle() {
            return XrCompositionLayerPassthroughFB.nlayerHandle(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrCompositionLayerPassthroughFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000118003);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrCompositionLayerPassthroughFB.nnext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="XrCompositionLayerFlags") long value) {
            XrCompositionLayerPassthroughFB.nflags(this.address(), value);
            return this;
        }

        public Buffer space(XrSpace value) {
            XrCompositionLayerPassthroughFB.nspace(this.address(), value);
            return this;
        }

        public Buffer layerHandle(XrPassthroughLayerFB value) {
            XrCompositionLayerPassthroughFB.nlayerHandle(this.address(), value);
            return this;
        }
    }
}

