/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrCompositionLayerBaseHeader;
import org.lwjgl.openxr.XrPassthroughColorHTC;
import org.lwjgl.openxr.XrPassthroughHTC;
import org.lwjgl.openxr.XrPassthroughMeshTransformInfoHTC;
import org.lwjgl.openxr.XrSpace;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrCompositionLayerPassthroughHTC
extends Struct<XrCompositionLayerPassthroughHTC>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int LAYERFLAGS;
    public static final int SPACE;
    public static final int PASSTHROUGH;
    public static final int COLOR;

    protected XrCompositionLayerPassthroughHTC(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrCompositionLayerPassthroughHTC create(long address, @Nullable ByteBuffer container) {
        return new XrCompositionLayerPassthroughHTC(address, container);
    }

    public XrCompositionLayerPassthroughHTC(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrCompositionLayerPassthroughHTC.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrCompositionLayerPassthroughHTC.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrCompositionLayerPassthroughHTC.nnext(this.address());
    }

    @NativeType(value="XrCompositionLayerFlags")
    public long layerFlags() {
        return XrCompositionLayerPassthroughHTC.nlayerFlags(this.address());
    }

    @NativeType(value="XrSpace")
    public long space() {
        return XrCompositionLayerPassthroughHTC.nspace(this.address());
    }

    @NativeType(value="XrPassthroughHTC")
    public long passthrough() {
        return XrCompositionLayerPassthroughHTC.npassthrough(this.address());
    }

    public XrPassthroughColorHTC color() {
        return XrCompositionLayerPassthroughHTC.ncolor(this.address());
    }

    public XrCompositionLayerPassthroughHTC type(@NativeType(value="XrStructureType") int value) {
        XrCompositionLayerPassthroughHTC.ntype(this.address(), value);
        return this;
    }

    public XrCompositionLayerPassthroughHTC type$Default() {
        return this.type(1000317004);
    }

    public XrCompositionLayerPassthroughHTC next(@NativeType(value="void const *") long value) {
        XrCompositionLayerPassthroughHTC.nnext(this.address(), value);
        return this;
    }

    public XrCompositionLayerPassthroughHTC next(XrPassthroughMeshTransformInfoHTC value) {
        return this.next(value.next(this.next()).address());
    }

    public XrCompositionLayerPassthroughHTC layerFlags(@NativeType(value="XrCompositionLayerFlags") long value) {
        XrCompositionLayerPassthroughHTC.nlayerFlags(this.address(), value);
        return this;
    }

    public XrCompositionLayerPassthroughHTC space(XrSpace value) {
        XrCompositionLayerPassthroughHTC.nspace(this.address(), value);
        return this;
    }

    public XrCompositionLayerPassthroughHTC passthrough(XrPassthroughHTC value) {
        XrCompositionLayerPassthroughHTC.npassthrough(this.address(), value);
        return this;
    }

    public XrCompositionLayerPassthroughHTC color(XrPassthroughColorHTC value) {
        XrCompositionLayerPassthroughHTC.ncolor(this.address(), value);
        return this;
    }

    public XrCompositionLayerPassthroughHTC color(Consumer<XrPassthroughColorHTC> consumer) {
        consumer.accept(this.color());
        return this;
    }

    public XrCompositionLayerPassthroughHTC set(int type, long next, long layerFlags, XrSpace space, XrPassthroughHTC passthrough, XrPassthroughColorHTC color) {
        this.type(type);
        this.next(next);
        this.layerFlags(layerFlags);
        this.space(space);
        this.passthrough(passthrough);
        this.color(color);
        return this;
    }

    public XrCompositionLayerPassthroughHTC set(XrCompositionLayerPassthroughHTC src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrCompositionLayerPassthroughHTC malloc() {
        return new XrCompositionLayerPassthroughHTC(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrCompositionLayerPassthroughHTC calloc() {
        return new XrCompositionLayerPassthroughHTC(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrCompositionLayerPassthroughHTC create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrCompositionLayerPassthroughHTC(MemoryUtil.memAddress(container), container);
    }

    public static XrCompositionLayerPassthroughHTC create(long address) {
        return new XrCompositionLayerPassthroughHTC(address, null);
    }

    public static @Nullable XrCompositionLayerPassthroughHTC createSafe(long address) {
        return address == 0L ? null : new XrCompositionLayerPassthroughHTC(address, null);
    }

    public static XrCompositionLayerPassthroughHTC create(XrCompositionLayerBaseHeader value) {
        return new XrCompositionLayerPassthroughHTC(value.address(), XrCompositionLayerPassthroughHTC.__getContainer(value));
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrCompositionLayerPassthroughHTC.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrCompositionLayerPassthroughHTC.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static Buffer create(XrCompositionLayerBaseHeader.Buffer value) {
        return new Buffer(value.address(), XrCompositionLayerPassthroughHTC.__getContainer(value), -1, 0, value.remaining(), value.remaining());
    }

    public static XrCompositionLayerPassthroughHTC malloc(MemoryStack stack) {
        return new XrCompositionLayerPassthroughHTC(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrCompositionLayerPassthroughHTC calloc(MemoryStack stack) {
        return new XrCompositionLayerPassthroughHTC(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long nlayerFlags(long struct) {
        return MemoryUtil.memGetLong(struct + (long)LAYERFLAGS);
    }

    public static long nspace(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SPACE);
    }

    public static long npassthrough(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PASSTHROUGH);
    }

    public static XrPassthroughColorHTC ncolor(long struct) {
        return XrPassthroughColorHTC.create(struct + (long)COLOR);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nlayerFlags(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)LAYERFLAGS, value);
    }

    public static void nspace(long struct, XrSpace value) {
        MemoryUtil.memPutAddress(struct + (long)SPACE, value.address());
    }

    public static void npassthrough(long struct, XrPassthroughHTC value) {
        MemoryUtil.memPutAddress(struct + (long)PASSTHROUGH, value.address());
    }

    public static void ncolor(long struct, XrPassthroughColorHTC value) {
        MemoryUtil.memCopy(value.address(), struct + (long)COLOR, XrPassthroughColorHTC.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)SPACE));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PASSTHROUGH));
    }

    static {
        Struct.Layout layout = XrCompositionLayerPassthroughHTC.__struct(XrCompositionLayerPassthroughHTC.__member(4), XrCompositionLayerPassthroughHTC.__member(POINTER_SIZE), XrCompositionLayerPassthroughHTC.__member(8), XrCompositionLayerPassthroughHTC.__member(POINTER_SIZE), XrCompositionLayerPassthroughHTC.__member(POINTER_SIZE), XrCompositionLayerPassthroughHTC.__member(XrPassthroughColorHTC.SIZEOF, XrPassthroughColorHTC.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        LAYERFLAGS = layout.offsetof(2);
        SPACE = layout.offsetof(3);
        PASSTHROUGH = layout.offsetof(4);
        COLOR = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<XrCompositionLayerPassthroughHTC, Buffer>
    implements NativeResource {
        private static final XrCompositionLayerPassthroughHTC ELEMENT_FACTORY = XrCompositionLayerPassthroughHTC.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrCompositionLayerPassthroughHTC getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrCompositionLayerPassthroughHTC.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrCompositionLayerPassthroughHTC.nnext(this.address());
        }

        @NativeType(value="XrCompositionLayerFlags")
        public long layerFlags() {
            return XrCompositionLayerPassthroughHTC.nlayerFlags(this.address());
        }

        @NativeType(value="XrSpace")
        public long space() {
            return XrCompositionLayerPassthroughHTC.nspace(this.address());
        }

        @NativeType(value="XrPassthroughHTC")
        public long passthrough() {
            return XrCompositionLayerPassthroughHTC.npassthrough(this.address());
        }

        public XrPassthroughColorHTC color() {
            return XrCompositionLayerPassthroughHTC.ncolor(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrCompositionLayerPassthroughHTC.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000317004);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrCompositionLayerPassthroughHTC.nnext(this.address(), value);
            return this;
        }

        public Buffer next(XrPassthroughMeshTransformInfoHTC value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer layerFlags(@NativeType(value="XrCompositionLayerFlags") long value) {
            XrCompositionLayerPassthroughHTC.nlayerFlags(this.address(), value);
            return this;
        }

        public Buffer space(XrSpace value) {
            XrCompositionLayerPassthroughHTC.nspace(this.address(), value);
            return this;
        }

        public Buffer passthrough(XrPassthroughHTC value) {
            XrCompositionLayerPassthroughHTC.npassthrough(this.address(), value);
            return this;
        }

        public Buffer color(XrPassthroughColorHTC value) {
            XrCompositionLayerPassthroughHTC.ncolor(this.address(), value);
            return this;
        }

        public Buffer color(Consumer<XrPassthroughColorHTC> consumer) {
            consumer.accept(this.color());
            return this;
        }
    }
}

