/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrControllerModelNodeStateMSFT;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrControllerModelStateMSFT
extends Struct<XrControllerModelStateMSFT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int NODECAPACITYINPUT;
    public static final int NODECOUNTOUTPUT;
    public static final int NODESTATES;

    protected XrControllerModelStateMSFT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrControllerModelStateMSFT create(long address, @Nullable ByteBuffer container) {
        return new XrControllerModelStateMSFT(address, container);
    }

    public XrControllerModelStateMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrControllerModelStateMSFT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrControllerModelStateMSFT.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrControllerModelStateMSFT.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int nodeCapacityInput() {
        return XrControllerModelStateMSFT.nnodeCapacityInput(this.address());
    }

    @NativeType(value="uint32_t")
    public int nodeCountOutput() {
        return XrControllerModelStateMSFT.nnodeCountOutput(this.address());
    }

    @NativeType(value="XrControllerModelNodeStateMSFT *")
    public @Nullable XrControllerModelNodeStateMSFT.Buffer nodeStates() {
        return XrControllerModelStateMSFT.nnodeStates(this.address());
    }

    public XrControllerModelStateMSFT type(@NativeType(value="XrStructureType") int value) {
        XrControllerModelStateMSFT.ntype(this.address(), value);
        return this;
    }

    public XrControllerModelStateMSFT type$Default() {
        return this.type(1000055004);
    }

    public XrControllerModelStateMSFT next(@NativeType(value="void *") long value) {
        XrControllerModelStateMSFT.nnext(this.address(), value);
        return this;
    }

    public XrControllerModelStateMSFT nodeCapacityInput(@NativeType(value="uint32_t") int value) {
        XrControllerModelStateMSFT.nnodeCapacityInput(this.address(), value);
        return this;
    }

    public XrControllerModelStateMSFT nodeCountOutput(@NativeType(value="uint32_t") int value) {
        XrControllerModelStateMSFT.nnodeCountOutput(this.address(), value);
        return this;
    }

    public XrControllerModelStateMSFT nodeStates(@NativeType(value="XrControllerModelNodeStateMSFT *") @Nullable XrControllerModelNodeStateMSFT.Buffer value) {
        XrControllerModelStateMSFT.nnodeStates(this.address(), value);
        return this;
    }

    public XrControllerModelStateMSFT set(int type, long next, int nodeCapacityInput, int nodeCountOutput, @Nullable XrControllerModelNodeStateMSFT.Buffer nodeStates) {
        this.type(type);
        this.next(next);
        this.nodeCapacityInput(nodeCapacityInput);
        this.nodeCountOutput(nodeCountOutput);
        this.nodeStates(nodeStates);
        return this;
    }

    public XrControllerModelStateMSFT set(XrControllerModelStateMSFT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrControllerModelStateMSFT malloc() {
        return new XrControllerModelStateMSFT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrControllerModelStateMSFT calloc() {
        return new XrControllerModelStateMSFT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrControllerModelStateMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrControllerModelStateMSFT(MemoryUtil.memAddress(container), container);
    }

    public static XrControllerModelStateMSFT create(long address) {
        return new XrControllerModelStateMSFT(address, null);
    }

    public static @Nullable XrControllerModelStateMSFT createSafe(long address) {
        return address == 0L ? null : new XrControllerModelStateMSFT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrControllerModelStateMSFT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrControllerModelStateMSFT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrControllerModelStateMSFT malloc(MemoryStack stack) {
        return new XrControllerModelStateMSFT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrControllerModelStateMSFT calloc(MemoryStack stack) {
        return new XrControllerModelStateMSFT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nnodeCapacityInput(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NODECAPACITYINPUT);
    }

    public static int nnodeCountOutput(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NODECOUNTOUTPUT);
    }

    public static @Nullable XrControllerModelNodeStateMSFT.Buffer nnodeStates(long struct) {
        return XrControllerModelNodeStateMSFT.createSafe(MemoryUtil.memGetAddress(struct + (long)NODESTATES), XrControllerModelStateMSFT.nnodeCapacityInput(struct));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nnodeCapacityInput(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)NODECAPACITYINPUT, value);
    }

    public static void nnodeCountOutput(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)NODECOUNTOUTPUT, value);
    }

    public static void nnodeStates(long struct, @Nullable XrControllerModelNodeStateMSFT.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)NODESTATES, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            XrControllerModelStateMSFT.nnodeCapacityInput(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = XrControllerModelStateMSFT.__struct(XrControllerModelStateMSFT.__member(4), XrControllerModelStateMSFT.__member(POINTER_SIZE), XrControllerModelStateMSFT.__member(4), XrControllerModelStateMSFT.__member(4), XrControllerModelStateMSFT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        NODECAPACITYINPUT = layout.offsetof(2);
        NODECOUNTOUTPUT = layout.offsetof(3);
        NODESTATES = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrControllerModelStateMSFT, Buffer>
    implements NativeResource {
        private static final XrControllerModelStateMSFT ELEMENT_FACTORY = XrControllerModelStateMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrControllerModelStateMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrControllerModelStateMSFT.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrControllerModelStateMSFT.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int nodeCapacityInput() {
            return XrControllerModelStateMSFT.nnodeCapacityInput(this.address());
        }

        @NativeType(value="uint32_t")
        public int nodeCountOutput() {
            return XrControllerModelStateMSFT.nnodeCountOutput(this.address());
        }

        @NativeType(value="XrControllerModelNodeStateMSFT *")
        public @Nullable XrControllerModelNodeStateMSFT.Buffer nodeStates() {
            return XrControllerModelStateMSFT.nnodeStates(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrControllerModelStateMSFT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000055004);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrControllerModelStateMSFT.nnext(this.address(), value);
            return this;
        }

        public Buffer nodeCapacityInput(@NativeType(value="uint32_t") int value) {
            XrControllerModelStateMSFT.nnodeCapacityInput(this.address(), value);
            return this;
        }

        public Buffer nodeCountOutput(@NativeType(value="uint32_t") int value) {
            XrControllerModelStateMSFT.nnodeCountOutput(this.address(), value);
            return this;
        }

        public Buffer nodeStates(@NativeType(value="XrControllerModelNodeStateMSFT *") @Nullable XrControllerModelNodeStateMSFT.Buffer value) {
            XrControllerModelStateMSFT.nnodeStates(this.address(), value);
            return this;
        }
    }
}

