/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrDeserializeSceneFragmentMSFT
extends Struct<XrDeserializeSceneFragmentMSFT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BUFFERSIZE;
    public static final int BUFFER;

    protected XrDeserializeSceneFragmentMSFT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrDeserializeSceneFragmentMSFT create(long address, @Nullable ByteBuffer container) {
        return new XrDeserializeSceneFragmentMSFT(address, container);
    }

    public XrDeserializeSceneFragmentMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrDeserializeSceneFragmentMSFT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int bufferSize() {
        return XrDeserializeSceneFragmentMSFT.nbufferSize(this.address());
    }

    @NativeType(value="uint8_t const *")
    public @Nullable ByteBuffer buffer() {
        return XrDeserializeSceneFragmentMSFT.nbuffer(this.address());
    }

    public XrDeserializeSceneFragmentMSFT bufferSize(@NativeType(value="uint32_t") int value) {
        XrDeserializeSceneFragmentMSFT.nbufferSize(this.address(), value);
        return this;
    }

    public XrDeserializeSceneFragmentMSFT buffer(@NativeType(value="uint8_t const *") @Nullable ByteBuffer value) {
        XrDeserializeSceneFragmentMSFT.nbuffer(this.address(), value);
        return this;
    }

    public XrDeserializeSceneFragmentMSFT set(int bufferSize, @Nullable ByteBuffer buffer) {
        this.bufferSize(bufferSize);
        this.buffer(buffer);
        return this;
    }

    public XrDeserializeSceneFragmentMSFT set(XrDeserializeSceneFragmentMSFT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrDeserializeSceneFragmentMSFT malloc() {
        return new XrDeserializeSceneFragmentMSFT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrDeserializeSceneFragmentMSFT calloc() {
        return new XrDeserializeSceneFragmentMSFT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrDeserializeSceneFragmentMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrDeserializeSceneFragmentMSFT(MemoryUtil.memAddress(container), container);
    }

    public static XrDeserializeSceneFragmentMSFT create(long address) {
        return new XrDeserializeSceneFragmentMSFT(address, null);
    }

    public static @Nullable XrDeserializeSceneFragmentMSFT createSafe(long address) {
        return address == 0L ? null : new XrDeserializeSceneFragmentMSFT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrDeserializeSceneFragmentMSFT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrDeserializeSceneFragmentMSFT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrDeserializeSceneFragmentMSFT malloc(MemoryStack stack) {
        return new XrDeserializeSceneFragmentMSFT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrDeserializeSceneFragmentMSFT calloc(MemoryStack stack) {
        return new XrDeserializeSceneFragmentMSFT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nbufferSize(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BUFFERSIZE);
    }

    public static @Nullable ByteBuffer nbuffer(long struct) {
        return MemoryUtil.memByteBufferSafe(MemoryUtil.memGetAddress(struct + (long)BUFFER), XrDeserializeSceneFragmentMSFT.nbufferSize(struct));
    }

    public static void nbufferSize(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BUFFERSIZE, value);
    }

    public static void nbuffer(long struct, @Nullable ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)BUFFER, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            XrDeserializeSceneFragmentMSFT.nbufferSize(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = XrDeserializeSceneFragmentMSFT.__struct(XrDeserializeSceneFragmentMSFT.__member(4), XrDeserializeSceneFragmentMSFT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BUFFERSIZE = layout.offsetof(0);
        BUFFER = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrDeserializeSceneFragmentMSFT, Buffer>
    implements NativeResource {
        private static final XrDeserializeSceneFragmentMSFT ELEMENT_FACTORY = XrDeserializeSceneFragmentMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrDeserializeSceneFragmentMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int bufferSize() {
            return XrDeserializeSceneFragmentMSFT.nbufferSize(this.address());
        }

        @NativeType(value="uint8_t const *")
        public @Nullable ByteBuffer buffer() {
            return XrDeserializeSceneFragmentMSFT.nbuffer(this.address());
        }

        public Buffer bufferSize(@NativeType(value="uint32_t") int value) {
            XrDeserializeSceneFragmentMSFT.nbufferSize(this.address(), value);
            return this;
        }

        public Buffer buffer(@NativeType(value="uint8_t const *") @Nullable ByteBuffer value) {
            XrDeserializeSceneFragmentMSFT.nbuffer(this.address(), value);
            return this;
        }
    }
}

