/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrSpace;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrEnvironmentDepthImageAcquireInfoMETA
extends Struct<XrEnvironmentDepthImageAcquireInfoMETA>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int SPACE;
    public static final int DISPLAYTIME;

    protected XrEnvironmentDepthImageAcquireInfoMETA(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrEnvironmentDepthImageAcquireInfoMETA create(long address, @Nullable ByteBuffer container) {
        return new XrEnvironmentDepthImageAcquireInfoMETA(address, container);
    }

    public XrEnvironmentDepthImageAcquireInfoMETA(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrEnvironmentDepthImageAcquireInfoMETA.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrEnvironmentDepthImageAcquireInfoMETA.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrEnvironmentDepthImageAcquireInfoMETA.nnext(this.address());
    }

    @NativeType(value="XrSpace")
    public long space() {
        return XrEnvironmentDepthImageAcquireInfoMETA.nspace(this.address());
    }

    @NativeType(value="XrTime")
    public long displayTime() {
        return XrEnvironmentDepthImageAcquireInfoMETA.ndisplayTime(this.address());
    }

    public XrEnvironmentDepthImageAcquireInfoMETA type(@NativeType(value="XrStructureType") int value) {
        XrEnvironmentDepthImageAcquireInfoMETA.ntype(this.address(), value);
        return this;
    }

    public XrEnvironmentDepthImageAcquireInfoMETA type$Default() {
        return this.type(1000291003);
    }

    public XrEnvironmentDepthImageAcquireInfoMETA next(@NativeType(value="void const *") long value) {
        XrEnvironmentDepthImageAcquireInfoMETA.nnext(this.address(), value);
        return this;
    }

    public XrEnvironmentDepthImageAcquireInfoMETA space(XrSpace value) {
        XrEnvironmentDepthImageAcquireInfoMETA.nspace(this.address(), value);
        return this;
    }

    public XrEnvironmentDepthImageAcquireInfoMETA displayTime(@NativeType(value="XrTime") long value) {
        XrEnvironmentDepthImageAcquireInfoMETA.ndisplayTime(this.address(), value);
        return this;
    }

    public XrEnvironmentDepthImageAcquireInfoMETA set(int type, long next, XrSpace space, long displayTime) {
        this.type(type);
        this.next(next);
        this.space(space);
        this.displayTime(displayTime);
        return this;
    }

    public XrEnvironmentDepthImageAcquireInfoMETA set(XrEnvironmentDepthImageAcquireInfoMETA src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrEnvironmentDepthImageAcquireInfoMETA malloc() {
        return new XrEnvironmentDepthImageAcquireInfoMETA(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrEnvironmentDepthImageAcquireInfoMETA calloc() {
        return new XrEnvironmentDepthImageAcquireInfoMETA(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrEnvironmentDepthImageAcquireInfoMETA create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrEnvironmentDepthImageAcquireInfoMETA(MemoryUtil.memAddress(container), container);
    }

    public static XrEnvironmentDepthImageAcquireInfoMETA create(long address) {
        return new XrEnvironmentDepthImageAcquireInfoMETA(address, null);
    }

    public static @Nullable XrEnvironmentDepthImageAcquireInfoMETA createSafe(long address) {
        return address == 0L ? null : new XrEnvironmentDepthImageAcquireInfoMETA(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrEnvironmentDepthImageAcquireInfoMETA.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrEnvironmentDepthImageAcquireInfoMETA.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrEnvironmentDepthImageAcquireInfoMETA malloc(MemoryStack stack) {
        return new XrEnvironmentDepthImageAcquireInfoMETA(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrEnvironmentDepthImageAcquireInfoMETA calloc(MemoryStack stack) {
        return new XrEnvironmentDepthImageAcquireInfoMETA(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long nspace(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SPACE);
    }

    public static long ndisplayTime(long struct) {
        return MemoryUtil.memGetLong(struct + (long)DISPLAYTIME);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nspace(long struct, XrSpace value) {
        MemoryUtil.memPutAddress(struct + (long)SPACE, value.address());
    }

    public static void ndisplayTime(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)DISPLAYTIME, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)SPACE));
    }

    static {
        Struct.Layout layout = XrEnvironmentDepthImageAcquireInfoMETA.__struct(XrEnvironmentDepthImageAcquireInfoMETA.__member(4), XrEnvironmentDepthImageAcquireInfoMETA.__member(POINTER_SIZE), XrEnvironmentDepthImageAcquireInfoMETA.__member(POINTER_SIZE), XrEnvironmentDepthImageAcquireInfoMETA.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        SPACE = layout.offsetof(2);
        DISPLAYTIME = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrEnvironmentDepthImageAcquireInfoMETA, Buffer>
    implements NativeResource {
        private static final XrEnvironmentDepthImageAcquireInfoMETA ELEMENT_FACTORY = XrEnvironmentDepthImageAcquireInfoMETA.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrEnvironmentDepthImageAcquireInfoMETA getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrEnvironmentDepthImageAcquireInfoMETA.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrEnvironmentDepthImageAcquireInfoMETA.nnext(this.address());
        }

        @NativeType(value="XrSpace")
        public long space() {
            return XrEnvironmentDepthImageAcquireInfoMETA.nspace(this.address());
        }

        @NativeType(value="XrTime")
        public long displayTime() {
            return XrEnvironmentDepthImageAcquireInfoMETA.ndisplayTime(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrEnvironmentDepthImageAcquireInfoMETA.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000291003);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrEnvironmentDepthImageAcquireInfoMETA.nnext(this.address(), value);
            return this;
        }

        public Buffer space(XrSpace value) {
            XrEnvironmentDepthImageAcquireInfoMETA.nspace(this.address(), value);
            return this;
        }

        public Buffer displayTime(@NativeType(value="XrTime") long value) {
            XrEnvironmentDepthImageAcquireInfoMETA.ndisplayTime(this.address(), value);
            return this;
        }
    }
}

