/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrEventDataBaseHeader;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrEventDataReferenceSpaceChangePending
extends Struct<XrEventDataReferenceSpaceChangePending>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int SESSION;
    public static final int REFERENCESPACETYPE;
    public static final int CHANGETIME;
    public static final int POSEVALID;
    public static final int POSEINPREVIOUSSPACE;

    protected XrEventDataReferenceSpaceChangePending(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrEventDataReferenceSpaceChangePending create(long address, @Nullable ByteBuffer container) {
        return new XrEventDataReferenceSpaceChangePending(address, container);
    }

    public XrEventDataReferenceSpaceChangePending(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrEventDataReferenceSpaceChangePending.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrEventDataReferenceSpaceChangePending.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrEventDataReferenceSpaceChangePending.nnext(this.address());
    }

    @NativeType(value="XrSession")
    public long session() {
        return XrEventDataReferenceSpaceChangePending.nsession(this.address());
    }

    @NativeType(value="XrReferenceSpaceType")
    public int referenceSpaceType() {
        return XrEventDataReferenceSpaceChangePending.nreferenceSpaceType(this.address());
    }

    @NativeType(value="XrTime")
    public long changeTime() {
        return XrEventDataReferenceSpaceChangePending.nchangeTime(this.address());
    }

    @NativeType(value="XrBool32")
    public boolean poseValid() {
        return XrEventDataReferenceSpaceChangePending.nposeValid(this.address()) != 0;
    }

    public XrPosef poseInPreviousSpace() {
        return XrEventDataReferenceSpaceChangePending.nposeInPreviousSpace(this.address());
    }

    public XrEventDataReferenceSpaceChangePending type(@NativeType(value="XrStructureType") int value) {
        XrEventDataReferenceSpaceChangePending.ntype(this.address(), value);
        return this;
    }

    public XrEventDataReferenceSpaceChangePending type$Default() {
        return this.type(40);
    }

    public XrEventDataReferenceSpaceChangePending next(@NativeType(value="void const *") long value) {
        XrEventDataReferenceSpaceChangePending.nnext(this.address(), value);
        return this;
    }

    public XrEventDataReferenceSpaceChangePending set(int type, long next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrEventDataReferenceSpaceChangePending set(XrEventDataReferenceSpaceChangePending src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrEventDataReferenceSpaceChangePending malloc() {
        return new XrEventDataReferenceSpaceChangePending(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrEventDataReferenceSpaceChangePending calloc() {
        return new XrEventDataReferenceSpaceChangePending(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrEventDataReferenceSpaceChangePending create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrEventDataReferenceSpaceChangePending(MemoryUtil.memAddress(container), container);
    }

    public static XrEventDataReferenceSpaceChangePending create(long address) {
        return new XrEventDataReferenceSpaceChangePending(address, null);
    }

    public static @Nullable XrEventDataReferenceSpaceChangePending createSafe(long address) {
        return address == 0L ? null : new XrEventDataReferenceSpaceChangePending(address, null);
    }

    public static XrEventDataReferenceSpaceChangePending create(XrEventDataBaseHeader value) {
        return new XrEventDataReferenceSpaceChangePending(value.address(), XrEventDataReferenceSpaceChangePending.__getContainer(value));
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrEventDataReferenceSpaceChangePending.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrEventDataReferenceSpaceChangePending.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static Buffer create(XrEventDataBaseHeader.Buffer value) {
        return new Buffer(value.address(), XrEventDataReferenceSpaceChangePending.__getContainer(value), -1, 0, value.remaining(), value.remaining());
    }

    public static XrEventDataReferenceSpaceChangePending malloc(MemoryStack stack) {
        return new XrEventDataReferenceSpaceChangePending(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrEventDataReferenceSpaceChangePending calloc(MemoryStack stack) {
        return new XrEventDataReferenceSpaceChangePending(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long nsession(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SESSION);
    }

    public static int nreferenceSpaceType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)REFERENCESPACETYPE);
    }

    public static long nchangeTime(long struct) {
        return MemoryUtil.memGetLong(struct + (long)CHANGETIME);
    }

    public static int nposeValid(long struct) {
        return MemoryUtil.memGetInt(struct + (long)POSEVALID);
    }

    public static XrPosef nposeInPreviousSpace(long struct) {
        return XrPosef.create(struct + (long)POSEINPREVIOUSSPACE);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    static {
        Struct.Layout layout = XrEventDataReferenceSpaceChangePending.__struct(XrEventDataReferenceSpaceChangePending.__member(4), XrEventDataReferenceSpaceChangePending.__member(POINTER_SIZE), XrEventDataReferenceSpaceChangePending.__member(POINTER_SIZE), XrEventDataReferenceSpaceChangePending.__member(4), XrEventDataReferenceSpaceChangePending.__member(8), XrEventDataReferenceSpaceChangePending.__member(4), XrEventDataReferenceSpaceChangePending.__member(XrPosef.SIZEOF, XrPosef.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        SESSION = layout.offsetof(2);
        REFERENCESPACETYPE = layout.offsetof(3);
        CHANGETIME = layout.offsetof(4);
        POSEVALID = layout.offsetof(5);
        POSEINPREVIOUSSPACE = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<XrEventDataReferenceSpaceChangePending, Buffer>
    implements NativeResource {
        private static final XrEventDataReferenceSpaceChangePending ELEMENT_FACTORY = XrEventDataReferenceSpaceChangePending.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrEventDataReferenceSpaceChangePending getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrEventDataReferenceSpaceChangePending.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrEventDataReferenceSpaceChangePending.nnext(this.address());
        }

        @NativeType(value="XrSession")
        public long session() {
            return XrEventDataReferenceSpaceChangePending.nsession(this.address());
        }

        @NativeType(value="XrReferenceSpaceType")
        public int referenceSpaceType() {
            return XrEventDataReferenceSpaceChangePending.nreferenceSpaceType(this.address());
        }

        @NativeType(value="XrTime")
        public long changeTime() {
            return XrEventDataReferenceSpaceChangePending.nchangeTime(this.address());
        }

        @NativeType(value="XrBool32")
        public boolean poseValid() {
            return XrEventDataReferenceSpaceChangePending.nposeValid(this.address()) != 0;
        }

        public XrPosef poseInPreviousSpace() {
            return XrEventDataReferenceSpaceChangePending.nposeInPreviousSpace(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrEventDataReferenceSpaceChangePending.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(40);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrEventDataReferenceSpaceChangePending.nnext(this.address(), value);
            return this;
        }
    }
}

