/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrSession;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrEventDataUserPresenceChangedEXT
extends Struct<XrEventDataUserPresenceChangedEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int SESSION;
    public static final int ISUSERPRESENT;

    protected XrEventDataUserPresenceChangedEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrEventDataUserPresenceChangedEXT create(long address, @Nullable ByteBuffer container) {
        return new XrEventDataUserPresenceChangedEXT(address, container);
    }

    public XrEventDataUserPresenceChangedEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrEventDataUserPresenceChangedEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrEventDataUserPresenceChangedEXT.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrEventDataUserPresenceChangedEXT.nnext(this.address());
    }

    @NativeType(value="XrSession")
    public long session() {
        return XrEventDataUserPresenceChangedEXT.nsession(this.address());
    }

    @NativeType(value="XrBool32")
    public boolean isUserPresent() {
        return XrEventDataUserPresenceChangedEXT.nisUserPresent(this.address()) != 0;
    }

    public XrEventDataUserPresenceChangedEXT type(@NativeType(value="XrStructureType") int value) {
        XrEventDataUserPresenceChangedEXT.ntype(this.address(), value);
        return this;
    }

    public XrEventDataUserPresenceChangedEXT type$Default() {
        return this.type(1000470000);
    }

    public XrEventDataUserPresenceChangedEXT next(@NativeType(value="void const *") long value) {
        XrEventDataUserPresenceChangedEXT.nnext(this.address(), value);
        return this;
    }

    public XrEventDataUserPresenceChangedEXT session(XrSession value) {
        XrEventDataUserPresenceChangedEXT.nsession(this.address(), value);
        return this;
    }

    public XrEventDataUserPresenceChangedEXT isUserPresent(@NativeType(value="XrBool32") boolean value) {
        XrEventDataUserPresenceChangedEXT.nisUserPresent(this.address(), value ? 1 : 0);
        return this;
    }

    public XrEventDataUserPresenceChangedEXT set(int type, long next, XrSession session, boolean isUserPresent) {
        this.type(type);
        this.next(next);
        this.session(session);
        this.isUserPresent(isUserPresent);
        return this;
    }

    public XrEventDataUserPresenceChangedEXT set(XrEventDataUserPresenceChangedEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrEventDataUserPresenceChangedEXT malloc() {
        return new XrEventDataUserPresenceChangedEXT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrEventDataUserPresenceChangedEXT calloc() {
        return new XrEventDataUserPresenceChangedEXT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrEventDataUserPresenceChangedEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrEventDataUserPresenceChangedEXT(MemoryUtil.memAddress(container), container);
    }

    public static XrEventDataUserPresenceChangedEXT create(long address) {
        return new XrEventDataUserPresenceChangedEXT(address, null);
    }

    public static @Nullable XrEventDataUserPresenceChangedEXT createSafe(long address) {
        return address == 0L ? null : new XrEventDataUserPresenceChangedEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrEventDataUserPresenceChangedEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrEventDataUserPresenceChangedEXT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrEventDataUserPresenceChangedEXT malloc(MemoryStack stack) {
        return new XrEventDataUserPresenceChangedEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrEventDataUserPresenceChangedEXT calloc(MemoryStack stack) {
        return new XrEventDataUserPresenceChangedEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long nsession(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SESSION);
    }

    public static int nisUserPresent(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ISUSERPRESENT);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nsession(long struct, XrSession value) {
        MemoryUtil.memPutAddress(struct + (long)SESSION, value.address());
    }

    public static void nisUserPresent(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ISUSERPRESENT, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)SESSION));
    }

    static {
        Struct.Layout layout = XrEventDataUserPresenceChangedEXT.__struct(XrEventDataUserPresenceChangedEXT.__member(4), XrEventDataUserPresenceChangedEXT.__member(POINTER_SIZE), XrEventDataUserPresenceChangedEXT.__member(POINTER_SIZE), XrEventDataUserPresenceChangedEXT.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        SESSION = layout.offsetof(2);
        ISUSERPRESENT = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrEventDataUserPresenceChangedEXT, Buffer>
    implements NativeResource {
        private static final XrEventDataUserPresenceChangedEXT ELEMENT_FACTORY = XrEventDataUserPresenceChangedEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrEventDataUserPresenceChangedEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrEventDataUserPresenceChangedEXT.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrEventDataUserPresenceChangedEXT.nnext(this.address());
        }

        @NativeType(value="XrSession")
        public long session() {
            return XrEventDataUserPresenceChangedEXT.nsession(this.address());
        }

        @NativeType(value="XrBool32")
        public boolean isUserPresent() {
            return XrEventDataUserPresenceChangedEXT.nisUserPresent(this.address()) != 0;
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrEventDataUserPresenceChangedEXT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000470000);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrEventDataUserPresenceChangedEXT.nnext(this.address(), value);
            return this;
        }

        public Buffer session(XrSession value) {
            XrEventDataUserPresenceChangedEXT.nsession(this.address(), value);
            return this;
        }

        public Buffer isUserPresent(@NativeType(value="XrBool32") boolean value) {
            XrEventDataUserPresenceChangedEXT.nisUserPresent(this.address(), value ? 1 : 0);
            return this;
        }
    }
}

