/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrExtent2Df
extends Struct<XrExtent2Df>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int WIDTH;
    public static final int HEIGHT;

    protected XrExtent2Df(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrExtent2Df create(long address, @Nullable ByteBuffer container) {
        return new XrExtent2Df(address, container);
    }

    public XrExtent2Df(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrExtent2Df.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float width() {
        return XrExtent2Df.nwidth(this.address());
    }

    public float height() {
        return XrExtent2Df.nheight(this.address());
    }

    public XrExtent2Df width(float value) {
        XrExtent2Df.nwidth(this.address(), value);
        return this;
    }

    public XrExtent2Df height(float value) {
        XrExtent2Df.nheight(this.address(), value);
        return this;
    }

    public XrExtent2Df set(float width, float height) {
        this.width(width);
        this.height(height);
        return this;
    }

    public XrExtent2Df set(XrExtent2Df src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrExtent2Df malloc() {
        return new XrExtent2Df(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrExtent2Df calloc() {
        return new XrExtent2Df(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrExtent2Df create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrExtent2Df(MemoryUtil.memAddress(container), container);
    }

    public static XrExtent2Df create(long address) {
        return new XrExtent2Df(address, null);
    }

    public static @Nullable XrExtent2Df createSafe(long address) {
        return address == 0L ? null : new XrExtent2Df(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrExtent2Df.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrExtent2Df.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrExtent2Df malloc(MemoryStack stack) {
        return new XrExtent2Df(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrExtent2Df calloc(MemoryStack stack) {
        return new XrExtent2Df(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nwidth(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)WIDTH);
    }

    public static float nheight(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)HEIGHT);
    }

    public static void nwidth(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)WIDTH, value);
    }

    public static void nheight(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)HEIGHT, value);
    }

    static {
        Struct.Layout layout = XrExtent2Df.__struct(XrExtent2Df.__member(4), XrExtent2Df.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        WIDTH = layout.offsetof(0);
        HEIGHT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrExtent2Df, Buffer>
    implements NativeResource {
        private static final XrExtent2Df ELEMENT_FACTORY = XrExtent2Df.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrExtent2Df getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float width() {
            return XrExtent2Df.nwidth(this.address());
        }

        public float height() {
            return XrExtent2Df.nheight(this.address());
        }

        public Buffer width(float value) {
            XrExtent2Df.nwidth(this.address(), value);
            return this;
        }

        public Buffer height(float value) {
            XrExtent2Df.nheight(this.address(), value);
            return this;
        }
    }
}

