/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrExternalCameraExtrinsicsOCULUS;
import org.lwjgl.openxr.XrExternalCameraIntrinsicsOCULUS;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrExternalCameraOCULUS
extends Struct<XrExternalCameraOCULUS>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int NAME;
    public static final int INTRINSICS;
    public static final int EXTRINSICS;

    protected XrExternalCameraOCULUS(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrExternalCameraOCULUS create(long address, @Nullable ByteBuffer container) {
        return new XrExternalCameraOCULUS(address, container);
    }

    public XrExternalCameraOCULUS(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrExternalCameraOCULUS.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrExternalCameraOCULUS.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrExternalCameraOCULUS.nnext(this.address());
    }

    @NativeType(value="char[XR_MAX_EXTERNAL_CAMERA_NAME_SIZE_OCULUS]")
    public ByteBuffer name() {
        return XrExternalCameraOCULUS.nname(this.address());
    }

    @NativeType(value="char[XR_MAX_EXTERNAL_CAMERA_NAME_SIZE_OCULUS]")
    public String nameString() {
        return XrExternalCameraOCULUS.nnameString(this.address());
    }

    public XrExternalCameraIntrinsicsOCULUS intrinsics() {
        return XrExternalCameraOCULUS.nintrinsics(this.address());
    }

    public XrExternalCameraExtrinsicsOCULUS extrinsics() {
        return XrExternalCameraOCULUS.nextrinsics(this.address());
    }

    public XrExternalCameraOCULUS type(@NativeType(value="XrStructureType") int value) {
        XrExternalCameraOCULUS.ntype(this.address(), value);
        return this;
    }

    public XrExternalCameraOCULUS type$Default() {
        return this.type(1000226000);
    }

    public XrExternalCameraOCULUS next(@NativeType(value="void const *") long value) {
        XrExternalCameraOCULUS.nnext(this.address(), value);
        return this;
    }

    public XrExternalCameraOCULUS set(int type, long next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrExternalCameraOCULUS set(XrExternalCameraOCULUS src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrExternalCameraOCULUS malloc() {
        return new XrExternalCameraOCULUS(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrExternalCameraOCULUS calloc() {
        return new XrExternalCameraOCULUS(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrExternalCameraOCULUS create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrExternalCameraOCULUS(MemoryUtil.memAddress(container), container);
    }

    public static XrExternalCameraOCULUS create(long address) {
        return new XrExternalCameraOCULUS(address, null);
    }

    public static @Nullable XrExternalCameraOCULUS createSafe(long address) {
        return address == 0L ? null : new XrExternalCameraOCULUS(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrExternalCameraOCULUS.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrExternalCameraOCULUS.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrExternalCameraOCULUS malloc(MemoryStack stack) {
        return new XrExternalCameraOCULUS(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrExternalCameraOCULUS calloc(MemoryStack stack) {
        return new XrExternalCameraOCULUS(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static ByteBuffer nname(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)NAME, 32);
    }

    public static String nnameString(long struct) {
        return MemoryUtil.memUTF8(struct + (long)NAME);
    }

    public static XrExternalCameraIntrinsicsOCULUS nintrinsics(long struct) {
        return XrExternalCameraIntrinsicsOCULUS.create(struct + (long)INTRINSICS);
    }

    public static XrExternalCameraExtrinsicsOCULUS nextrinsics(long struct) {
        return XrExternalCameraExtrinsicsOCULUS.create(struct + (long)EXTRINSICS);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    static {
        Struct.Layout layout = XrExternalCameraOCULUS.__struct(XrExternalCameraOCULUS.__member(4), XrExternalCameraOCULUS.__member(POINTER_SIZE), XrExternalCameraOCULUS.__array(1, 32), XrExternalCameraOCULUS.__member(XrExternalCameraIntrinsicsOCULUS.SIZEOF, XrExternalCameraIntrinsicsOCULUS.ALIGNOF), XrExternalCameraOCULUS.__member(XrExternalCameraExtrinsicsOCULUS.SIZEOF, XrExternalCameraExtrinsicsOCULUS.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        NAME = layout.offsetof(2);
        INTRINSICS = layout.offsetof(3);
        EXTRINSICS = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrExternalCameraOCULUS, Buffer>
    implements NativeResource {
        private static final XrExternalCameraOCULUS ELEMENT_FACTORY = XrExternalCameraOCULUS.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrExternalCameraOCULUS getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrExternalCameraOCULUS.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrExternalCameraOCULUS.nnext(this.address());
        }

        @NativeType(value="char[XR_MAX_EXTERNAL_CAMERA_NAME_SIZE_OCULUS]")
        public ByteBuffer name() {
            return XrExternalCameraOCULUS.nname(this.address());
        }

        @NativeType(value="char[XR_MAX_EXTERNAL_CAMERA_NAME_SIZE_OCULUS]")
        public String nameString() {
            return XrExternalCameraOCULUS.nnameString(this.address());
        }

        public XrExternalCameraIntrinsicsOCULUS intrinsics() {
            return XrExternalCameraOCULUS.nintrinsics(this.address());
        }

        public XrExternalCameraExtrinsicsOCULUS extrinsics() {
            return XrExternalCameraOCULUS.nextrinsics(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrExternalCameraOCULUS.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000226000);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrExternalCameraOCULUS.nnext(this.address(), value);
            return this;
        }
    }
}

