/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrEyeGazeFB
extends Struct<XrEyeGazeFB>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ISVALID;
    public static final int GAZEPOSE;
    public static final int GAZECONFIDENCE;

    protected XrEyeGazeFB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrEyeGazeFB create(long address, @Nullable ByteBuffer container) {
        return new XrEyeGazeFB(address, container);
    }

    public XrEyeGazeFB(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrEyeGazeFB.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrBool32")
    public boolean isValid() {
        return XrEyeGazeFB.nisValid(this.address()) != 0;
    }

    public XrPosef gazePose() {
        return XrEyeGazeFB.ngazePose(this.address());
    }

    public float gazeConfidence() {
        return XrEyeGazeFB.ngazeConfidence(this.address());
    }

    public XrEyeGazeFB isValid(@NativeType(value="XrBool32") boolean value) {
        XrEyeGazeFB.nisValid(this.address(), value ? 1 : 0);
        return this;
    }

    public XrEyeGazeFB gazePose(XrPosef value) {
        XrEyeGazeFB.ngazePose(this.address(), value);
        return this;
    }

    public XrEyeGazeFB gazePose(Consumer<XrPosef> consumer) {
        consumer.accept(this.gazePose());
        return this;
    }

    public XrEyeGazeFB gazeConfidence(float value) {
        XrEyeGazeFB.ngazeConfidence(this.address(), value);
        return this;
    }

    public XrEyeGazeFB set(boolean isValid, XrPosef gazePose, float gazeConfidence) {
        this.isValid(isValid);
        this.gazePose(gazePose);
        this.gazeConfidence(gazeConfidence);
        return this;
    }

    public XrEyeGazeFB set(XrEyeGazeFB src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrEyeGazeFB malloc() {
        return new XrEyeGazeFB(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrEyeGazeFB calloc() {
        return new XrEyeGazeFB(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrEyeGazeFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrEyeGazeFB(MemoryUtil.memAddress(container), container);
    }

    public static XrEyeGazeFB create(long address) {
        return new XrEyeGazeFB(address, null);
    }

    public static @Nullable XrEyeGazeFB createSafe(long address) {
        return address == 0L ? null : new XrEyeGazeFB(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrEyeGazeFB.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrEyeGazeFB.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrEyeGazeFB malloc(MemoryStack stack) {
        return new XrEyeGazeFB(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrEyeGazeFB calloc(MemoryStack stack) {
        return new XrEyeGazeFB(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nisValid(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ISVALID);
    }

    public static XrPosef ngazePose(long struct) {
        return XrPosef.create(struct + (long)GAZEPOSE);
    }

    public static float ngazeConfidence(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)GAZECONFIDENCE);
    }

    public static void nisValid(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ISVALID, value);
    }

    public static void ngazePose(long struct, XrPosef value) {
        MemoryUtil.memCopy(value.address(), struct + (long)GAZEPOSE, XrPosef.SIZEOF);
    }

    public static void ngazeConfidence(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)GAZECONFIDENCE, value);
    }

    static {
        Struct.Layout layout = XrEyeGazeFB.__struct(XrEyeGazeFB.__member(4), XrEyeGazeFB.__member(XrPosef.SIZEOF, XrPosef.ALIGNOF), XrEyeGazeFB.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ISVALID = layout.offsetof(0);
        GAZEPOSE = layout.offsetof(1);
        GAZECONFIDENCE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrEyeGazeFB, Buffer>
    implements NativeResource {
        private static final XrEyeGazeFB ELEMENT_FACTORY = XrEyeGazeFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrEyeGazeFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrBool32")
        public boolean isValid() {
            return XrEyeGazeFB.nisValid(this.address()) != 0;
        }

        public XrPosef gazePose() {
            return XrEyeGazeFB.ngazePose(this.address());
        }

        public float gazeConfidence() {
            return XrEyeGazeFB.ngazeConfidence(this.address());
        }

        public Buffer isValid(@NativeType(value="XrBool32") boolean value) {
            XrEyeGazeFB.nisValid(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer gazePose(XrPosef value) {
            XrEyeGazeFB.ngazePose(this.address(), value);
            return this;
        }

        public Buffer gazePose(Consumer<XrPosef> consumer) {
            consumer.accept(this.gazePose());
            return this;
        }

        public Buffer gazeConfidence(float value) {
            XrEyeGazeFB.ngazeConfidence(this.address(), value);
            return this;
        }
    }
}

