/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrEyeGazeFB;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrEyeGazesFB
extends Struct<XrEyeGazesFB>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int GAZE;
    public static final int TIME;

    protected XrEyeGazesFB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrEyeGazesFB create(long address, @Nullable ByteBuffer container) {
        return new XrEyeGazesFB(address, container);
    }

    public XrEyeGazesFB(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrEyeGazesFB.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrEyeGazesFB.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrEyeGazesFB.nnext(this.address());
    }

    @NativeType(value="XrEyeGazeFB[XR_EYE_POSITION_COUNT_FB]")
    public XrEyeGazeFB.Buffer gaze() {
        return XrEyeGazesFB.ngaze(this.address());
    }

    public XrEyeGazeFB gaze(int index) {
        return XrEyeGazesFB.ngaze(this.address(), index);
    }

    @NativeType(value="XrTime")
    public long time() {
        return XrEyeGazesFB.ntime(this.address());
    }

    public XrEyeGazesFB type(@NativeType(value="XrStructureType") int value) {
        XrEyeGazesFB.ntype(this.address(), value);
        return this;
    }

    public XrEyeGazesFB type$Default() {
        return this.type(1000202003);
    }

    public XrEyeGazesFB next(@NativeType(value="void *") long value) {
        XrEyeGazesFB.nnext(this.address(), value);
        return this;
    }

    public XrEyeGazesFB gaze(@NativeType(value="XrEyeGazeFB[XR_EYE_POSITION_COUNT_FB]") XrEyeGazeFB.Buffer value) {
        XrEyeGazesFB.ngaze(this.address(), value);
        return this;
    }

    public XrEyeGazesFB gaze(int index, XrEyeGazeFB value) {
        XrEyeGazesFB.ngaze(this.address(), index, value);
        return this;
    }

    public XrEyeGazesFB gaze(Consumer<XrEyeGazeFB.Buffer> consumer) {
        consumer.accept(this.gaze());
        return this;
    }

    public XrEyeGazesFB gaze(int index, Consumer<XrEyeGazeFB> consumer) {
        consumer.accept(this.gaze(index));
        return this;
    }

    public XrEyeGazesFB time(@NativeType(value="XrTime") long value) {
        XrEyeGazesFB.ntime(this.address(), value);
        return this;
    }

    public XrEyeGazesFB set(int type, long next, XrEyeGazeFB.Buffer gaze, long time) {
        this.type(type);
        this.next(next);
        this.gaze(gaze);
        this.time(time);
        return this;
    }

    public XrEyeGazesFB set(XrEyeGazesFB src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrEyeGazesFB malloc() {
        return new XrEyeGazesFB(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrEyeGazesFB calloc() {
        return new XrEyeGazesFB(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrEyeGazesFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrEyeGazesFB(MemoryUtil.memAddress(container), container);
    }

    public static XrEyeGazesFB create(long address) {
        return new XrEyeGazesFB(address, null);
    }

    public static @Nullable XrEyeGazesFB createSafe(long address) {
        return address == 0L ? null : new XrEyeGazesFB(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrEyeGazesFB.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrEyeGazesFB.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrEyeGazesFB malloc(MemoryStack stack) {
        return new XrEyeGazesFB(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrEyeGazesFB calloc(MemoryStack stack) {
        return new XrEyeGazesFB(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static XrEyeGazeFB.Buffer ngaze(long struct) {
        return XrEyeGazeFB.create(struct + (long)GAZE, 2);
    }

    public static XrEyeGazeFB ngaze(long struct, int index) {
        return XrEyeGazeFB.create(struct + (long)GAZE + Checks.check(index, 2) * (long)XrEyeGazeFB.SIZEOF);
    }

    public static long ntime(long struct) {
        return MemoryUtil.memGetLong(struct + (long)TIME);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void ngaze(long struct, XrEyeGazeFB.Buffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 2);
        }
        MemoryUtil.memCopy(value.address(), struct + (long)GAZE, value.remaining() * XrEyeGazeFB.SIZEOF);
    }

    public static void ngaze(long struct, int index, XrEyeGazeFB value) {
        MemoryUtil.memCopy(value.address(), struct + (long)GAZE + Checks.check(index, 2) * (long)XrEyeGazeFB.SIZEOF, XrEyeGazeFB.SIZEOF);
    }

    public static void ntime(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)TIME, value);
    }

    static {
        Struct.Layout layout = XrEyeGazesFB.__struct(XrEyeGazesFB.__member(4), XrEyeGazesFB.__member(POINTER_SIZE), XrEyeGazesFB.__array(XrEyeGazeFB.SIZEOF, XrEyeGazeFB.ALIGNOF, 2), XrEyeGazesFB.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        GAZE = layout.offsetof(2);
        TIME = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrEyeGazesFB, Buffer>
    implements NativeResource {
        private static final XrEyeGazesFB ELEMENT_FACTORY = XrEyeGazesFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrEyeGazesFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrEyeGazesFB.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrEyeGazesFB.nnext(this.address());
        }

        @NativeType(value="XrEyeGazeFB[XR_EYE_POSITION_COUNT_FB]")
        public XrEyeGazeFB.Buffer gaze() {
            return XrEyeGazesFB.ngaze(this.address());
        }

        public XrEyeGazeFB gaze(int index) {
            return XrEyeGazesFB.ngaze(this.address(), index);
        }

        @NativeType(value="XrTime")
        public long time() {
            return XrEyeGazesFB.ntime(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrEyeGazesFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000202003);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrEyeGazesFB.nnext(this.address(), value);
            return this;
        }

        public Buffer gaze(@NativeType(value="XrEyeGazeFB[XR_EYE_POSITION_COUNT_FB]") XrEyeGazeFB.Buffer value) {
            XrEyeGazesFB.ngaze(this.address(), value);
            return this;
        }

        public Buffer gaze(int index, XrEyeGazeFB value) {
            XrEyeGazesFB.ngaze(this.address(), index, value);
            return this;
        }

        public Buffer gaze(Consumer<XrEyeGazeFB.Buffer> consumer) {
            consumer.accept(this.gaze());
            return this;
        }

        public Buffer gaze(int index, Consumer<XrEyeGazeFB> consumer) {
            consumer.accept(this.gaze(index));
            return this;
        }

        public Buffer time(@NativeType(value="XrTime") long value) {
            XrEyeGazesFB.ntime(this.address(), value);
            return this;
        }
    }
}

