/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrFrameEndInfoML
extends Struct<XrFrameEndInfoML>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int FOCUSDISTANCE;
    public static final int FLAGS;

    protected XrFrameEndInfoML(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrFrameEndInfoML create(long address, @Nullable ByteBuffer container) {
        return new XrFrameEndInfoML(address, container);
    }

    public XrFrameEndInfoML(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrFrameEndInfoML.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrFrameEndInfoML.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrFrameEndInfoML.nnext(this.address());
    }

    public float focusDistance() {
        return XrFrameEndInfoML.nfocusDistance(this.address());
    }

    @NativeType(value="XrFrameEndInfoFlagsML")
    public long flags() {
        return XrFrameEndInfoML.nflags(this.address());
    }

    public XrFrameEndInfoML type(@NativeType(value="XrStructureType") int value) {
        XrFrameEndInfoML.ntype(this.address(), value);
        return this;
    }

    public XrFrameEndInfoML type$Default() {
        return this.type(1000135000);
    }

    public XrFrameEndInfoML next(@NativeType(value="void const *") long value) {
        XrFrameEndInfoML.nnext(this.address(), value);
        return this;
    }

    public XrFrameEndInfoML focusDistance(float value) {
        XrFrameEndInfoML.nfocusDistance(this.address(), value);
        return this;
    }

    public XrFrameEndInfoML flags(@NativeType(value="XrFrameEndInfoFlagsML") long value) {
        XrFrameEndInfoML.nflags(this.address(), value);
        return this;
    }

    public XrFrameEndInfoML set(int type, long next, float focusDistance, long flags) {
        this.type(type);
        this.next(next);
        this.focusDistance(focusDistance);
        this.flags(flags);
        return this;
    }

    public XrFrameEndInfoML set(XrFrameEndInfoML src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrFrameEndInfoML malloc() {
        return new XrFrameEndInfoML(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrFrameEndInfoML calloc() {
        return new XrFrameEndInfoML(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrFrameEndInfoML create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrFrameEndInfoML(MemoryUtil.memAddress(container), container);
    }

    public static XrFrameEndInfoML create(long address) {
        return new XrFrameEndInfoML(address, null);
    }

    public static @Nullable XrFrameEndInfoML createSafe(long address) {
        return address == 0L ? null : new XrFrameEndInfoML(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrFrameEndInfoML.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrFrameEndInfoML.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrFrameEndInfoML malloc(MemoryStack stack) {
        return new XrFrameEndInfoML(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrFrameEndInfoML calloc(MemoryStack stack) {
        return new XrFrameEndInfoML(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static float nfocusDistance(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)FOCUSDISTANCE);
    }

    public static long nflags(long struct) {
        return MemoryUtil.memGetLong(struct + (long)FLAGS);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nfocusDistance(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)FOCUSDISTANCE, value);
    }

    public static void nflags(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)FLAGS, value);
    }

    static {
        Struct.Layout layout = XrFrameEndInfoML.__struct(XrFrameEndInfoML.__member(4), XrFrameEndInfoML.__member(POINTER_SIZE), XrFrameEndInfoML.__member(4), XrFrameEndInfoML.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        FOCUSDISTANCE = layout.offsetof(2);
        FLAGS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrFrameEndInfoML, Buffer>
    implements NativeResource {
        private static final XrFrameEndInfoML ELEMENT_FACTORY = XrFrameEndInfoML.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrFrameEndInfoML getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrFrameEndInfoML.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrFrameEndInfoML.nnext(this.address());
        }

        public float focusDistance() {
            return XrFrameEndInfoML.nfocusDistance(this.address());
        }

        @NativeType(value="XrFrameEndInfoFlagsML")
        public long flags() {
            return XrFrameEndInfoML.nflags(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrFrameEndInfoML.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000135000);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrFrameEndInfoML.nnext(this.address(), value);
            return this;
        }

        public Buffer focusDistance(float value) {
            XrFrameEndInfoML.nfocusDistance(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="XrFrameEndInfoFlagsML") long value) {
            XrFrameEndInfoML.nflags(this.address(), value);
            return this;
        }
    }
}

