/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrFovf;
import org.lwjgl.openxr.XrFrustumf;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class XrFrustumfKHR
extends XrFrustumf {
    protected XrFrustumfKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrFrustumfKHR create(long address, @Nullable ByteBuffer container) {
        return new XrFrustumfKHR(address, container);
    }

    public XrFrustumfKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public XrFrustumfKHR pose(XrPosef value) {
        XrFrustumfKHR.npose(this.address(), value);
        return this;
    }

    @Override
    public XrFrustumfKHR pose(Consumer<XrPosef> consumer) {
        consumer.accept(this.pose());
        return this;
    }

    @Override
    public XrFrustumfKHR fov(XrFovf value) {
        XrFrustumfKHR.nfov(this.address(), value);
        return this;
    }

    @Override
    public XrFrustumfKHR fov(Consumer<XrFovf> consumer) {
        consumer.accept(this.fov());
        return this;
    }

    @Override
    public XrFrustumfKHR nearZ(float value) {
        XrFrustumfKHR.nnearZ(this.address(), value);
        return this;
    }

    @Override
    public XrFrustumfKHR farZ(float value) {
        XrFrustumfKHR.nfarZ(this.address(), value);
        return this;
    }

    @Override
    public XrFrustumfKHR set(XrPosef pose, XrFovf fov, float nearZ, float farZ) {
        this.pose(pose);
        this.fov(fov);
        this.nearZ(nearZ);
        this.farZ(farZ);
        return this;
    }

    public XrFrustumfKHR set(XrFrustumfKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrFrustumfKHR malloc() {
        return new XrFrustumfKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrFrustumfKHR calloc() {
        return new XrFrustumfKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrFrustumfKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrFrustumfKHR(MemoryUtil.memAddress(container), container);
    }

    public static XrFrustumfKHR create(long address) {
        return new XrFrustumfKHR(address, null);
    }

    public static @Nullable XrFrustumfKHR createSafe(long address) {
        return address == 0L ? null : new XrFrustumfKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrFrustumfKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrFrustumfKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrFrustumfKHR malloc(MemoryStack stack) {
        return new XrFrustumfKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrFrustumfKHR calloc(MemoryStack stack) {
        return new XrFrustumfKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends XrFrustumf.Buffer {
        private static final XrFrustumfKHR ELEMENT_FACTORY = XrFrustumfKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrFrustumfKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer pose(XrPosef value) {
            XrFrustumfKHR.npose(this.address(), value);
            return this;
        }

        @Override
        public Buffer pose(Consumer<XrPosef> consumer) {
            consumer.accept(this.pose());
            return this;
        }

        @Override
        public Buffer fov(XrFovf value) {
            XrFrustumfKHR.nfov(this.address(), value);
            return this;
        }

        @Override
        public Buffer fov(Consumer<XrFovf> consumer) {
            consumer.accept(this.fov());
            return this;
        }

        @Override
        public Buffer nearZ(float value) {
            XrFrustumfKHR.nnearZ(this.address(), value);
            return this;
        }

        @Override
        public Buffer farZ(float value) {
            XrFrustumfKHR.nfarZ(this.address(), value);
            return this;
        }
    }
}

