/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrFutureCompletionBaseHeaderEXT;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrFutureCompletionEXT
extends Struct<XrFutureCompletionEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int FUTURERESULT;

    protected XrFutureCompletionEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrFutureCompletionEXT create(long address, @Nullable ByteBuffer container) {
        return new XrFutureCompletionEXT(address, container);
    }

    public XrFutureCompletionEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrFutureCompletionEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrFutureCompletionEXT.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrFutureCompletionEXT.nnext(this.address());
    }

    @NativeType(value="XrResult")
    public int futureResult() {
        return XrFutureCompletionEXT.nfutureResult(this.address());
    }

    public XrFutureCompletionEXT type(@NativeType(value="XrStructureType") int value) {
        XrFutureCompletionEXT.ntype(this.address(), value);
        return this;
    }

    public XrFutureCompletionEXT type$Default() {
        return this.type(1000469002);
    }

    public XrFutureCompletionEXT next(@NativeType(value="void *") long value) {
        XrFutureCompletionEXT.nnext(this.address(), value);
        return this;
    }

    public XrFutureCompletionEXT futureResult(@NativeType(value="XrResult") int value) {
        XrFutureCompletionEXT.nfutureResult(this.address(), value);
        return this;
    }

    public XrFutureCompletionEXT set(int type, long next, int futureResult) {
        this.type(type);
        this.next(next);
        this.futureResult(futureResult);
        return this;
    }

    public XrFutureCompletionEXT set(XrFutureCompletionEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrFutureCompletionEXT malloc() {
        return new XrFutureCompletionEXT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrFutureCompletionEXT calloc() {
        return new XrFutureCompletionEXT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrFutureCompletionEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrFutureCompletionEXT(MemoryUtil.memAddress(container), container);
    }

    public static XrFutureCompletionEXT create(long address) {
        return new XrFutureCompletionEXT(address, null);
    }

    public static @Nullable XrFutureCompletionEXT createSafe(long address) {
        return address == 0L ? null : new XrFutureCompletionEXT(address, null);
    }

    public static XrFutureCompletionEXT create(XrFutureCompletionBaseHeaderEXT value) {
        return new XrFutureCompletionEXT(value.address(), XrFutureCompletionEXT.__getContainer(value));
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrFutureCompletionEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrFutureCompletionEXT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static Buffer create(XrFutureCompletionBaseHeaderEXT.Buffer value) {
        return new Buffer(value.address(), XrFutureCompletionEXT.__getContainer(value), -1, 0, value.remaining(), value.remaining());
    }

    public static XrFutureCompletionEXT malloc(MemoryStack stack) {
        return new XrFutureCompletionEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrFutureCompletionEXT calloc(MemoryStack stack) {
        return new XrFutureCompletionEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nfutureResult(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FUTURERESULT);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nfutureResult(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FUTURERESULT, value);
    }

    static {
        Struct.Layout layout = XrFutureCompletionEXT.__struct(XrFutureCompletionEXT.__member(4), XrFutureCompletionEXT.__member(POINTER_SIZE), XrFutureCompletionEXT.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        FUTURERESULT = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrFutureCompletionEXT, Buffer>
    implements NativeResource {
        private static final XrFutureCompletionEXT ELEMENT_FACTORY = XrFutureCompletionEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrFutureCompletionEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrFutureCompletionEXT.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrFutureCompletionEXT.nnext(this.address());
        }

        @NativeType(value="XrResult")
        public int futureResult() {
            return XrFutureCompletionEXT.nfutureResult(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrFutureCompletionEXT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000469002);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrFutureCompletionEXT.nnext(this.address(), value);
            return this;
        }

        public Buffer futureResult(@NativeType(value="XrResult") int value) {
            XrFutureCompletionEXT.nfutureResult(this.address(), value);
            return this;
        }
    }
}

