/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrGlobalDimmerFrameEndInfoML
extends Struct<XrGlobalDimmerFrameEndInfoML>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int DIMMERVALUE;
    public static final int FLAGS;

    protected XrGlobalDimmerFrameEndInfoML(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrGlobalDimmerFrameEndInfoML create(long address, @Nullable ByteBuffer container) {
        return new XrGlobalDimmerFrameEndInfoML(address, container);
    }

    public XrGlobalDimmerFrameEndInfoML(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrGlobalDimmerFrameEndInfoML.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrGlobalDimmerFrameEndInfoML.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrGlobalDimmerFrameEndInfoML.nnext(this.address());
    }

    public float dimmerValue() {
        return XrGlobalDimmerFrameEndInfoML.ndimmerValue(this.address());
    }

    @NativeType(value="XrGlobalDimmerFrameEndInfoFlagsML")
    public long flags() {
        return XrGlobalDimmerFrameEndInfoML.nflags(this.address());
    }

    public XrGlobalDimmerFrameEndInfoML type(@NativeType(value="XrStructureType") int value) {
        XrGlobalDimmerFrameEndInfoML.ntype(this.address(), value);
        return this;
    }

    public XrGlobalDimmerFrameEndInfoML type$Default() {
        return this.type(1000136000);
    }

    public XrGlobalDimmerFrameEndInfoML next(@NativeType(value="void const *") long value) {
        XrGlobalDimmerFrameEndInfoML.nnext(this.address(), value);
        return this;
    }

    public XrGlobalDimmerFrameEndInfoML dimmerValue(float value) {
        XrGlobalDimmerFrameEndInfoML.ndimmerValue(this.address(), value);
        return this;
    }

    public XrGlobalDimmerFrameEndInfoML flags(@NativeType(value="XrGlobalDimmerFrameEndInfoFlagsML") long value) {
        XrGlobalDimmerFrameEndInfoML.nflags(this.address(), value);
        return this;
    }

    public XrGlobalDimmerFrameEndInfoML set(int type, long next, float dimmerValue, long flags) {
        this.type(type);
        this.next(next);
        this.dimmerValue(dimmerValue);
        this.flags(flags);
        return this;
    }

    public XrGlobalDimmerFrameEndInfoML set(XrGlobalDimmerFrameEndInfoML src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrGlobalDimmerFrameEndInfoML malloc() {
        return new XrGlobalDimmerFrameEndInfoML(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrGlobalDimmerFrameEndInfoML calloc() {
        return new XrGlobalDimmerFrameEndInfoML(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrGlobalDimmerFrameEndInfoML create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrGlobalDimmerFrameEndInfoML(MemoryUtil.memAddress(container), container);
    }

    public static XrGlobalDimmerFrameEndInfoML create(long address) {
        return new XrGlobalDimmerFrameEndInfoML(address, null);
    }

    public static @Nullable XrGlobalDimmerFrameEndInfoML createSafe(long address) {
        return address == 0L ? null : new XrGlobalDimmerFrameEndInfoML(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrGlobalDimmerFrameEndInfoML.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrGlobalDimmerFrameEndInfoML.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrGlobalDimmerFrameEndInfoML malloc(MemoryStack stack) {
        return new XrGlobalDimmerFrameEndInfoML(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrGlobalDimmerFrameEndInfoML calloc(MemoryStack stack) {
        return new XrGlobalDimmerFrameEndInfoML(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static float ndimmerValue(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)DIMMERVALUE);
    }

    public static long nflags(long struct) {
        return MemoryUtil.memGetLong(struct + (long)FLAGS);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void ndimmerValue(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)DIMMERVALUE, value);
    }

    public static void nflags(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)FLAGS, value);
    }

    static {
        Struct.Layout layout = XrGlobalDimmerFrameEndInfoML.__struct(XrGlobalDimmerFrameEndInfoML.__member(4), XrGlobalDimmerFrameEndInfoML.__member(POINTER_SIZE), XrGlobalDimmerFrameEndInfoML.__member(4), XrGlobalDimmerFrameEndInfoML.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        DIMMERVALUE = layout.offsetof(2);
        FLAGS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrGlobalDimmerFrameEndInfoML, Buffer>
    implements NativeResource {
        private static final XrGlobalDimmerFrameEndInfoML ELEMENT_FACTORY = XrGlobalDimmerFrameEndInfoML.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrGlobalDimmerFrameEndInfoML getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrGlobalDimmerFrameEndInfoML.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrGlobalDimmerFrameEndInfoML.nnext(this.address());
        }

        public float dimmerValue() {
            return XrGlobalDimmerFrameEndInfoML.ndimmerValue(this.address());
        }

        @NativeType(value="XrGlobalDimmerFrameEndInfoFlagsML")
        public long flags() {
            return XrGlobalDimmerFrameEndInfoML.nflags(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrGlobalDimmerFrameEndInfoML.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000136000);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrGlobalDimmerFrameEndInfoML.nnext(this.address(), value);
            return this;
        }

        public Buffer dimmerValue(float value) {
            XrGlobalDimmerFrameEndInfoML.ndimmerValue(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="XrGlobalDimmerFrameEndInfoFlagsML") long value) {
            XrGlobalDimmerFrameEndInfoML.nflags(this.address(), value);
            return this;
        }
    }
}

