/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.openxr.XrVector3f;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrHandCapsuleFB
extends Struct<XrHandCapsuleFB> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int POINTS;
    public static final int RADIUS;
    public static final int JOINT;

    protected XrHandCapsuleFB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrHandCapsuleFB create(long address, @Nullable ByteBuffer container) {
        return new XrHandCapsuleFB(address, container);
    }

    public XrHandCapsuleFB(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrHandCapsuleFB.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrVector3f[XR_HAND_TRACKING_CAPSULE_POINT_COUNT_FB]")
    public XrVector3f.Buffer points() {
        return XrHandCapsuleFB.npoints(this.address());
    }

    public XrVector3f points(int index) {
        return XrHandCapsuleFB.npoints(this.address(), index);
    }

    public float radius() {
        return XrHandCapsuleFB.nradius(this.address());
    }

    @NativeType(value="XrHandJointEXT")
    public int joint() {
        return XrHandCapsuleFB.njoint(this.address());
    }

    public static XrHandCapsuleFB create(long address) {
        return new XrHandCapsuleFB(address, null);
    }

    public static @Nullable XrHandCapsuleFB createSafe(long address) {
        return address == 0L ? null : new XrHandCapsuleFB(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrVector3f.Buffer npoints(long struct) {
        return XrVector3f.create(struct + (long)POINTS, 2);
    }

    public static XrVector3f npoints(long struct, int index) {
        return XrVector3f.create(struct + (long)POINTS + Checks.check(index, 2) * (long)XrVector3f.SIZEOF);
    }

    public static float nradius(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)RADIUS);
    }

    public static int njoint(long struct) {
        return MemoryUtil.memGetInt(struct + (long)JOINT);
    }

    static {
        Struct.Layout layout = XrHandCapsuleFB.__struct(XrHandCapsuleFB.__array(XrVector3f.SIZEOF, XrVector3f.ALIGNOF, 2), XrHandCapsuleFB.__member(4), XrHandCapsuleFB.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        POINTS = layout.offsetof(0);
        RADIUS = layout.offsetof(1);
        JOINT = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrHandCapsuleFB, Buffer> {
        private static final XrHandCapsuleFB ELEMENT_FACTORY = XrHandCapsuleFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrHandCapsuleFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrVector3f[XR_HAND_TRACKING_CAPSULE_POINT_COUNT_FB]")
        public XrVector3f.Buffer points() {
            return XrHandCapsuleFB.npoints(this.address());
        }

        public XrVector3f points(int index) {
            return XrHandCapsuleFB.npoints(this.address(), index);
        }

        public float radius() {
            return XrHandCapsuleFB.nradius(this.address());
        }

        @NativeType(value="XrHandJointEXT")
        public int joint() {
            return XrHandCapsuleFB.njoint(this.address());
        }
    }
}

