/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrHandJointLocationEXT;
import org.lwjgl.openxr.XrHandJointVelocitiesEXT;
import org.lwjgl.openxr.XrHandTrackingAimStateFB;
import org.lwjgl.openxr.XrHandTrackingCapsulesStateFB;
import org.lwjgl.openxr.XrHandTrackingDataSourceStateEXT;
import org.lwjgl.openxr.XrHandTrackingScaleFB;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrHandJointLocationsEXT
extends Struct<XrHandJointLocationsEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int ISACTIVE;
    public static final int JOINTCOUNT;
    public static final int JOINTLOCATIONS;

    protected XrHandJointLocationsEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrHandJointLocationsEXT create(long address, @Nullable ByteBuffer container) {
        return new XrHandJointLocationsEXT(address, container);
    }

    public XrHandJointLocationsEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrHandJointLocationsEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrHandJointLocationsEXT.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrHandJointLocationsEXT.nnext(this.address());
    }

    @NativeType(value="XrBool32")
    public boolean isActive() {
        return XrHandJointLocationsEXT.nisActive(this.address()) != 0;
    }

    @NativeType(value="uint32_t")
    public int jointCount() {
        return XrHandJointLocationsEXT.njointCount(this.address());
    }

    @NativeType(value="XrHandJointLocationEXT *")
    public XrHandJointLocationEXT.Buffer jointLocations() {
        return XrHandJointLocationsEXT.njointLocations(this.address());
    }

    public XrHandJointLocationsEXT type(@NativeType(value="XrStructureType") int value) {
        XrHandJointLocationsEXT.ntype(this.address(), value);
        return this;
    }

    public XrHandJointLocationsEXT type$Default() {
        return this.type(1000051003);
    }

    public XrHandJointLocationsEXT next(@NativeType(value="void *") long value) {
        XrHandJointLocationsEXT.nnext(this.address(), value);
        return this;
    }

    public XrHandJointLocationsEXT next(XrHandJointVelocitiesEXT value) {
        return this.next(value.next(this.next()).address());
    }

    public XrHandJointLocationsEXT next(XrHandTrackingAimStateFB value) {
        return this.next(value.next(this.next()).address());
    }

    public XrHandJointLocationsEXT next(XrHandTrackingCapsulesStateFB value) {
        return this.next(value.next(this.next()).address());
    }

    public XrHandJointLocationsEXT next(XrHandTrackingDataSourceStateEXT value) {
        return this.next(value.next(this.next()).address());
    }

    public XrHandJointLocationsEXT next(XrHandTrackingScaleFB value) {
        return this.next(value.next(this.next()).address());
    }

    public XrHandJointLocationsEXT isActive(@NativeType(value="XrBool32") boolean value) {
        XrHandJointLocationsEXT.nisActive(this.address(), value ? 1 : 0);
        return this;
    }

    public XrHandJointLocationsEXT jointLocations(@NativeType(value="XrHandJointLocationEXT *") XrHandJointLocationEXT.Buffer value) {
        XrHandJointLocationsEXT.njointLocations(this.address(), value);
        return this;
    }

    public XrHandJointLocationsEXT set(int type, long next, boolean isActive, XrHandJointLocationEXT.Buffer jointLocations) {
        this.type(type);
        this.next(next);
        this.isActive(isActive);
        this.jointLocations(jointLocations);
        return this;
    }

    public XrHandJointLocationsEXT set(XrHandJointLocationsEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrHandJointLocationsEXT malloc() {
        return new XrHandJointLocationsEXT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrHandJointLocationsEXT calloc() {
        return new XrHandJointLocationsEXT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrHandJointLocationsEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrHandJointLocationsEXT(MemoryUtil.memAddress(container), container);
    }

    public static XrHandJointLocationsEXT create(long address) {
        return new XrHandJointLocationsEXT(address, null);
    }

    public static @Nullable XrHandJointLocationsEXT createSafe(long address) {
        return address == 0L ? null : new XrHandJointLocationsEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrHandJointLocationsEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrHandJointLocationsEXT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrHandJointLocationsEXT malloc(MemoryStack stack) {
        return new XrHandJointLocationsEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrHandJointLocationsEXT calloc(MemoryStack stack) {
        return new XrHandJointLocationsEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nisActive(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ISACTIVE);
    }

    public static int njointCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)JOINTCOUNT);
    }

    public static XrHandJointLocationEXT.Buffer njointLocations(long struct) {
        return XrHandJointLocationEXT.create(MemoryUtil.memGetAddress(struct + (long)JOINTLOCATIONS), XrHandJointLocationsEXT.njointCount(struct));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nisActive(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ISACTIVE, value);
    }

    public static void njointCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)JOINTCOUNT, value);
    }

    public static void njointLocations(long struct, XrHandJointLocationEXT.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)JOINTLOCATIONS, value.address());
        XrHandJointLocationsEXT.njointCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)JOINTLOCATIONS));
    }

    static {
        Struct.Layout layout = XrHandJointLocationsEXT.__struct(XrHandJointLocationsEXT.__member(4), XrHandJointLocationsEXT.__member(POINTER_SIZE), XrHandJointLocationsEXT.__member(4), XrHandJointLocationsEXT.__member(4), XrHandJointLocationsEXT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        ISACTIVE = layout.offsetof(2);
        JOINTCOUNT = layout.offsetof(3);
        JOINTLOCATIONS = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrHandJointLocationsEXT, Buffer>
    implements NativeResource {
        private static final XrHandJointLocationsEXT ELEMENT_FACTORY = XrHandJointLocationsEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrHandJointLocationsEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrHandJointLocationsEXT.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrHandJointLocationsEXT.nnext(this.address());
        }

        @NativeType(value="XrBool32")
        public boolean isActive() {
            return XrHandJointLocationsEXT.nisActive(this.address()) != 0;
        }

        @NativeType(value="uint32_t")
        public int jointCount() {
            return XrHandJointLocationsEXT.njointCount(this.address());
        }

        @NativeType(value="XrHandJointLocationEXT *")
        public XrHandJointLocationEXT.Buffer jointLocations() {
            return XrHandJointLocationsEXT.njointLocations(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrHandJointLocationsEXT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000051003);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrHandJointLocationsEXT.nnext(this.address(), value);
            return this;
        }

        public Buffer next(XrHandJointVelocitiesEXT value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrHandTrackingAimStateFB value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrHandTrackingCapsulesStateFB value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrHandTrackingDataSourceStateEXT value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrHandTrackingScaleFB value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer isActive(@NativeType(value="XrBool32") boolean value) {
            XrHandJointLocationsEXT.nisActive(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer jointLocations(@NativeType(value="XrHandJointLocationEXT *") XrHandJointLocationEXT.Buffer value) {
            XrHandJointLocationsEXT.njointLocations(this.address(), value);
            return this;
        }
    }
}

