/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrHandMeshIndexBufferMSFT;
import org.lwjgl.openxr.XrHandMeshVertexBufferMSFT;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrHandMeshMSFT
extends Struct<XrHandMeshMSFT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int ISACTIVE;
    public static final int INDEXBUFFERCHANGED;
    public static final int VERTEXBUFFERCHANGED;
    public static final int INDEXBUFFER;
    public static final int VERTEXBUFFER;

    protected XrHandMeshMSFT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrHandMeshMSFT create(long address, @Nullable ByteBuffer container) {
        return new XrHandMeshMSFT(address, container);
    }

    public XrHandMeshMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrHandMeshMSFT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrHandMeshMSFT.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrHandMeshMSFT.nnext(this.address());
    }

    @NativeType(value="XrBool32")
    public boolean isActive() {
        return XrHandMeshMSFT.nisActive(this.address()) != 0;
    }

    @NativeType(value="XrBool32")
    public boolean indexBufferChanged() {
        return XrHandMeshMSFT.nindexBufferChanged(this.address()) != 0;
    }

    @NativeType(value="XrBool32")
    public boolean vertexBufferChanged() {
        return XrHandMeshMSFT.nvertexBufferChanged(this.address()) != 0;
    }

    public XrHandMeshIndexBufferMSFT indexBuffer() {
        return XrHandMeshMSFT.nindexBuffer(this.address());
    }

    public XrHandMeshVertexBufferMSFT vertexBuffer() {
        return XrHandMeshMSFT.nvertexBuffer(this.address());
    }

    public XrHandMeshMSFT type(@NativeType(value="XrStructureType") int value) {
        XrHandMeshMSFT.ntype(this.address(), value);
        return this;
    }

    public XrHandMeshMSFT type$Default() {
        return this.type(1000052003);
    }

    public XrHandMeshMSFT next(@NativeType(value="void *") long value) {
        XrHandMeshMSFT.nnext(this.address(), value);
        return this;
    }

    public XrHandMeshMSFT isActive(@NativeType(value="XrBool32") boolean value) {
        XrHandMeshMSFT.nisActive(this.address(), value ? 1 : 0);
        return this;
    }

    public XrHandMeshMSFT indexBufferChanged(@NativeType(value="XrBool32") boolean value) {
        XrHandMeshMSFT.nindexBufferChanged(this.address(), value ? 1 : 0);
        return this;
    }

    public XrHandMeshMSFT vertexBufferChanged(@NativeType(value="XrBool32") boolean value) {
        XrHandMeshMSFT.nvertexBufferChanged(this.address(), value ? 1 : 0);
        return this;
    }

    public XrHandMeshMSFT indexBuffer(XrHandMeshIndexBufferMSFT value) {
        XrHandMeshMSFT.nindexBuffer(this.address(), value);
        return this;
    }

    public XrHandMeshMSFT indexBuffer(Consumer<XrHandMeshIndexBufferMSFT> consumer) {
        consumer.accept(this.indexBuffer());
        return this;
    }

    public XrHandMeshMSFT vertexBuffer(XrHandMeshVertexBufferMSFT value) {
        XrHandMeshMSFT.nvertexBuffer(this.address(), value);
        return this;
    }

    public XrHandMeshMSFT vertexBuffer(Consumer<XrHandMeshVertexBufferMSFT> consumer) {
        consumer.accept(this.vertexBuffer());
        return this;
    }

    public XrHandMeshMSFT set(int type, long next, boolean isActive, boolean indexBufferChanged, boolean vertexBufferChanged, XrHandMeshIndexBufferMSFT indexBuffer, XrHandMeshVertexBufferMSFT vertexBuffer) {
        this.type(type);
        this.next(next);
        this.isActive(isActive);
        this.indexBufferChanged(indexBufferChanged);
        this.vertexBufferChanged(vertexBufferChanged);
        this.indexBuffer(indexBuffer);
        this.vertexBuffer(vertexBuffer);
        return this;
    }

    public XrHandMeshMSFT set(XrHandMeshMSFT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrHandMeshMSFT malloc() {
        return new XrHandMeshMSFT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrHandMeshMSFT calloc() {
        return new XrHandMeshMSFT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrHandMeshMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrHandMeshMSFT(MemoryUtil.memAddress(container), container);
    }

    public static XrHandMeshMSFT create(long address) {
        return new XrHandMeshMSFT(address, null);
    }

    public static @Nullable XrHandMeshMSFT createSafe(long address) {
        return address == 0L ? null : new XrHandMeshMSFT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrHandMeshMSFT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrHandMeshMSFT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrHandMeshMSFT malloc(MemoryStack stack) {
        return new XrHandMeshMSFT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrHandMeshMSFT calloc(MemoryStack stack) {
        return new XrHandMeshMSFT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nisActive(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ISACTIVE);
    }

    public static int nindexBufferChanged(long struct) {
        return MemoryUtil.memGetInt(struct + (long)INDEXBUFFERCHANGED);
    }

    public static int nvertexBufferChanged(long struct) {
        return MemoryUtil.memGetInt(struct + (long)VERTEXBUFFERCHANGED);
    }

    public static XrHandMeshIndexBufferMSFT nindexBuffer(long struct) {
        return XrHandMeshIndexBufferMSFT.create(struct + (long)INDEXBUFFER);
    }

    public static XrHandMeshVertexBufferMSFT nvertexBuffer(long struct) {
        return XrHandMeshVertexBufferMSFT.create(struct + (long)VERTEXBUFFER);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nisActive(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ISACTIVE, value);
    }

    public static void nindexBufferChanged(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)INDEXBUFFERCHANGED, value);
    }

    public static void nvertexBufferChanged(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)VERTEXBUFFERCHANGED, value);
    }

    public static void nindexBuffer(long struct, XrHandMeshIndexBufferMSFT value) {
        MemoryUtil.memCopy(value.address(), struct + (long)INDEXBUFFER, XrHandMeshIndexBufferMSFT.SIZEOF);
    }

    public static void nvertexBuffer(long struct, XrHandMeshVertexBufferMSFT value) {
        MemoryUtil.memCopy(value.address(), struct + (long)VERTEXBUFFER, XrHandMeshVertexBufferMSFT.SIZEOF);
    }

    static {
        Struct.Layout layout = XrHandMeshMSFT.__struct(XrHandMeshMSFT.__member(4), XrHandMeshMSFT.__member(POINTER_SIZE), XrHandMeshMSFT.__member(4), XrHandMeshMSFT.__member(4), XrHandMeshMSFT.__member(4), XrHandMeshMSFT.__member(XrHandMeshIndexBufferMSFT.SIZEOF, XrHandMeshIndexBufferMSFT.ALIGNOF), XrHandMeshMSFT.__member(XrHandMeshVertexBufferMSFT.SIZEOF, XrHandMeshVertexBufferMSFT.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        ISACTIVE = layout.offsetof(2);
        INDEXBUFFERCHANGED = layout.offsetof(3);
        VERTEXBUFFERCHANGED = layout.offsetof(4);
        INDEXBUFFER = layout.offsetof(5);
        VERTEXBUFFER = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<XrHandMeshMSFT, Buffer>
    implements NativeResource {
        private static final XrHandMeshMSFT ELEMENT_FACTORY = XrHandMeshMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrHandMeshMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrHandMeshMSFT.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrHandMeshMSFT.nnext(this.address());
        }

        @NativeType(value="XrBool32")
        public boolean isActive() {
            return XrHandMeshMSFT.nisActive(this.address()) != 0;
        }

        @NativeType(value="XrBool32")
        public boolean indexBufferChanged() {
            return XrHandMeshMSFT.nindexBufferChanged(this.address()) != 0;
        }

        @NativeType(value="XrBool32")
        public boolean vertexBufferChanged() {
            return XrHandMeshMSFT.nvertexBufferChanged(this.address()) != 0;
        }

        public XrHandMeshIndexBufferMSFT indexBuffer() {
            return XrHandMeshMSFT.nindexBuffer(this.address());
        }

        public XrHandMeshVertexBufferMSFT vertexBuffer() {
            return XrHandMeshMSFT.nvertexBuffer(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrHandMeshMSFT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000052003);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrHandMeshMSFT.nnext(this.address(), value);
            return this;
        }

        public Buffer isActive(@NativeType(value="XrBool32") boolean value) {
            XrHandMeshMSFT.nisActive(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer indexBufferChanged(@NativeType(value="XrBool32") boolean value) {
            XrHandMeshMSFT.nindexBufferChanged(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer vertexBufferChanged(@NativeType(value="XrBool32") boolean value) {
            XrHandMeshMSFT.nvertexBufferChanged(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer indexBuffer(XrHandMeshIndexBufferMSFT value) {
            XrHandMeshMSFT.nindexBuffer(this.address(), value);
            return this;
        }

        public Buffer indexBuffer(Consumer<XrHandMeshIndexBufferMSFT> consumer) {
            consumer.accept(this.indexBuffer());
            return this;
        }

        public Buffer vertexBuffer(XrHandMeshVertexBufferMSFT value) {
            XrHandMeshMSFT.nvertexBuffer(this.address(), value);
            return this;
        }

        public Buffer vertexBuffer(Consumer<XrHandMeshVertexBufferMSFT> consumer) {
            consumer.accept(this.vertexBuffer());
            return this;
        }
    }
}

