/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrHandPoseTypeInfoMSFT;
import org.lwjgl.openxr.XrHandTrackingDataSourceInfoEXT;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrHandTrackerCreateInfoEXT
extends Struct<XrHandTrackerCreateInfoEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int HAND;
    public static final int HANDJOINTSET;

    protected XrHandTrackerCreateInfoEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrHandTrackerCreateInfoEXT create(long address, @Nullable ByteBuffer container) {
        return new XrHandTrackerCreateInfoEXT(address, container);
    }

    public XrHandTrackerCreateInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrHandTrackerCreateInfoEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrHandTrackerCreateInfoEXT.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrHandTrackerCreateInfoEXT.nnext(this.address());
    }

    @NativeType(value="XrHandEXT")
    public int hand() {
        return XrHandTrackerCreateInfoEXT.nhand(this.address());
    }

    @NativeType(value="XrHandJointSetEXT")
    public int handJointSet() {
        return XrHandTrackerCreateInfoEXT.nhandJointSet(this.address());
    }

    public XrHandTrackerCreateInfoEXT type(@NativeType(value="XrStructureType") int value) {
        XrHandTrackerCreateInfoEXT.ntype(this.address(), value);
        return this;
    }

    public XrHandTrackerCreateInfoEXT type$Default() {
        return this.type(1000051001);
    }

    public XrHandTrackerCreateInfoEXT next(@NativeType(value="void const *") long value) {
        XrHandTrackerCreateInfoEXT.nnext(this.address(), value);
        return this;
    }

    public XrHandTrackerCreateInfoEXT next(XrHandPoseTypeInfoMSFT value) {
        return this.next(value.next(this.next()).address());
    }

    public XrHandTrackerCreateInfoEXT next(XrHandTrackingDataSourceInfoEXT value) {
        return this.next(value.next(this.next()).address());
    }

    public XrHandTrackerCreateInfoEXT hand(@NativeType(value="XrHandEXT") int value) {
        XrHandTrackerCreateInfoEXT.nhand(this.address(), value);
        return this;
    }

    public XrHandTrackerCreateInfoEXT handJointSet(@NativeType(value="XrHandJointSetEXT") int value) {
        XrHandTrackerCreateInfoEXT.nhandJointSet(this.address(), value);
        return this;
    }

    public XrHandTrackerCreateInfoEXT set(int type, long next, int hand, int handJointSet) {
        this.type(type);
        this.next(next);
        this.hand(hand);
        this.handJointSet(handJointSet);
        return this;
    }

    public XrHandTrackerCreateInfoEXT set(XrHandTrackerCreateInfoEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrHandTrackerCreateInfoEXT malloc() {
        return new XrHandTrackerCreateInfoEXT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrHandTrackerCreateInfoEXT calloc() {
        return new XrHandTrackerCreateInfoEXT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrHandTrackerCreateInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrHandTrackerCreateInfoEXT(MemoryUtil.memAddress(container), container);
    }

    public static XrHandTrackerCreateInfoEXT create(long address) {
        return new XrHandTrackerCreateInfoEXT(address, null);
    }

    public static @Nullable XrHandTrackerCreateInfoEXT createSafe(long address) {
        return address == 0L ? null : new XrHandTrackerCreateInfoEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrHandTrackerCreateInfoEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrHandTrackerCreateInfoEXT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrHandTrackerCreateInfoEXT malloc(MemoryStack stack) {
        return new XrHandTrackerCreateInfoEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrHandTrackerCreateInfoEXT calloc(MemoryStack stack) {
        return new XrHandTrackerCreateInfoEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nhand(long struct) {
        return MemoryUtil.memGetInt(struct + (long)HAND);
    }

    public static int nhandJointSet(long struct) {
        return MemoryUtil.memGetInt(struct + (long)HANDJOINTSET);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nhand(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)HAND, value);
    }

    public static void nhandJointSet(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)HANDJOINTSET, value);
    }

    static {
        Struct.Layout layout = XrHandTrackerCreateInfoEXT.__struct(XrHandTrackerCreateInfoEXT.__member(4), XrHandTrackerCreateInfoEXT.__member(POINTER_SIZE), XrHandTrackerCreateInfoEXT.__member(4), XrHandTrackerCreateInfoEXT.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        HAND = layout.offsetof(2);
        HANDJOINTSET = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrHandTrackerCreateInfoEXT, Buffer>
    implements NativeResource {
        private static final XrHandTrackerCreateInfoEXT ELEMENT_FACTORY = XrHandTrackerCreateInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrHandTrackerCreateInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrHandTrackerCreateInfoEXT.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrHandTrackerCreateInfoEXT.nnext(this.address());
        }

        @NativeType(value="XrHandEXT")
        public int hand() {
            return XrHandTrackerCreateInfoEXT.nhand(this.address());
        }

        @NativeType(value="XrHandJointSetEXT")
        public int handJointSet() {
            return XrHandTrackerCreateInfoEXT.nhandJointSet(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrHandTrackerCreateInfoEXT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000051001);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrHandTrackerCreateInfoEXT.nnext(this.address(), value);
            return this;
        }

        public Buffer next(XrHandPoseTypeInfoMSFT value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrHandTrackingDataSourceInfoEXT value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer hand(@NativeType(value="XrHandEXT") int value) {
            XrHandTrackerCreateInfoEXT.nhand(this.address(), value);
            return this;
        }

        public Buffer handJointSet(@NativeType(value="XrHandJointSetEXT") int value) {
            XrHandTrackerCreateInfoEXT.nhandJointSet(this.address(), value);
            return this;
        }
    }
}

