/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrHandTrackingAimStateFB
extends Struct<XrHandTrackingAimStateFB>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int STATUS;
    public static final int AIMPOSE;
    public static final int PINCHSTRENGTHINDEX;
    public static final int PINCHSTRENGTHMIDDLE;
    public static final int PINCHSTRENGTHRING;
    public static final int PINCHSTRENGTHLITTLE;

    protected XrHandTrackingAimStateFB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrHandTrackingAimStateFB create(long address, @Nullable ByteBuffer container) {
        return new XrHandTrackingAimStateFB(address, container);
    }

    public XrHandTrackingAimStateFB(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrHandTrackingAimStateFB.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrHandTrackingAimStateFB.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrHandTrackingAimStateFB.nnext(this.address());
    }

    @NativeType(value="XrHandTrackingAimFlagsFB")
    public long status() {
        return XrHandTrackingAimStateFB.nstatus(this.address());
    }

    public XrPosef aimPose() {
        return XrHandTrackingAimStateFB.naimPose(this.address());
    }

    public float pinchStrengthIndex() {
        return XrHandTrackingAimStateFB.npinchStrengthIndex(this.address());
    }

    public float pinchStrengthMiddle() {
        return XrHandTrackingAimStateFB.npinchStrengthMiddle(this.address());
    }

    public float pinchStrengthRing() {
        return XrHandTrackingAimStateFB.npinchStrengthRing(this.address());
    }

    public float pinchStrengthLittle() {
        return XrHandTrackingAimStateFB.npinchStrengthLittle(this.address());
    }

    public XrHandTrackingAimStateFB type(@NativeType(value="XrStructureType") int value) {
        XrHandTrackingAimStateFB.ntype(this.address(), value);
        return this;
    }

    public XrHandTrackingAimStateFB type$Default() {
        return this.type(1000111001);
    }

    public XrHandTrackingAimStateFB next(@NativeType(value="void *") long value) {
        XrHandTrackingAimStateFB.nnext(this.address(), value);
        return this;
    }

    public XrHandTrackingAimStateFB set(int type, long next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrHandTrackingAimStateFB set(XrHandTrackingAimStateFB src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrHandTrackingAimStateFB malloc() {
        return new XrHandTrackingAimStateFB(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XrHandTrackingAimStateFB calloc() {
        return new XrHandTrackingAimStateFB(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XrHandTrackingAimStateFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XrHandTrackingAimStateFB(MemoryUtil.memAddress(container), container);
    }

    public static XrHandTrackingAimStateFB create(long address) {
        return new XrHandTrackingAimStateFB(address, null);
    }

    public static @Nullable XrHandTrackingAimStateFB createSafe(long address) {
        return address == 0L ? null : new XrHandTrackingAimStateFB(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XrHandTrackingAimStateFB.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrHandTrackingAimStateFB.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrHandTrackingAimStateFB malloc(MemoryStack stack) {
        return new XrHandTrackingAimStateFB(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrHandTrackingAimStateFB calloc(MemoryStack stack) {
        return new XrHandTrackingAimStateFB(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long nstatus(long struct) {
        return MemoryUtil.memGetLong(struct + (long)STATUS);
    }

    public static XrPosef naimPose(long struct) {
        return XrPosef.create(struct + (long)AIMPOSE);
    }

    public static float npinchStrengthIndex(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)PINCHSTRENGTHINDEX);
    }

    public static float npinchStrengthMiddle(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)PINCHSTRENGTHMIDDLE);
    }

    public static float npinchStrengthRing(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)PINCHSTRENGTHRING);
    }

    public static float npinchStrengthLittle(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)PINCHSTRENGTHLITTLE);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    static {
        Struct.Layout layout = XrHandTrackingAimStateFB.__struct(XrHandTrackingAimStateFB.__member(4), XrHandTrackingAimStateFB.__member(POINTER_SIZE), XrHandTrackingAimStateFB.__member(8), XrHandTrackingAimStateFB.__member(XrPosef.SIZEOF, XrPosef.ALIGNOF), XrHandTrackingAimStateFB.__member(4), XrHandTrackingAimStateFB.__member(4), XrHandTrackingAimStateFB.__member(4), XrHandTrackingAimStateFB.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        STATUS = layout.offsetof(2);
        AIMPOSE = layout.offsetof(3);
        PINCHSTRENGTHINDEX = layout.offsetof(4);
        PINCHSTRENGTHMIDDLE = layout.offsetof(5);
        PINCHSTRENGTHRING = layout.offsetof(6);
        PINCHSTRENGTHLITTLE = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<XrHandTrackingAimStateFB, Buffer>
    implements NativeResource {
        private static final XrHandTrackingAimStateFB ELEMENT_FACTORY = XrHandTrackingAimStateFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrHandTrackingAimStateFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrHandTrackingAimStateFB.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrHandTrackingAimStateFB.nnext(this.address());
        }

        @NativeType(value="XrHandTrackingAimFlagsFB")
        public long status() {
            return XrHandTrackingAimStateFB.nstatus(this.address());
        }

        public XrPosef aimPose() {
            return XrHandTrackingAimStateFB.naimPose(this.address());
        }

        public float pinchStrengthIndex() {
            return XrHandTrackingAimStateFB.npinchStrengthIndex(this.address());
        }

        public float pinchStrengthMiddle() {
            return XrHandTrackingAimStateFB.npinchStrengthMiddle(this.address());
        }

        public float pinchStrengthRing() {
            return XrHandTrackingAimStateFB.npinchStrengthRing(this.address());
        }

        public float pinchStrengthLittle() {
            return XrHandTrackingAimStateFB.npinchStrengthLittle(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrHandTrackingAimStateFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000111001);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrHandTrackingAimStateFB.nnext(this.address(), value);
            return this;
        }
    }
}

